/*
 * Decompiled with CFR 0.152.
 */
package com.ray3k.tenpatch;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.RandomXS128;
import com.badlogic.gdx.scenes.scene2d.utils.TextureRegionDrawable;
import com.badlogic.gdx.utils.Array;
import java.util.Arrays;

public class TenPatchDrawable
extends TextureRegionDrawable {
    private static final Color temp = new Color();
    private Color color = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    private Color color1;
    private Color color2;
    private Color color3;
    private Color color4;
    public int[] horizontalStretchAreas;
    public int[] verticalStretchAreas;
    public boolean tiling;
    public float offsetX;
    public float offsetY;
    public float offsetXspeed;
    public float offsetYspeed;
    public float time;
    private final float[] verts = new float[20];
    private Array<TextureRegion> regions;
    private float frameDuration;
    private boolean autoUpdate = true;
    public int playMode = 2;
    public float scaleX = 1.0f;
    public float scaleY = 1.0f;
    public int crushMode = 0;
    public static RandomXS128 randomXS128 = new RandomXS128();
    public transient int seed = MathUtils.random(100);

    public TenPatchDrawable() {
    }

    public TenPatchDrawable(TenPatchDrawable other) {
        this.set(other);
    }

    public TenPatchDrawable(int[] horizontalStretchAreas, int[] verticalStretchAreas, boolean tiling, TextureRegion region) {
        this.horizontalStretchAreas = horizontalStretchAreas;
        this.verticalStretchAreas = verticalStretchAreas;
        this.tiling = tiling;
        this.setRegion(region);
    }

    public void set(TenPatchDrawable other) {
        this.color.set(other.color);
        this.color1 = other.color1;
        this.color2 = other.color2;
        this.color3 = other.color3;
        this.color4 = other.color4;
        this.horizontalStretchAreas = other.horizontalStretchAreas == null ? null : Arrays.copyOf(other.horizontalStretchAreas, other.horizontalStretchAreas.length);
        this.verticalStretchAreas = other.verticalStretchAreas == null ? null : Arrays.copyOf(other.verticalStretchAreas, other.verticalStretchAreas.length);
        this.tiling = other.tiling;
        this.offsetX = other.offsetX;
        this.offsetY = other.offsetY;
        this.offsetXspeed = other.offsetXspeed;
        this.offsetYspeed = other.offsetYspeed;
        this.time = other.time;
        this.regions = this.regions == null ? null : new Array<TextureRegion>(other.regions);
        this.frameDuration = other.frameDuration;
        this.autoUpdate = other.autoUpdate;
        this.playMode = other.playMode;
        this.seed = other.seed;
        this.setMinWidth(other.getMinWidth());
        this.setMinHeight(other.getMinHeight());
        this.scaleX = other.scaleX;
        this.scaleY = other.scaleY;
        this.crushMode = other.crushMode;
        this.setRegion(other.getRegion());
    }

    @Override
    public void draw(Batch batch, float x, float y, float width, float height) {
        if (this.autoUpdate) {
            this.update(Gdx.graphics.getDeltaTime(), true);
        }
        float previousValue = 0.0f;
        int[] nArray = this.horizontalStretchAreas;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            float value = nArray[i];
            if (!(value < previousValue) && !(value >= (float)this.getRegion().getRegionWidth())) continue;
            throw new InvalidPatchException();
        }
        TextureRegion region = this.getRegion();
        Texture texture = region.getTexture();
        float w = (float)region.getRegionWidth() * this.scaleX;
        float h2 = (float)region.getRegionHeight() * this.scaleY;
        float u = region.getU();
        float u2 = region.getU2();
        float v = region.getV2();
        float v2 = region.getV();
        float extraWidth = (float)MathUtils.floor(width) - w;
        float extraHeight = (float)MathUtils.floor(height) - h2;
        float originX = 0.0f;
        float originY = 0.0f;
        float totalWidthStretch = 0.0f;
        for (int i = 0; i < this.horizontalStretchAreas.length; i += 2) {
            totalWidthStretch += (float)(this.horizontalStretchAreas[i + 1] - this.horizontalStretchAreas[i] + 1);
        }
        totalWidthStretch *= this.scaleX;
        float totalHeightStretch = 0.0f;
        for (int i = 0; i < this.verticalStretchAreas.length; i += 2) {
            totalHeightStretch += (float)(this.verticalStretchAreas[i + 1] - this.verticalStretchAreas[i] + 1);
        }
        totalHeightStretch *= this.scaleY;
        int yIndex = 0;
        float texY1 = 0.0f;
        float cropAccumulatorY = 0.0f;
        while (yIndex <= this.verticalStretchAreas.length) {
            float drawV2;
            float drawU2;
            float drawV;
            float drawU;
            float widthToMakeUp;
            float drawWidth;
            float texX2;
            float drawHeight;
            float texY2 = yIndex < this.verticalStretchAreas.length ? (float)this.verticalStretchAreas[yIndex] * this.scaleY : h2;
            originX = 0.0f;
            int xIndex = 0;
            float texX1 = 0.0f;
            if (height > h2 - totalHeightStretch || this.crushMode == 3) {
                drawHeight = texY2 - texY1;
            } else if (this.crushMode == 1) {
                if (height > h2 - totalHeightStretch) {
                    drawHeight = texY2 - texY1;
                } else {
                    drawHeight = Math.min(texY2 - texY1, height - cropAccumulatorY);
                    cropAccumulatorY += drawHeight;
                }
            } else if (this.crushMode == 2) {
                if (height > h2 - totalHeightStretch) {
                    drawHeight = texY2 - texY1;
                } else {
                    float heightToMakeUp = h2 - totalHeightStretch - height - cropAccumulatorY;
                    drawHeight = texY2 - texY1 - heightToMakeUp;
                    drawHeight = MathUtils.clamp(drawHeight, 0.0f, texY2 - texY1);
                    cropAccumulatorY += MathUtils.clamp(heightToMakeUp, 0.0f, texY2 - texY1);
                }
            } else {
                drawHeight = (texY2 - texY1) * height / (h2 - totalHeightStretch);
            }
            drawHeight = Math.max(drawHeight, 0.0f);
            float cropAccumulatorX = 0.0f;
            while (xIndex <= this.horizontalStretchAreas.length) {
                float f = texX2 = xIndex < this.horizontalStretchAreas.length ? (float)this.horizontalStretchAreas[xIndex] * this.scaleX : w;
                if (width > w - totalWidthStretch || this.crushMode == 3) {
                    drawWidth = texX2 - texX1;
                } else if (this.crushMode == 1) {
                    if (width > w - totalWidthStretch) {
                        drawWidth = texX2 - texX1;
                    } else {
                        drawWidth = Math.min(texX2 - texX1, width - cropAccumulatorX);
                        cropAccumulatorX += drawWidth;
                    }
                } else if (this.crushMode == 2) {
                    if (width > w - totalWidthStretch) {
                        drawWidth = texX2 - texX1;
                    } else {
                        widthToMakeUp = w - totalWidthStretch - width - cropAccumulatorX;
                        drawWidth = texX2 - texX1 - widthToMakeUp;
                        drawWidth = MathUtils.clamp(drawWidth, 0.0f, texX2 - texX1);
                        cropAccumulatorX += MathUtils.clamp(widthToMakeUp, 0.0f, texX2 - texX1);
                    }
                } else {
                    drawWidth = (texX2 - texX1) * width / (w - totalWidthStretch);
                }
                drawWidth = Math.max(drawWidth, 0.0f);
                if (this.crushMode == 1) {
                    drawU = u + (u2 - u) * texX1 / w;
                    drawV = v + (v2 - v) * texY1 / h2;
                    drawU2 = u + (u2 - u) * Math.min(texX1 + drawWidth, texX2) / w;
                    drawV2 = v + (v2 - v) * Math.min(texY1 + drawHeight, texY2) / h2;
                } else if (this.crushMode == 2) {
                    drawU = u + (u2 - u) * Math.max(texX2 - drawWidth, texX1) / w;
                    drawV = v + (v2 - v) * Math.max(texY2 - drawHeight, texY1) / h2;
                    drawU2 = u + (u2 - u) * texX2 / w;
                    drawV2 = v + (v2 - v) * texY2 / h2;
                } else {
                    drawU = u + (u2 - u) * texX1 / w;
                    drawV = v + (v2 - v) * texY1 / h2;
                    drawU2 = u + (u2 - u) * texX2 / w;
                    drawV2 = v + (v2 - v) * texY2 / h2;
                }
                this.drawPatches(batch, texture, x, y, originX, originY, drawWidth, drawHeight, drawU, drawV, drawU2, drawV2, texX1, texX2, texY1, texY2, true, true, false, false);
                originX += drawWidth;
                if (++xIndex < this.horizontalStretchAreas.length) {
                    texX1 = texX2;
                    texX2 = (float)(this.horizontalStretchAreas[xIndex] + 1) * this.scaleX;
                    drawWidth = texX2 - texX1 + extraWidth * (texX2 - texX1) / totalWidthStretch;
                    drawWidth = Math.max(drawWidth, 0.0f);
                    drawU = u + (u2 - u) * texX1 / w;
                    drawU2 = u + (u2 - u) * texX2 / w;
                    if (this.crushMode == 2) {
                        drawV = v + (v2 - v) * Math.max(texY1, texY2 - drawHeight) / h2;
                        drawV2 = v + (v2 - v) * texY2 / h2;
                    } else {
                        drawV = v + (v2 - v) * texY1 / h2;
                        drawV2 = v + (v2 - v) * Math.min(texY1 + drawHeight, texY2) / h2;
                    }
                    if (texture.getMagFilter() == Texture.TextureFilter.Linear || texture.getMinFilter() == Texture.TextureFilter.Linear) {
                        drawU += 0.5f / (float)texture.getWidth();
                        drawU2 -= 0.5f / (float)texture.getWidth();
                    }
                    this.drawPatches(batch, texture, x, y, originX, originY, drawWidth, drawHeight, drawU, drawV, drawU2, drawV2, texX1, texX2, texY1, texY2, false, true, true, false);
                    originX += drawWidth;
                    ++xIndex;
                }
                texX1 = texX2;
            }
            originY += drawHeight;
            if (++yIndex < this.verticalStretchAreas.length) {
                texY1 = texY2;
                texY2 = (float)(this.verticalStretchAreas[yIndex] + 1) * this.scaleY;
                xIndex = 0;
                texX1 = 0.0f;
                originX = 0.0f;
                drawHeight = texY2 - texY1 + extraHeight * (texY2 - texY1) / totalHeightStretch;
                drawHeight = Math.max(drawHeight, 0.0f);
                cropAccumulatorX = 0.0f;
                while (xIndex <= this.horizontalStretchAreas.length) {
                    float f = texX2 = xIndex < this.horizontalStretchAreas.length ? (float)this.horizontalStretchAreas[xIndex] * this.scaleX : w;
                    if (width > w - totalWidthStretch || this.crushMode == 3) {
                        drawWidth = texX2 - texX1;
                    } else if (this.crushMode == 1) {
                        if (width > w - totalWidthStretch) {
                            drawWidth = texX2 - texX1;
                        } else {
                            drawWidth = Math.min(texX2 - texX1, width - cropAccumulatorX);
                            cropAccumulatorX += drawWidth;
                        }
                    } else if (this.crushMode == 2) {
                        if (width > w - totalWidthStretch) {
                            drawWidth = texX2 - texX1;
                        } else {
                            widthToMakeUp = w - totalWidthStretch - width - cropAccumulatorX;
                            drawWidth = texX2 - texX1 - widthToMakeUp;
                            drawWidth = MathUtils.clamp(drawWidth, 0.0f, texX2 - texX1);
                            cropAccumulatorX += MathUtils.clamp(widthToMakeUp, 0.0f, texX2 - texX1);
                        }
                    } else {
                        drawWidth = (texX2 - texX1) * width / (w - totalWidthStretch);
                    }
                    drawWidth = Math.max(drawWidth, 0.0f);
                    if (this.crushMode == 1) {
                        drawU = u + (u2 - u) * texX1 / w;
                        drawV = v + (v2 - v) * texY1 / h2;
                        drawU2 = u + (u2 - u) * Math.min(texX1 + drawWidth, texX2) / w;
                        drawV2 = v + (v2 - v) * texY2 / h2;
                    } else if (this.crushMode == 2) {
                        drawU = u + (u2 - u) * Math.max(texX2 - drawWidth, texX1) / w;
                        drawV = v + (v2 - v) * texY1 / h2;
                        drawU2 = u + (u2 - u) * texX2 / w;
                        drawV2 = v + (v2 - v) * texY2 / h2;
                    } else {
                        drawU = u + (u2 - u) * texX1 / w;
                        drawV = v + (v2 - v) * texY1 / h2;
                        drawU2 = u + (u2 - u) * texX2 / w;
                        drawV2 = v + (v2 - v) * texY2 / h2;
                    }
                    if (texture.getMagFilter() == Texture.TextureFilter.Linear || texture.getMinFilter() == Texture.TextureFilter.Linear) {
                        drawV -= 0.5f / (float)texture.getHeight();
                        drawV2 += 0.5f / (float)texture.getHeight();
                    }
                    this.drawPatches(batch, texture, x, y, originX, originY, drawWidth, drawHeight, drawU, drawV, drawU2, drawV2, texX1, texX2, texY1, texY2, true, false, false, true);
                    originX += drawWidth;
                    if (++xIndex < this.horizontalStretchAreas.length) {
                        texX1 = texX2;
                        texX2 = (float)(this.horizontalStretchAreas[xIndex] + 1) * this.scaleX;
                        drawWidth = texX2 - texX1 + extraWidth * (texX2 - texX1) / totalWidthStretch;
                        drawWidth = Math.max(drawWidth, 0.0f);
                        drawU = u + (u2 - u) * texX1 / w;
                        drawV = v + (v2 - v) * texY1 / h2;
                        drawU2 = u + (u2 - u) * texX2 / w;
                        drawV2 = v + (v2 - v) * texY2 / h2;
                        if (texture.getMagFilter() == Texture.TextureFilter.Linear || texture.getMinFilter() == Texture.TextureFilter.Linear) {
                            drawU += 0.5f / (float)texture.getWidth();
                            drawU2 -= 0.5f / (float)texture.getWidth();
                            drawV -= 0.5f / (float)texture.getHeight();
                            drawV2 += 0.5f / (float)texture.getHeight();
                        }
                        this.drawPatches(batch, texture, x, y, originX, originY, drawWidth, drawHeight, drawU, drawV, drawU2, drawV2, texX1, texX2, texY1, texY2, false, false, true, true);
                        originX += drawWidth;
                        ++xIndex;
                    }
                    texX1 = texX2;
                }
                originY += drawHeight;
                ++yIndex;
            }
            texY1 = texY2;
        }
    }

    private void drawPatches(Batch batch, Texture texture, float x, float y, float originX, float originY, float drawWidth, float drawHeight, float drawU, float drawV, float drawU2, float drawV2, float texX1, float texX2, float texY1, float texY2, boolean squeezeX, boolean squeezeY, boolean tilingX, boolean tilingY) {
        if (!tilingX && !tilingY || !this.tiling) {
            this.drawToBatch(batch, texture, x + originX, y + originY, drawWidth, drawHeight, drawU, drawV, drawU2, drawV2);
        } else {
            float j;
            float i;
            float v2;
            float u2;
            float v;
            float u;
            float height;
            float width;
            float yValue;
            float xValue;
            float offsetYadjusted;
            float offsetXadjusted = this.offsetX % (texX2 - texX1);
            if (offsetXadjusted < 0.0f) {
                offsetXadjusted = texX2 - texX1 + offsetXadjusted;
            }
            if ((offsetYadjusted = this.offsetY % (texY2 - texY1)) < 0.0f) {
                offsetYadjusted = texY2 - texY1 + offsetYadjusted;
            }
            if (tilingY) {
                if (tilingX && offsetXadjusted > 0.0f) {
                    xValue = x + originX;
                    yValue = y + originY;
                    width = Math.min(offsetXadjusted, drawWidth);
                    height = Math.min(offsetYadjusted, drawHeight);
                    u = drawU2 - (drawU2 - drawU) * offsetXadjusted / (texX2 - texX1);
                    v = drawV2 - (drawV - drawV2) * offsetYadjusted / (texY1 - texY2);
                    u2 = Math.min(drawU2, drawU2 - (drawU2 - drawU) * (offsetXadjusted - drawWidth) / (texX2 - texX1));
                    v2 = Math.max(drawV2, drawV2 - (drawV - drawV2) * (offsetYadjusted - drawHeight) / (texY1 - texY2));
                    this.drawToBatch(batch, texture, xValue, yValue, width, height, u, v, u2, v2);
                }
                float f = i = tilingX ? offsetXadjusted : 0.0f;
                while (i < drawWidth && texX2 - texX1 > 0.0f) {
                    xValue = x + originX + i;
                    yValue = y + originY;
                    width = Math.min(texX2 - texX1, drawWidth - i);
                    height = Math.min(offsetYadjusted, drawHeight);
                    u = drawU;
                    v = drawV2 - (drawV - drawV2) * offsetYadjusted / (texY1 - texY2);
                    u2 = Math.min(drawU2, squeezeX ? drawU2 : drawU + (drawU2 - drawU) * (drawWidth - i) / (texX2 - texX1));
                    v2 = Math.max(drawV2, drawV2 - (drawV - drawV2) * (offsetYadjusted - drawHeight) / (texY1 - texY2));
                    this.drawToBatch(batch, texture, xValue, yValue, width, height, u, v, u2, v2);
                    i += texX2 - texX1;
                }
            }
            float f = j = tilingY ? offsetYadjusted : 0.0f;
            while (j < drawHeight && texY2 - texY1 > 0.0f) {
                if (tilingX && offsetXadjusted > 0.0f) {
                    xValue = x + originX;
                    yValue = y + originY + j;
                    width = Math.min(offsetXadjusted, drawWidth);
                    height = Math.min(texY2 - texY1, drawHeight - j);
                    u = drawU2 - (drawU2 - drawU) * offsetXadjusted / (texX2 - texX1);
                    v = drawV;
                    u2 = Math.min(drawU2, drawU2 - (drawU2 - drawU) * (offsetXadjusted - drawWidth) / (texX2 - texX1));
                    v2 = Math.max(drawV2, squeezeY ? drawV2 : drawV + (drawV2 - drawV) * (drawHeight - j) / (texY2 - texY1));
                    this.drawToBatch(batch, texture, xValue, yValue, width, height, u, v, u2, v2);
                }
                float f2 = i = tilingX ? offsetXadjusted : 0.0f;
                while (i < drawWidth && texX2 - texX1 > 0.0f) {
                    xValue = x + originX + i;
                    yValue = y + originY + j;
                    width = Math.min(texX2 - texX1, drawWidth - i);
                    height = Math.min(texY2 - texY1, drawHeight - j);
                    u = drawU;
                    v = drawV;
                    u2 = Math.min(drawU2, squeezeX ? drawU2 : drawU + (drawU2 - drawU) * (drawWidth - i) / (texX2 - texX1));
                    v2 = Math.max(drawV2, squeezeY ? drawV2 : drawV + (drawV2 - drawV) * (drawHeight - j) / (texY2 - texY1));
                    this.drawToBatch(batch, texture, xValue, yValue, width, height, u, v, u2, v2);
                    i += texX2 - texX1;
                }
                j += texY2 - texY1;
            }
        }
    }

    private void drawToBatch(Batch batch, Texture texture, float x, float y, float width, float height, float u, float v, float u2, float v2) {
        int i = 0;
        this.verts[i++] = x;
        this.verts[i++] = y;
        temp.set(this.color1 != null ? this.color1 : this.color);
        this.verts[i++] = temp.mul(batch.getColor()).toFloatBits();
        this.verts[i++] = u;
        this.verts[i++] = v;
        this.verts[i++] = x;
        this.verts[i++] = y + height;
        temp.set(this.color2 != null ? this.color2 : this.color);
        this.verts[i++] = temp.mul(batch.getColor()).toFloatBits();
        this.verts[i++] = u;
        this.verts[i++] = v2;
        this.verts[i++] = x + width;
        this.verts[i++] = y + height;
        temp.set(this.color3 != null ? this.color3 : this.color);
        this.verts[i++] = temp.mul(batch.getColor()).toFloatBits();
        this.verts[i++] = u2;
        this.verts[i++] = v2;
        this.verts[i++] = x + width;
        this.verts[i++] = y;
        temp.set(this.color4 != null ? this.color4 : this.color);
        this.verts[i++] = temp.mul(batch.getColor()).toFloatBits();
        this.verts[i++] = u2;
        this.verts[i++] = v;
        batch.draw(texture, this.verts, 0, this.verts.length);
    }

    @Override
    @Deprecated
    public void draw(Batch batch, float x, float y, float originX, float originY, float width, float height, float scaleX, float scaleY, float rotation) {
        throw new UnsupportedOperationException();
    }

    public void update(float delta) {
        this.update(delta, false);
    }

    private void update(float delta, boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
        this.time += delta;
        this.offsetX += this.offsetXspeed * delta;
        this.offsetY += this.offsetYspeed * delta;
        if (this.regions != null && this.regions.size > 0) {
            TextureRegion region = this.getKeyFrame();
            if (this.getRegion() == null || !this.getRegion().equals(region)) {
                float minWidth = this.getMinWidth();
                float minHeight = this.getMinHeight();
                this.setRegion(region);
                this.setMinWidth(minWidth);
                this.setMinHeight(minHeight);
            }
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.getColor().set(color);
    }

    @Override
    public TenPatchDrawable tint(Color tint) {
        TenPatchDrawable drawable = new TenPatchDrawable(this);
        drawable.color.set(tint);
        drawable.setLeftWidth(this.getLeftWidth());
        drawable.setRightWidth(this.getRightWidth());
        drawable.setTopHeight(this.getTopHeight());
        drawable.setBottomHeight(this.getBottomHeight());
        return drawable;
    }

    public int[] getHorizontalStretchAreas() {
        return this.horizontalStretchAreas;
    }

    public void setHorizontalStretchAreas(int[] horizontalStretchAreas) {
        this.horizontalStretchAreas = horizontalStretchAreas;
    }

    public int[] getVerticalStretchAreas() {
        return this.verticalStretchAreas;
    }

    public void setVerticalStretchAreas(int[] verticalStretchAreas) {
        this.verticalStretchAreas = verticalStretchAreas;
    }

    public boolean isTiling() {
        return this.tiling;
    }

    public void setTiling(boolean tiling) {
        this.tiling = tiling;
    }

    public float getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(float offsetX) {
        this.offsetX = offsetX;
    }

    public float getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(float offsetY) {
        this.offsetY = offsetY;
    }

    public void setOffset(float offsetX, float offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    public void setOffset(float offset) {
        this.setOffset(offset, offset);
    }

    public float getOffsetXspeed() {
        return this.offsetXspeed;
    }

    public void setOffsetXspeed(float offsetXspeed) {
        this.offsetXspeed = offsetXspeed;
    }

    public float getOffsetYspeed() {
        return this.offsetYspeed;
    }

    public void setOffsetYspeed(float offsetYspeed) {
        this.offsetYspeed = offsetYspeed;
    }

    public void setOffsetSpeed(float offsetXspeed, float offsetYspeed) {
        this.offsetXspeed = offsetXspeed;
        this.offsetYspeed = offsetYspeed;
    }

    public void setOffsetSpeed(float offsetSpeed) {
        this.setOffsetSpeed(offsetSpeed, offsetSpeed);
    }

    public Color getColor1() {
        return this.color1;
    }

    public void setColor1(Color color1) {
        this.color1 = (this.color1 == null ? new Color() : color1).set(color1);
    }

    public Color getColor2() {
        return this.color2;
    }

    public void setColor2(Color color2) {
        this.color2 = (this.color2 == null ? new Color() : color2).set(color2);
    }

    public Color getColor3() {
        return this.color3;
    }

    public void setColor3(Color color3) {
        this.color3 = (this.color3 == null ? new Color() : color3).set(color3);
    }

    public Color getColor4() {
        return this.color4;
    }

    public void setColor4(Color color4) {
        this.color4 = (this.color4 == null ? new Color() : color4).set(color4);
    }

    public void setColors(Color color1, Color color2, Color color3, Color color4) {
        this.setColor1(color1);
        this.setColor2(color2);
        this.setColor3(color3);
        this.setColor4(color4);
    }

    public Array<TextureRegion> getRegions() {
        return this.regions;
    }

    public void setRegions(Array<TextureRegion> regions) {
        this.regions = regions;
    }

    public float getFrameDuration() {
        return this.frameDuration;
    }

    public void setFrameDuration(float frameDuration) {
        this.frameDuration = frameDuration;
    }

    public TextureRegion getKeyFrame(float time) {
        switch (this.playMode) {
            case 1: {
                int index = (int)(time / this.frameDuration);
                return this.regions.get(this.regions.size - 1 - (index < this.regions.size ? index : this.regions.size - 1));
            }
            case 2: {
                return this.regions.get((int)(time / this.frameDuration) % this.regions.size);
            }
            case 3: {
                return this.regions.get(this.regions.size - 1 - (int)(time / this.frameDuration) % this.regions.size);
            }
            case 4: {
                int index = (int)(time / this.frameDuration);
                if ((index %= this.regions.size * 2 - 2) >= this.regions.size) {
                    index = this.regions.size - 2 - (index - this.regions.size);
                }
                return this.regions.get(index);
            }
            case 5: {
                int index = (int)(time / this.frameDuration);
                randomXS128.setSeed(this.seed + index);
                return this.regions.get(randomXS128.nextInt(this.regions.size));
            }
        }
        int index = (int)(time / this.frameDuration);
        return this.regions.get(index < this.regions.size ? index : this.regions.size - 1);
    }

    public TextureRegion getKeyFrame() {
        return this.getKeyFrame(this.time);
    }

    public float getTime() {
        return this.time;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdate;
    }

    public void setAutoUpdate(boolean autoUpdate) {
        this.autoUpdate = autoUpdate;
    }

    public int getPlayMode() {
        return this.playMode;
    }

    public void setPlayMode(int playMode) {
        this.playMode = playMode;
    }

    public int getCrushMode() {
        return this.crushMode;
    }

    public void setCrushMode(int crushMode) {
        this.crushMode = crushMode;
    }

    public void scale(float scaleX, float scaleY) {
        this.scaleX *= scaleX;
        this.scaleY *= scaleY;
    }

    public float getScaleX() {
        return this.scaleX;
    }

    public void setScaleX(float scaleX) {
        this.scaleX = scaleX;
    }

    public float getScaleY() {
        return this.scaleY;
    }

    public void setScaleY(float scaleY) {
        this.scaleY = scaleY;
    }

    public void setScale(float scaleX, float scaleY) {
        this.scaleX = scaleX;
        this.scaleY = scaleY;
    }

    public void setScale(float scale) {
        this.scaleX = scale;
        this.scaleY = scale;
    }

    public static class InvalidPatchException
    extends RuntimeException {
    }

    public static class PlayMode {
        public static final int NORMAL = 0;
        public static final int REVERSED = 1;
        public static final int LOOP = 2;
        public static final int LOOP_REVERSED = 3;
        public static final int LOOP_PINGPONG = 4;
        public static final int LOOP_RANDOM = 5;
    }

    public static class CrushMode {
        public static final int SHRINK = 0;
        public static final int CROP = 1;
        public static final int CROP_REVERSED = 2;
        public static final int NONE = 3;
    }
}

