/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.IntFloatMap;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class EaseEffect
extends Effect {
    private static final float DEFAULT_DISTANCE = 0.15f;
    private static final float DEFAULT_INTENSITY = 0.075f;
    private float distance = -2.0f;
    private float intensity = 1.0f;
    private boolean elastic = false;
    private final IntFloatMap timePassedByGlyphIndex = new IntFloatMap();

    public EaseEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], -2.0f);
        }
        if (params.length > 1) {
            this.intensity = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.elastic = this.paramAsBoolean(params[2]);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float realIntensity = this.intensity * (this.elastic ? 3.0f : 1.0f) * 0.075f;
        float timePassed = this.timePassedByGlyphIndex.getAndIncrement(localIndex, 0.0f, delta);
        float progress = MathUtils.clamp(timePassed / realIntensity, 0.0f, 1.0f);
        Interpolation interpolation = this.elastic ? Interpolation.swingOut : Interpolation.sine;
        float interpolatedValue = interpolation.apply(1.0f, 0.0f, progress);
        float y = this.label.getLineHeight(globalIndex) * this.distance * interpolatedValue * 0.15f;
        this.label.offsets.incr(globalIndex << 1 | 1, y);
    }
}

