/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.utils.TimeUtils;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;
import com.github.tommyettinger.textra.utils.NoiseUtils;

public class CrowdEffect
extends Effect {
    private static final float DEFAULT_DISTANCE = 1.0f;
    private static final float DEFAULT_INTENSITY = 0.001f;
    private float distance = 15.0f;
    private float intensity = 1.0f;

    public CrowdEffect(TypingLabel label, String[] params) {
        super(label);
        if (params.length > 0) {
            this.distance = this.paramAsFloat(params[0], 15.0f);
        }
        if (params.length > 1) {
            this.intensity = this.paramAsFloat(params[1], 1.0f);
        }
        if (params.length > 2) {
            this.duration = this.paramAsFloat(params[2], Float.POSITIVE_INFINITY);
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        float rot = NoiseUtils.octaveNoise1D((float)(TimeUtils.millis() & 0xFFFFFFL) * this.intensity * 0.001f + (float)globalIndex * 0.42f, globalIndex) * this.distance * 1.0f;
        float fadeout = this.calculateFadeout();
        this.label.rotations.incr(globalIndex, rot *= fadeout);
    }
}

