/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra.effects;

import com.badlogic.gdx.math.MathUtils;
import com.github.tommyettinger.textra.Effect;
import com.github.tommyettinger.textra.TypingLabel;

public class AttentionEffect
extends Effect {
    private float spread = 5.0f;
    private float sizeY = 2.0f;

    public AttentionEffect(TypingLabel label, String[] params) {
        super(label);
        label.trackingInput = true;
        if (params.length > 0) {
            this.spread = this.paramAsFloat(params[0], 100.0f) * 0.01f;
        }
        if (params.length > 1) {
            this.sizeY = this.paramAsFloat(params[1], 100.0f) * 0.01f;
        }
    }

    @Override
    protected void onApply(long glyph, int localIndex, int globalIndex, float delta) {
        int distance = Math.abs(globalIndex - this.label.overIndex);
        if (this.label.overIndex >= 0 && (float)distance <= this.spread) {
            this.label.sizing.incr(globalIndex << 1 | 1, (this.sizeY - 1.0f) * MathUtils.cosDeg(90.0f * (float)distance / this.spread));
        }
    }
}

