/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.ui.Container;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.TextTooltip;
import com.badlogic.gdx.scenes.scene2d.ui.Tooltip;
import com.badlogic.gdx.scenes.scene2d.ui.TooltipManager;
import com.badlogic.gdx.utils.Null;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.TypingLabel;

public class TypingTooltip
extends Tooltip<TypingLabel> {
    public TypingTooltip(@Null String text, Skin skin) {
        this(text, TooltipManager.getInstance(), skin.get(TextTooltip.TextTooltipStyle.class));
    }

    public TypingTooltip(@Null String text, Skin skin, String styleName) {
        this(text, TooltipManager.getInstance(), skin.get(styleName, TextTooltip.TextTooltipStyle.class));
    }

    public TypingTooltip(@Null String text, TextTooltip.TextTooltipStyle style) {
        this(text, TooltipManager.getInstance(), style);
    }

    public TypingTooltip(@Null String text, TooltipManager manager, Skin skin) {
        this(text, manager, skin.get(TextTooltip.TextTooltipStyle.class));
    }

    public TypingTooltip(@Null String text, TooltipManager manager, Skin skin, String styleName) {
        this(text, manager, skin.get(styleName, TextTooltip.TextTooltipStyle.class));
    }

    public TypingTooltip(@Null String text, TooltipManager manager, TextTooltip.TextTooltipStyle style) {
        super(null, manager);
        TypingLabel label = this.newLabel(text, style.label);
        label.setAlignment(1);
        label.setWrap(true);
        label.layout.setTargetWidth(style.wrapWidth);
        this.getContainer().setActor(label);
        this.getContainer().width(style.wrapWidth);
        this.setStyle(style);
        label.setText(text);
    }

    public TypingTooltip(@Null String text, Skin skin, Font replacementFont) {
        this(text, TooltipManager.getInstance(), skin.get(TextTooltip.TextTooltipStyle.class), replacementFont);
    }

    public TypingTooltip(@Null String text, Skin skin, String styleName, Font replacementFont) {
        this(text, TooltipManager.getInstance(), skin.get(styleName, TextTooltip.TextTooltipStyle.class), replacementFont);
    }

    public TypingTooltip(@Null String text, TextTooltip.TextTooltipStyle style, Font replacementFont) {
        this(text, TooltipManager.getInstance(), style, replacementFont);
    }

    public TypingTooltip(@Null String text, TooltipManager manager, Skin skin, Font replacementFont) {
        this(text, manager, skin.get(TextTooltip.TextTooltipStyle.class), replacementFont);
    }

    public TypingTooltip(@Null String text, TooltipManager manager, Skin skin, String styleName, Font replacementFont) {
        this(text, manager, skin.get(styleName, TextTooltip.TextTooltipStyle.class), replacementFont);
    }

    public TypingTooltip(@Null String text, TooltipManager manager, TextTooltip.TextTooltipStyle style, Font replacementFont) {
        super(null, manager);
        TypingLabel label = this.newLabel(text, replacementFont, style.label.fontColor);
        label.setAlignment(1);
        label.setWrap(true);
        label.layout.setTargetWidth(style.wrapWidth);
        this.getContainer().setActor(label);
        this.getContainer().width(style.wrapWidth);
        this.setStyle(style, replacementFont);
        label.setText(text);
    }

    protected TypingLabel newLabel(String text, Label.LabelStyle style) {
        return new TypingLabel(text, style);
    }

    protected TypingLabel newLabel(String text, Font font) {
        return new TypingLabel(text, font);
    }

    protected TypingLabel newLabel(String text, Font font, Color color) {
        return new TypingLabel(text, font, color);
    }

    public void setStyle(TextTooltip.TextTooltipStyle style) {
        this.setStyle(style, false);
    }

    public void setStyle(TextTooltip.TextTooltipStyle style, boolean makeGridGlyphs) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        Container container = this.getContainer();
        ((TypingLabel)container.getActor()).setFont(new Font(style.label.font, Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, makeGridGlyphs), false);
        ((TypingLabel)container.getActor()).layout.targetWidth = style.wrapWidth;
        if (style.label.fontColor != null) {
            ((TypingLabel)container.getActor()).setColor(style.label.fontColor);
        }
        ((TypingLabel)container.getActor()).getFont().regenerateLayout(((TypingLabel)container.getActor()).layout);
        ((TypingLabel)container.getActor()).setWidth(((TypingLabel)container.getActor()).layout.getWidth());
        container.setBackground(style.background);
        container.maxWidth(style.wrapWidth);
    }

    public void setStyle(TextTooltip.TextTooltipStyle style, Font font) {
        if (style == null) {
            throw new NullPointerException("style cannot be null");
        }
        Container container = this.getContainer();
        ((TypingLabel)container.getActor()).setFont(font, false);
        ((TypingLabel)container.getActor()).layout.targetWidth = style.wrapWidth;
        if (style.label.fontColor != null) {
            ((TypingLabel)container.getActor()).setColor(style.label.fontColor);
        }
        font.regenerateLayout(((TypingLabel)container.getActor()).layout);
        ((TypingLabel)container.getActor()).setWidth(((TypingLabel)container.getActor()).layout.getWidth());
        container.setBackground(style.background);
        container.maxWidth(style.wrapWidth);
    }

    @Override
    public void enter(InputEvent event, float x, float y, int pointer, Actor fromActor) {
        super.enter(event, x, y, pointer, fromActor);
        ((TypingLabel)this.getContainer().getActor()).restart();
    }
}

