/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.InputEvent;
import com.badlogic.gdx.scenes.scene2d.InputListener;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.Label;
import com.badlogic.gdx.scenes.scene2d.ui.Skin;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.Window;
import com.badlogic.gdx.utils.Null;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.TextraLabel;

public class TextraWindow
extends Table {
    private static final Vector2 tmpPosition = new Vector2();
    private static final Vector2 tmpSize = new Vector2();
    private static final int MOVE = 32;
    private Window.WindowStyle style;
    private boolean isMovable = true;
    private boolean isModal;
    private boolean isResizable;
    private int resizeBorder = 8;
    private boolean keepWithinStage = true;
    protected TextraLabel titleLabel;
    protected Table titleTable;
    protected boolean drawTitleTable;
    protected int edge;
    protected boolean dragging;
    protected Font font = null;

    public TextraWindow(String title, Skin skin) {
        this(title, skin.get(Window.WindowStyle.class));
        this.setSkin(skin);
    }

    public TextraWindow(String title, Skin skin, String styleName) {
        this(title, skin.get(styleName, Window.WindowStyle.class));
        this.setSkin(skin);
    }

    public TextraWindow(String title, Window.WindowStyle style) {
        this(title, style, false);
    }

    public TextraWindow(String title, Window.WindowStyle style, boolean makeGridGlyphs) {
        this(title, style, new Font(style.titleFont, Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, makeGridGlyphs));
    }

    public TextraWindow(String title, Skin skin, Font replacementFont) {
        this(title, skin.get(Window.WindowStyle.class), replacementFont);
        this.setSkin(skin);
    }

    public TextraWindow(String title, Skin skin, String styleName, Font replacementFont) {
        this(title, skin.get(styleName, Window.WindowStyle.class), replacementFont);
        this.setSkin(skin);
    }

    public TextraWindow(String title, Skin skin, String styleName, Font replacementFont, boolean scaleTitleFont) {
        this(title, skin.get(styleName, Window.WindowStyle.class), replacementFont, scaleTitleFont);
        this.setSkin(skin);
    }

    public TextraWindow(String title, Window.WindowStyle style, Font replacementFont) {
        this(title, style, replacementFont, false);
    }

    public TextraWindow(String title, Window.WindowStyle style, Font replacementFont, boolean scaleTitleFont) {
        if (title == null) {
            throw new IllegalArgumentException("title cannot be null.");
        }
        if (replacementFont == null) {
            throw new IllegalArgumentException("replacementFont cannot be null.");
        }
        this.setTouchable(Touchable.enabled);
        this.setClip(true);
        this.titleLabel = this.newLabel(title, replacementFont, style.titleFontColor);
        this.setStyle(style, replacementFont);
        this.font = replacementFont;
        if (scaleTitleFont) {
            float ratio = this.getBackground().getTopHeight() / replacementFont.cellHeight;
            Font labelFont = new Font(replacementFont);
            labelFont.scale(ratio, ratio);
            labelFont.descent *= ratio;
            this.titleLabel.setFont(labelFont);
        } else {
            this.titleLabel.setFont(this.font);
        }
        this.titleTable = new Table(){

            @Override
            public void draw(Batch batch, float parentAlpha) {
                if (TextraWindow.this.drawTitleTable) {
                    super.draw(batch, parentAlpha);
                }
            }
        };
        this.titleTable.add(this.titleLabel).expandX().fillX().minWidth(0.0f);
        this.titleLabel.layout.ellipsis = "...";
        this.addActor(this.titleTable);
        this.setWidth(150.0f);
        this.setHeight(150.0f);
        this.addCaptureListener(new InputListener(){

            @Override
            public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
                TextraWindow.this.toFront();
                return false;
            }
        });
        this.addListener(new InternalListener());
    }

    protected TextraLabel newLabel(String text, Label.LabelStyle style) {
        return new TextraLabel(text, style);
    }

    protected TextraLabel newLabel(String text, Font font, Color color) {
        return color == null ? new TextraLabel(text, font) : new TextraLabel(text, font, color);
    }

    public void setStyle(Window.WindowStyle style) {
        this.setStyle(style, false);
    }

    public void setStyle(Window.WindowStyle style, boolean makeGridGlyphs) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.setBackground(style.background);
        this.font = new Font(style.titleFont, Font.DistanceFieldType.STANDARD, 0.0f, 0.0f, 0.0f, 0.0f, makeGridGlyphs);
        this.titleLabel.setFont(this.font);
        if (style.titleFontColor != null) {
            this.titleLabel.setColor(style.titleFontColor);
        }
        this.invalidateHierarchy();
    }

    public void setStyle(Window.WindowStyle style, Font font) {
        if (style == null) {
            throw new IllegalArgumentException("style cannot be null.");
        }
        this.style = style;
        this.setBackground(style.background);
        this.font = font;
        this.titleLabel.setFont(this.font);
        if (style.titleFontColor != null) {
            this.titleLabel.setColor(style.titleFontColor);
        }
        this.invalidateHierarchy();
    }

    public Window.WindowStyle getStyle() {
        return this.style;
    }

    public void keepWithinStage() {
        if (!this.keepWithinStage) {
            return;
        }
        Stage stage = this.getStage();
        if (stage == null) {
            return;
        }
        Camera camera = stage.getCamera();
        if (camera instanceof OrthographicCamera) {
            OrthographicCamera orthographicCamera = (OrthographicCamera)camera;
            float parentWidth = stage.getWidth();
            float parentHeight = stage.getHeight();
            if (this.getX(16) - camera.position.x > parentWidth / 2.0f / orthographicCamera.zoom) {
                this.setPosition(camera.position.x + parentWidth / 2.0f / orthographicCamera.zoom, this.getY(16), 16);
            }
            if (this.getX(8) - camera.position.x < -parentWidth / 2.0f / orthographicCamera.zoom) {
                this.setPosition(camera.position.x - parentWidth / 2.0f / orthographicCamera.zoom, this.getY(8), 8);
            }
            if (this.getY(2) - camera.position.y > parentHeight / 2.0f / orthographicCamera.zoom) {
                this.setPosition(this.getX(2), camera.position.y + parentHeight / 2.0f / orthographicCamera.zoom, 2);
            }
            if (this.getY(4) - camera.position.y < -parentHeight / 2.0f / orthographicCamera.zoom) {
                this.setPosition(this.getX(4), camera.position.y - parentHeight / 2.0f / orthographicCamera.zoom, 4);
            }
        } else if (this.getParent() == stage.getRoot()) {
            float parentWidth = stage.getWidth();
            float parentHeight = stage.getHeight();
            if (this.getX() < 0.0f) {
                this.setX(0.0f);
            }
            if (this.getRight() > parentWidth) {
                this.setX(parentWidth - this.getWidth());
            }
            if (this.getY() < 0.0f) {
                this.setY(0.0f);
            }
            if (this.getTop() > parentHeight) {
                this.setY(parentHeight - this.getHeight());
            }
        }
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        Stage stage = this.getStage();
        if (stage != null) {
            if (stage.getKeyboardFocus() == null) {
                stage.setKeyboardFocus(this);
            }
            this.keepWithinStage();
            if (this.style.stageBackground != null) {
                this.stageToLocalCoordinates(tmpPosition.set(0.0f, 0.0f));
                this.stageToLocalCoordinates(tmpSize.set(stage.getWidth(), stage.getHeight()));
                this.drawStageBackground(batch, parentAlpha, this.getX() + TextraWindow.tmpPosition.x, this.getY() + TextraWindow.tmpPosition.y, this.getX() + TextraWindow.tmpSize.x, this.getY() + TextraWindow.tmpSize.y);
            }
        }
        super.draw(batch, parentAlpha);
    }

    protected void drawStageBackground(Batch batch, float parentAlpha, float x, float y, float width, float height) {
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        this.style.stageBackground.draw(batch, x, y, width, height);
    }

    @Override
    protected void drawBackground(Batch batch, float parentAlpha, float x, float y) {
        super.drawBackground(batch, parentAlpha, x, y);
        this.titleTable.getColor().a = this.getColor().a;
        float padTop = this.getPadTop();
        float padLeft = this.getPadLeft();
        this.titleTable.setSize(this.getWidth() - padLeft - this.getPadRight(), padTop);
        this.titleTable.setPosition(padLeft, this.getHeight() - padTop);
        this.drawTitleTable = true;
        this.titleTable.draw(batch, parentAlpha);
        this.drawTitleTable = false;
    }

    @Override
    @Null
    public Actor hit(float x, float y, boolean touchable) {
        if (!this.isVisible()) {
            return null;
        }
        Actor hit = super.hit(x, y, touchable);
        if (hit == null && this.isModal && (!touchable || this.getTouchable() == Touchable.enabled)) {
            return this;
        }
        float height = this.getHeight();
        if (hit == null || hit == this) {
            return hit;
        }
        if (y <= height && y >= height - this.getPadTop() && x >= 0.0f && x <= this.getWidth()) {
            Actor current = hit;
            while (current.getParent() != this) {
                current = current.getParent();
            }
            if (this.getCell(current) != null) {
                return this;
            }
        }
        return hit;
    }

    public boolean isMovable() {
        return this.isMovable;
    }

    public void setMovable(boolean isMovable) {
        this.isMovable = isMovable;
    }

    public boolean isModal() {
        return this.isModal;
    }

    public void setModal(boolean isModal) {
        this.isModal = isModal;
    }

    public void setKeepWithinStage(boolean keepWithinStage) {
        this.keepWithinStage = keepWithinStage;
    }

    public boolean isResizable() {
        return this.isResizable;
    }

    public void setResizable(boolean isResizable) {
        this.isResizable = isResizable;
    }

    public int getResizeBorder() {
        return this.resizeBorder;
    }

    public void setResizeBorder(int resizeBorder) {
        this.resizeBorder = resizeBorder;
    }

    public boolean isDragging() {
        return this.dragging;
    }

    @Override
    public float getPrefWidth() {
        return Math.max(super.getPrefWidth(), this.titleTable.getPrefWidth() + this.getPadLeft() + this.getPadRight());
    }

    public Table getTitleTable() {
        return this.titleTable;
    }

    public TextraLabel getTitleLabel() {
        return this.titleLabel;
    }

    public void skipToTheEnd() {
        this.titleLabel.skipToTheEnd();
    }

    class InternalListener
    extends InputListener {
        float startX;
        float startY;
        float lastX;
        float lastY;

        InternalListener() {
        }

        private void updateEdge(float x, float y) {
            float border = (float)TextraWindow.this.resizeBorder / 2.0f;
            float width = TextraWindow.this.getWidth();
            float height = TextraWindow.this.getHeight();
            float padTop = TextraWindow.this.getPadTop();
            float padLeft = TextraWindow.this.getPadLeft();
            float padBottom = TextraWindow.this.getPadBottom();
            float padRight = TextraWindow.this.getPadRight();
            float left = padLeft;
            float right = width - padRight;
            float bottom = padBottom;
            TextraWindow.this.edge = 0;
            if (TextraWindow.this.isResizable && x >= left - border && x <= right + border && y >= bottom - border) {
                if (x < left + border) {
                    TextraWindow.this.edge |= 8;
                }
                if (x > right - border) {
                    TextraWindow.this.edge |= 0x10;
                }
                if (y < bottom + border) {
                    TextraWindow.this.edge |= 4;
                }
                if (TextraWindow.this.edge != 0) {
                    border += 25.0f;
                }
                if (x < left + border) {
                    TextraWindow.this.edge |= 8;
                }
                if (x > right - border) {
                    TextraWindow.this.edge |= 0x10;
                }
                if (y < bottom + border) {
                    TextraWindow.this.edge |= 4;
                }
            }
            if (TextraWindow.this.isMovable && TextraWindow.this.edge == 0 && y <= height && y >= height - padTop && x >= left && x <= right) {
                TextraWindow.this.edge = 32;
            }
        }

        @Override
        public boolean touchDown(InputEvent event, float x, float y, int pointer, int button) {
            if (button == 0) {
                this.updateEdge(x, y);
                TextraWindow.this.dragging = TextraWindow.this.edge != 0;
                this.startX = x;
                this.startY = y;
                this.lastX = x - TextraWindow.this.getWidth();
                this.lastY = y - TextraWindow.this.getHeight();
            }
            return TextraWindow.this.edge != 0 || TextraWindow.this.isModal;
        }

        @Override
        public void touchUp(InputEvent event, float x, float y, int pointer, int button) {
            TextraWindow.this.dragging = false;
        }

        @Override
        public void touchDragged(InputEvent event, float x, float y, int pointer) {
            float amountY;
            float amountX;
            boolean clampPosition;
            if (!TextraWindow.this.dragging) {
                return;
            }
            float width = TextraWindow.this.getWidth();
            float height = TextraWindow.this.getHeight();
            float windowX = TextraWindow.this.getX();
            float windowY = TextraWindow.this.getY();
            float minWidth = TextraWindow.this.getMinWidth();
            float maxWidth = TextraWindow.this.getMaxWidth();
            float minHeight = TextraWindow.this.getMinHeight();
            float maxHeight = TextraWindow.this.getMaxHeight();
            Stage stage = TextraWindow.this.getStage();
            boolean bl = clampPosition = TextraWindow.this.keepWithinStage && stage != null && TextraWindow.this.getParent() == stage.getRoot();
            if ((TextraWindow.this.edge & 0x20) != 0) {
                amountX = x - this.startX;
                float amountY2 = y - this.startY;
                windowX += amountX;
                windowY += amountY2;
            }
            if ((TextraWindow.this.edge & 8) != 0) {
                amountX = x - this.startX;
                if (width - amountX < minWidth) {
                    amountX = -(minWidth - width);
                }
                if (clampPosition && windowX + amountX < 0.0f) {
                    amountX = -windowX;
                }
                width -= amountX;
                windowX += amountX;
            }
            if ((TextraWindow.this.edge & 4) != 0) {
                amountY = y - this.startY;
                if (height - amountY < minHeight) {
                    amountY = -(minHeight - height);
                }
                if (clampPosition && windowY + amountY < 0.0f) {
                    amountY = -windowY;
                }
                height -= amountY;
                windowY += amountY;
            }
            if ((TextraWindow.this.edge & 0x10) != 0) {
                amountX = x - this.lastX - width;
                if (width + amountX < minWidth) {
                    amountX = minWidth - width;
                }
                if (clampPosition && windowX + width + amountX > stage.getWidth()) {
                    amountX = stage.getWidth() - windowX - width;
                }
                width += amountX;
            }
            if ((TextraWindow.this.edge & 2) != 0) {
                amountY = y - this.lastY - height;
                if (height + amountY < minHeight) {
                    amountY = minHeight - height;
                }
                if (clampPosition && windowY + height + amountY > stage.getHeight()) {
                    amountY = stage.getHeight() - windowY - height;
                }
                height += amountY;
            }
            TextraWindow.this.setBounds(Math.round(windowX), Math.round(windowY), Math.round(width), Math.round(height));
        }

        @Override
        public boolean mouseMoved(InputEvent event, float x, float y) {
            this.updateEdge(x, y);
            return TextraWindow.this.isModal;
        }

        public boolean scrolled(InputEvent event, float x, float y, int amount) {
            return TextraWindow.this.isModal;
        }

        @Override
        public boolean keyDown(InputEvent event, int keycode) {
            return TextraWindow.this.isModal;
        }

        @Override
        public boolean keyUp(InputEvent event, int keycode) {
            return TextraWindow.this.isModal;
        }

        @Override
        public boolean keyTyped(InputEvent event, char character) {
            return TextraWindow.this.isModal;
        }
    }
}

