/*
 * Decompiled with CFR 0.152.
 */
package com.github.tommyettinger.textra;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.Array;
import com.github.tommyettinger.textra.Font;
import com.github.tommyettinger.textra.Line;

public class Layout {
    protected Font font;
    protected final Array<Line> lines = new Array(true, 8);
    protected int maxLines = Integer.MAX_VALUE;
    protected boolean atLimit = false;
    protected String ellipsis = null;
    protected float targetWidth = 0.0f;
    protected float baseColor = Color.WHITE_FLOAT_BITS;

    public Layout() {
        this.lines.add(new Line());
    }

    public Layout(Font font) {
        this.font = font;
        this.lines.add(new Line());
    }

    public Layout(Layout other) {
        this.font = other.font;
        this.maxLines = other.maxLines;
        this.atLimit = other.atLimit;
        this.ellipsis = other.ellipsis;
        this.targetWidth = other.targetWidth;
        this.baseColor = other.baseColor;
        for (int i = 0; i < other.lines(); ++i) {
            Line ln = new Line();
            Line o = other.lines.get(i);
            ln.glyphs.addAll(o.glyphs);
            this.lines.add(ln.size(o.width, o.height));
        }
    }

    public Layout font(Font font) {
        if (this.font == null || !this.font.equals(font)) {
            this.font = font;
            this.lines.clear();
            this.lines.add(new Line());
        }
        return this;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.font(font);
    }

    public Layout add(long glyph) {
        if (!this.atLimit) {
            if ((glyph & 0xFFFFL) == 10L) {
                this.pushLine();
            } else {
                this.lines.peek().glyphs.add(glyph);
            }
        }
        return this;
    }

    public Layout clear() {
        this.lines.clear();
        this.lines.add(new Line());
        this.atLimit = false;
        return this;
    }

    public float getWidth() {
        float w = 0.0f;
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            w = Math.max(w, this.lines.get((int)i).width);
        }
        return w;
    }

    public float getHeight() {
        float h2 = 0.0f;
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            h2 += this.lines.get((int)i).height;
        }
        return h2;
    }

    public int lines() {
        return this.lines.size;
    }

    public Line getLine(int i) {
        if (i >= this.lines.size) {
            return null;
        }
        return this.lines.get(i);
    }

    public Line peekLine() {
        return this.lines.peek();
    }

    public Line pushLine() {
        if (this.lines.size >= this.maxLines) {
            this.atLimit = true;
            return null;
        }
        Line line = new Line();
        Line prev = this.lines.peek();
        prev.glyphs.add(10L);
        line.height = 0.0f;
        this.lines.add(line);
        return line;
    }

    public Line insertLine(int index) {
        if (this.lines.size >= this.maxLines) {
            this.atLimit = true;
            return null;
        }
        if (index < 0 || index >= this.maxLines) {
            return null;
        }
        Line line = new Line();
        Line prev = this.lines.get(index);
        prev.glyphs.add(10L);
        line.height = prev.height;
        this.lines.insert(index + 1, line);
        return line;
    }

    public float getTargetWidth() {
        return this.targetWidth;
    }

    public Layout setTargetWidth(float targetWidth) {
        this.targetWidth = targetWidth;
        return this;
    }

    public float getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(float baseColor) {
        this.baseColor = baseColor;
    }

    public void setBaseColor(Color baseColor) {
        this.baseColor = baseColor == null ? Color.WHITE_FLOAT_BITS : baseColor.toFloatBits();
    }

    public int getMaxLines() {
        return this.maxLines;
    }

    public void setMaxLines(int maxLines) {
        this.maxLines = Math.max(1, maxLines);
    }

    public String getEllipsis() {
        return this.ellipsis;
    }

    public void setEllipsis(String ellipsis) {
        this.ellipsis = ellipsis;
    }

    public void reset() {
        this.targetWidth = 0.0f;
        this.baseColor = Color.WHITE_FLOAT_BITS;
        this.maxLines = Integer.MAX_VALUE;
        this.atLimit = false;
        this.ellipsis = null;
        this.font = null;
    }

    public StringBuilder appendIntoDirect(StringBuilder sb) {
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            Line line = this.lines.get(i);
            int ln = line.glyphs.size;
            for (int j = 0; j < ln; ++j) {
                long gl = line.glyphs.get(j);
                sb.append((char)gl);
            }
        }
        return sb;
    }

    public StringBuilder appendInto(StringBuilder sb) {
        int n = this.lines.size;
        for (int i = 0; i < n; ++i) {
            Line line = this.lines.get(i);
            int ln = line.glyphs.size;
            for (int j = 0; j < ln; ++j) {
                char gl = (char)line.glyphs.get(j);
                sb.append(gl == '\u0002' ? (char)'[' : (char)gl);
            }
        }
        return sb;
    }

    public String toString() {
        return this.appendInto(new StringBuilder()).toString();
    }
}

