/*
 * Decompiled with CFR 0.152.
 */
package regexodus;

import java.io.Serializable;
import regexodus.PatternSyntaxException;
import regexodus.Term;

class Lookbehind
extends Term
implements Serializable {
    private static final long serialVersionUID = 2528136757932720807L;
    final boolean isPositive;
    private int prevDistance = -1;

    Lookbehind(int id, boolean isPositive) {
        this.distance = 0;
        this.isPositive = isPositive;
        this.in = this;
        this.out = new Term();
        if (isPositive) {
            this.type = 39;
            this.out.type = 40;
        } else {
            this.type = 41;
            this.out.type = 42;
            this.branchOut = this;
        }
        this.lookaheadId = id;
        this.out.lookaheadId = id;
    }

    @Override
    protected Term append(Term t2) throws PatternSyntaxException {
        this.distance += Lookbehind.length(t2);
        return super.append(t2);
    }

    @Override
    protected Term replaceCurrent(Term t2) throws PatternSyntaxException {
        this.distance += Lookbehind.length(t2) - Lookbehind.length(this.current);
        return super.replaceCurrent(t2);
    }

    private static int length(Term t2) throws PatternSyntaxException {
        int type = t2.type;
        switch (type) {
            case 0: 
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                return 1;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return 0;
            }
        }
        if (type >= 11 && type <= 31) {
            return 0;
        }
        throw new PatternSyntaxException("variable length element within a lookbehind assertion");
    }

    @Override
    protected void startNewBranch() throws PatternSyntaxException {
        this.prevDistance = this.distance;
        this.distance = 0;
        super.startNewBranch();
    }

    @Override
    protected void close() throws PatternSyntaxException {
        int pd = this.prevDistance;
        if (pd >= 0 && this.distance != pd) {
            throw new PatternSyntaxException("non-equal branch lengths within a lookbehind assertion");
        }
        super.close();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Lookbehind that = (Lookbehind)o;
        return this.isPositive == that.isPositive && this.prevDistance == that.prevDistance;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.isPositive ? 1 : 0);
        result = 31 * result + this.prevDistance;
        return result;
    }
}

