/*
 * Decompiled with CFR 0.152.
 */
package org.seamless.swing.logging;

import java.util.Arrays;
import java.util.logging.Handler;
import java.util.logging.LogRecord;
import org.seamless.swing.logging.LogMessage;

public abstract class LoggingHandler
extends Handler {
    public int sourcePathElements = 3;

    public LoggingHandler() {
    }

    public LoggingHandler(int sourcePathElements) {
        this.sourcePathElements = sourcePathElements;
    }

    public void publish(LogRecord logRecord) {
        LogMessage logMessage = new LogMessage(logRecord.getLevel(), this.getSource(logRecord), logRecord.getMessage());
        this.log(logMessage);
    }

    public void flush() {
    }

    public void close() throws SecurityException {
    }

    protected String getSource(LogRecord record) {
        StringBuilder sb = new StringBuilder(180);
        String[] split = record.getSourceClassName().split("\\.");
        if (split.length > this.sourcePathElements) {
            split = Arrays.copyOfRange(split, split.length - this.sourcePathElements, split.length);
        }
        for (String s2 : split) {
            sb.append(s2).append(".");
        }
        sb.append(record.getSourceMethodName());
        return sb.toString();
    }

    protected abstract void log(LogMessage var1);
}

