/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.support.model.dlna.message.header;

import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.support.model.dlna.message.header.DLNAHeader;
import org.fourthline.cling.support.model.dlna.types.NormalPlayTime;

public class RealTimeInfoHeader
extends DLNAHeader<NormalPlayTime> {
    public static final String PREFIX = "DLNA.ORG_TLAG=";

    @Override
    public void setString(String s2) throws InvalidHeaderException {
        if (s2.length() != 0 && s2.startsWith(PREFIX)) {
            try {
                s2 = s2.substring(PREFIX.length());
                this.setValue(s2.equals("*") ? null : NormalPlayTime.valueOf(s2));
                return;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        throw new InvalidHeaderException("Invalid RealTimeInfo header value: " + s2);
    }

    @Override
    public String getString() {
        NormalPlayTime v = (NormalPlayTime)this.getValue();
        if (v == null) {
            return "DLNA.ORG_TLAG=*";
        }
        return PREFIX + v.getString();
    }
}

