/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.types;

import org.fourthline.cling.model.types.AbstractDatatype;
import org.fourthline.cling.model.types.InvalidValueException;

public class FloatDatatype
extends AbstractDatatype<Float> {
    @Override
    public boolean isHandlingJavaType(Class type) {
        return type == Float.TYPE || Float.class.isAssignableFrom(type);
    }

    @Override
    public Float valueOf(String s2) throws InvalidValueException {
        if (s2.equals("")) {
            return null;
        }
        try {
            return Float.valueOf(Float.parseFloat(s2.trim()));
        }
        catch (NumberFormatException ex) {
            throw new InvalidValueException("Can't convert string to number: " + s2, ex);
        }
    }
}

