/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.types;

import org.fourthline.cling.model.types.AbstractDatatype;
import org.fourthline.cling.model.types.InvalidValueException;
import org.seamless.util.io.HexBin;

public class BinHexDatatype
extends AbstractDatatype<byte[]> {
    @Override
    public Class<byte[]> getValueType() {
        return byte[].class;
    }

    @Override
    public byte[] valueOf(String s2) throws InvalidValueException {
        if (s2.equals("")) {
            return null;
        }
        try {
            return HexBin.stringToBytes(s2);
        }
        catch (Exception ex) {
            throw new InvalidValueException(ex.getMessage(), ex);
        }
    }

    @Override
    public String getString(byte[] value) throws InvalidValueException {
        if (value == null) {
            return "";
        }
        try {
            return HexBin.bytesToString(value);
        }
        catch (Exception ex) {
            throw new InvalidValueException(ex.getMessage(), ex);
        }
    }
}

