/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.meta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Logger;
import org.fourthline.cling.model.Validatable;
import org.fourthline.cling.model.ValidationError;
import org.fourthline.cling.model.meta.StateVariableAllowedValueRange;
import org.fourthline.cling.model.types.Datatype;

public class StateVariableTypeDetails
implements Validatable {
    private static final Logger log = Logger.getLogger(StateVariableTypeDetails.class.getName());
    private final Datatype datatype;
    private final String defaultValue;
    private final String[] allowedValues;
    private final StateVariableAllowedValueRange allowedValueRange;

    public StateVariableTypeDetails(Datatype datatype) {
        this(datatype, null, null, null);
    }

    public StateVariableTypeDetails(Datatype datatype, String defaultValue) {
        this(datatype, defaultValue, null, null);
    }

    public StateVariableTypeDetails(Datatype datatype, String defaultValue, String[] allowedValues, StateVariableAllowedValueRange allowedValueRange) {
        this.datatype = datatype;
        this.defaultValue = defaultValue;
        this.allowedValues = allowedValues;
        this.allowedValueRange = allowedValueRange;
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String[] getAllowedValues() {
        if (!this.foundDefaultInAllowedValues(this.defaultValue, this.allowedValues)) {
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(this.allowedValues));
            list.add(this.getDefaultValue());
            return list.toArray(new String[list.size()]);
        }
        return this.allowedValues;
    }

    public StateVariableAllowedValueRange getAllowedValueRange() {
        return this.allowedValueRange;
    }

    protected boolean foundDefaultInAllowedValues(String defaultValue, String[] allowedValues) {
        if (defaultValue == null || allowedValues == null) {
            return true;
        }
        for (String s2 : allowedValues) {
            if (!s2.equals(defaultValue)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<ValidationError> validate() {
        ArrayList<ValidationError> errors = new ArrayList<ValidationError>();
        if (this.getDatatype() == null) {
            errors.add(new ValidationError(this.getClass(), "datatype", "Service state variable has no datatype"));
        }
        if (this.getAllowedValues() != null) {
            if (this.getAllowedValueRange() != null) {
                errors.add(new ValidationError(this.getClass(), "allowedValues", "Allowed value list of state variable can not also be restricted with allowed value range"));
            }
            if (!Datatype.Builtin.STRING.equals((Object)this.getDatatype().getBuiltin())) {
                errors.add(new ValidationError(this.getClass(), "allowedValues", "Allowed value list of state variable only available for string datatype, not: " + this.getDatatype()));
            }
            for (String s2 : this.getAllowedValues()) {
                if (s2.length() <= 31) continue;
                log.warning("UPnP specification violation, allowed value string must be less than 32 chars: " + s2);
            }
            if (!this.foundDefaultInAllowedValues(this.defaultValue, this.allowedValues)) {
                log.warning("UPnP specification violation, allowed string values don't contain default value: " + this.defaultValue);
            }
        }
        if (this.getAllowedValueRange() != null) {
            errors.addAll(this.getAllowedValueRange().validate());
        }
        return errors;
    }
}

