/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.header;

import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.fourthline.cling.model.types.UDN;

public class USNRootDeviceHeader
extends UpnpHeader<UDN> {
    public static final String ROOT_DEVICE_SUFFIX = "::upnp:rootdevice";

    public USNRootDeviceHeader() {
    }

    public USNRootDeviceHeader(UDN udn) {
        this.setValue(udn);
    }

    @Override
    public void setString(String s2) throws InvalidHeaderException {
        if (!s2.startsWith("uuid:") || !s2.endsWith(ROOT_DEVICE_SUFFIX)) {
            throw new InvalidHeaderException("Invalid root device USN header value, must start with 'uuid:' and end with '::upnp:rootdevice' but is '" + s2 + "'");
        }
        UDN udn = new UDN(s2.substring("uuid:".length(), s2.length() - ROOT_DEVICE_SUFFIX.length()));
        this.setValue(udn);
    }

    @Override
    public String getString() {
        return ((UDN)this.getValue()).toString() + ROOT_DEVICE_SUFFIX;
    }
}

