/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model.message.header;

import org.fourthline.cling.model.message.header.InvalidHeaderException;
import org.fourthline.cling.model.message.header.UpnpHeader;
import org.seamless.util.io.HexBin;

public class InterfaceMacHeader
extends UpnpHeader<byte[]> {
    public InterfaceMacHeader() {
    }

    public InterfaceMacHeader(byte[] value) {
        this.setValue(value);
    }

    public InterfaceMacHeader(String s2) {
        this.setString(s2);
    }

    @Override
    public void setString(String s2) throws InvalidHeaderException {
        byte[] bytes = HexBin.stringToBytes(s2, ":");
        this.setValue(bytes);
        if (bytes.length != 6) {
            throw new InvalidHeaderException("Invalid MAC address: " + s2);
        }
    }

    @Override
    public String getString() {
        return HexBin.bytesToString((byte[])this.getValue(), ":");
    }

    @Override
    public String toString() {
        return "(" + this.getClass().getSimpleName() + ") '" + this.getString() + "'";
    }
}

