/*
 * Decompiled with CFR 0.152.
 */
package org.fourthline.cling.model;

import java.util.logging.Logger;
import org.fourthline.cling.model.ModelUtil;
import org.fourthline.cling.model.types.Datatype;
import org.fourthline.cling.model.types.InvalidValueException;

public class VariableValue {
    private static final Logger log = Logger.getLogger(VariableValue.class.getName());
    private final Datatype datatype;
    private final Object value;

    public VariableValue(Datatype datatype, Object value) throws InvalidValueException {
        this.datatype = datatype;
        Object object = this.value = value instanceof String ? datatype.valueOf((String)value) : value;
        if (ModelUtil.ANDROID_RUNTIME) {
            return;
        }
        if (!this.getDatatype().isValid(this.getValue())) {
            throw new InvalidValueException("Invalid value for " + this.getDatatype() + ": " + this.getValue());
        }
        this.logInvalidXML(this.toString());
    }

    public Datatype getDatatype() {
        return this.datatype;
    }

    public Object getValue() {
        return this.value;
    }

    protected void logInvalidXML(String s2) {
        int cp;
        for (int i = 0; i < s2.length(); i += Character.charCount(cp)) {
            cp = s2.codePointAt(i);
            if (cp == 9 || cp == 10 || cp == 13 || cp >= 32 && cp <= 55295 || cp >= 57344 && cp <= 65533 || cp >= 65536 && cp <= 0x10FFFF) continue;
            log.warning("Found invalid XML char code: " + cp);
        }
    }

    public String toString() {
        return this.getDatatype().getString(this.getValue());
    }
}

