/*
 * Decompiled with CFR 0.152.
 */
package io.sentry.cache;

import io.sentry.Breadcrumb;
import io.sentry.IScope;
import io.sentry.JsonDeserializer;
import io.sentry.ScopeObserverAdapter;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.SpanContext;
import io.sentry.cache.CacheUtils;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.Request;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.User;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PersistingScopeObserver
extends ScopeObserverAdapter {
    public static final String SCOPE_CACHE = ".scope-cache";
    public static final String USER_FILENAME = "user.json";
    public static final String BREADCRUMBS_FILENAME = "breadcrumbs.json";
    public static final String TAGS_FILENAME = "tags.json";
    public static final String EXTRAS_FILENAME = "extras.json";
    public static final String CONTEXTS_FILENAME = "contexts.json";
    public static final String REQUEST_FILENAME = "request.json";
    public static final String LEVEL_FILENAME = "level.json";
    public static final String FINGERPRINT_FILENAME = "fingerprint.json";
    public static final String TRANSACTION_FILENAME = "transaction.json";
    public static final String TRACE_FILENAME = "trace.json";
    public static final String REPLAY_FILENAME = "replay.json";
    @NotNull
    private final SentryOptions options;

    public PersistingScopeObserver(@NotNull SentryOptions options) {
        this.options = options;
    }

    @Override
    public void setUser(@Nullable User user) {
        this.serializeToDisk(() -> {
            if (user == null) {
                this.delete(USER_FILENAME);
            } else {
                this.store(user, USER_FILENAME);
            }
        });
    }

    @Override
    public void setBreadcrumbs(@NotNull Collection<Breadcrumb> breadcrumbs) {
        this.serializeToDisk(() -> this.store(breadcrumbs, BREADCRUMBS_FILENAME));
    }

    @Override
    public void setTags(@NotNull @NotNull Map<String, @NotNull String> tags) {
        this.serializeToDisk(() -> this.store(tags, TAGS_FILENAME));
    }

    @Override
    public void setExtras(@NotNull @NotNull Map<String, @NotNull Object> extras) {
        this.serializeToDisk(() -> this.store(extras, EXTRAS_FILENAME));
    }

    @Override
    public void setRequest(@Nullable Request request) {
        this.serializeToDisk(() -> {
            if (request == null) {
                this.delete(REQUEST_FILENAME);
            } else {
                this.store(request, REQUEST_FILENAME);
            }
        });
    }

    @Override
    public void setFingerprint(@NotNull Collection<String> fingerprint) {
        this.serializeToDisk(() -> this.store(fingerprint, FINGERPRINT_FILENAME));
    }

    @Override
    public void setLevel(@Nullable SentryLevel level) {
        this.serializeToDisk(() -> {
            if (level == null) {
                this.delete(LEVEL_FILENAME);
            } else {
                this.store(level, LEVEL_FILENAME);
            }
        });
    }

    @Override
    public void setTransaction(@Nullable String transaction) {
        this.serializeToDisk(() -> {
            if (transaction == null) {
                this.delete(TRANSACTION_FILENAME);
            } else {
                this.store(transaction, TRANSACTION_FILENAME);
            }
        });
    }

    @Override
    public void setTrace(@Nullable SpanContext spanContext, @NotNull IScope scope) {
        this.serializeToDisk(() -> {
            if (spanContext == null) {
                this.store(scope.getPropagationContext().toSpanContext(), TRACE_FILENAME);
            } else {
                this.store(spanContext, TRACE_FILENAME);
            }
        });
    }

    @Override
    public void setContexts(@NotNull Contexts contexts) {
        this.serializeToDisk(() -> this.store(contexts, CONTEXTS_FILENAME));
    }

    @Override
    public void setReplayId(@NotNull SentryId replayId) {
        this.serializeToDisk(() -> this.store(replayId, REPLAY_FILENAME));
    }

    private void serializeToDisk(@NotNull Runnable task) {
        try {
            this.options.getExecutorService().submit(() -> {
                try {
                    task.run();
                }
                catch (Throwable e) {
                    this.options.getLogger().log(SentryLevel.ERROR, "Serialization task failed", e);
                }
            });
        }
        catch (Throwable e) {
            this.options.getLogger().log(SentryLevel.ERROR, "Serialization task could not be scheduled", e);
        }
    }

    private <T> void store(@NotNull T entity, @NotNull String fileName) {
        PersistingScopeObserver.store(this.options, entity, fileName);
    }

    private void delete(@NotNull String fileName) {
        CacheUtils.delete(this.options, SCOPE_CACHE, fileName);
    }

    public static <T> void store(@NotNull SentryOptions options, @NotNull T entity, @NotNull String fileName) {
        CacheUtils.store(options, entity, SCOPE_CACHE, fileName);
    }

    @Nullable
    public static <T> T read(@NotNull SentryOptions options, @NotNull String fileName, @NotNull Class<T> clazz) {
        return PersistingScopeObserver.read(options, fileName, clazz, null);
    }

    @Nullable
    public static <T, R> T read(@NotNull SentryOptions options, @NotNull String fileName, @NotNull Class<T> clazz, @Nullable JsonDeserializer<R> elementDeserializer) {
        return CacheUtils.read(options, SCOPE_CACHE, fileName, clazz, elementDeserializer);
    }
}

