/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.util.SampleRateUtils;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SentryReplayOptions {
    @Nullable
    private Double sessionSampleRate;
    @Nullable
    private Double errorSampleRate;
    private boolean redactAllText = true;
    private boolean redactAllImages = true;
    private Set<String> redactClasses = new CopyOnWriteArraySet<String>();
    private SentryReplayQuality quality = SentryReplayQuality.MEDIUM;
    private int frameRate = 1;
    private long errorReplayDuration = 30000L;
    private long sessionSegmentDuration = 5000L;
    private long sessionDuration = 3600000L;

    public SentryReplayOptions() {
    }

    public SentryReplayOptions(@Nullable Double sessionSampleRate, @Nullable Double errorSampleRate) {
        this.sessionSampleRate = sessionSampleRate;
        this.errorSampleRate = errorSampleRate;
    }

    @Nullable
    public Double getErrorSampleRate() {
        return this.errorSampleRate;
    }

    public boolean isSessionReplayEnabled() {
        return this.getSessionSampleRate() != null && this.getSessionSampleRate() > 0.0;
    }

    public void setErrorSampleRate(@Nullable Double errorSampleRate) {
        if (!SampleRateUtils.isValidSampleRate(errorSampleRate)) {
            throw new IllegalArgumentException("The value " + errorSampleRate + " is not valid. Use null to disable or values >= 0.0 and <= 1.0.");
        }
        this.errorSampleRate = errorSampleRate;
    }

    @Nullable
    public Double getSessionSampleRate() {
        return this.sessionSampleRate;
    }

    public boolean isSessionReplayForErrorsEnabled() {
        return this.getErrorSampleRate() != null && this.getErrorSampleRate() > 0.0;
    }

    public void setSessionSampleRate(@Nullable Double sessionSampleRate) {
        if (!SampleRateUtils.isValidSampleRate(sessionSampleRate)) {
            throw new IllegalArgumentException("The value " + sessionSampleRate + " is not valid. Use null to disable or values >= 0.0 and <= 1.0.");
        }
        this.sessionSampleRate = sessionSampleRate;
    }

    public boolean getRedactAllText() {
        return this.redactAllText;
    }

    public void setRedactAllText(boolean redactAllText) {
        this.redactAllText = redactAllText;
    }

    public boolean getRedactAllImages() {
        return this.redactAllImages;
    }

    public void setRedactAllImages(boolean redactAllImages) {
        this.redactAllImages = redactAllImages;
    }

    public Set<String> getRedactClasses() {
        return this.redactClasses;
    }

    public void addClassToRedact(String className) {
        this.redactClasses.add(className);
    }

    @ApiStatus.Internal
    @NotNull
    public SentryReplayQuality getQuality() {
        return this.quality;
    }

    public void setQuality(@NotNull SentryReplayQuality quality) {
        this.quality = quality;
    }

    @ApiStatus.Internal
    public int getFrameRate() {
        return this.frameRate;
    }

    @ApiStatus.Internal
    public long getErrorReplayDuration() {
        return this.errorReplayDuration;
    }

    @ApiStatus.Internal
    public long getSessionSegmentDuration() {
        return this.sessionSegmentDuration;
    }

    @ApiStatus.Internal
    public long getSessionDuration() {
        return this.sessionDuration;
    }

    public static enum SentryReplayQuality {
        LOW(0.8f, 50000),
        MEDIUM(1.0f, 75000),
        HIGH(1.0f, 100000);

        public final float sizeScale;
        public final int bitRate;

        private SentryReplayQuality(float sizeScale, int bitRate) {
            this.sizeScale = sizeScale;
            this.bitRate = bitRate;
        }
    }
}

