/*
 * Decompiled with CFR 0.152.
 */
package forge.util.storage;

import com.google.common.base.Function;
import forge.util.TextUtil;
import forge.util.storage.StorageReaderBase;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public abstract class StorageReaderRecursiveFolderWithUserFolder<T>
extends StorageReaderBase<T> {
    protected final File directory;
    protected final File userDirectory;
    public final List<String> objectsThatFailedToLoad = new ArrayList<String>();

    public File getDirectory() {
        return this.directory;
    }

    @Override
    public String getFullPath() {
        return this.directory.getPath();
    }

    public StorageReaderRecursiveFolderWithUserFolder(File itemDir0, File userItemDir0, Function<? super T, String> keySelector0) {
        super(keySelector0);
        this.directory = itemDir0;
        this.userDirectory = userItemDir0;
        if (this.directory == null) {
            throw new IllegalArgumentException("No directory specified");
        }
        try {
            if (this.directory.isFile()) {
                throw new IOException("Not a directory");
            }
            this.directory.mkdirs();
            if (!this.directory.isDirectory()) {
                throw new IOException("Directory can't be created");
            }
        }
        catch (IOException ex) {
            throw new RuntimeException("StorageReaderFolder.ctor() error, " + ex.getMessage());
        }
    }

    @Override
    public Map<String, T> readAll() {
        File[] files;
        Map result = this.createMap();
        Collection<File> forgeFormats = this.listFileTree(this.directory);
        Collection<File> customFormats = this.listFileTree(this.userDirectory);
        forgeFormats.addAll(customFormats);
        for (File file : files = forgeFormats.toArray(new File[0])) {
            try {
                T newDeck = this.read(file);
                if (null == newDeck) {
                    String msg = "An object stored in " + file.getPath() + " failed to load.\nPlease submit this as a bug with the mentioned file/directory attached.";
                    continue;
                }
                String newKey = (String)this.keySelector.apply(newDeck);
                if (result.containsKey(newKey)) {
                    System.err.println("StorageReaderFolder: Overwriting an object with key " + newKey);
                }
                result.put(newKey, newDeck);
            }
            catch (NoSuchElementException ex) {
                String message = TextUtil.concatWithSpace(file.getName(), "failed to load because ----", ex.getMessage());
                this.objectsThatFailedToLoad.add(message);
            }
        }
        return result;
    }

    private Collection<File> listFileTree(File dir) {
        HashSet<File> fileTree = new HashSet<File>();
        if (dir == null || dir.listFiles(this.getFileFilter()) == null) {
            return fileTree;
        }
        for (File entry : dir.listFiles(this.getFileFilter())) {
            if (entry.isFile()) {
                fileTree.add(entry);
                continue;
            }
            fileTree.addAll(this.listFileTree(entry));
        }
        return fileTree;
    }

    protected abstract T read(File var1);

    protected abstract FilenameFilter getFileFilter();

    @Override
    public String getItemKey(T item) {
        return (String)this.keySelector.apply(item);
    }

    @Override
    public Iterable<File> getSubFolders() {
        File[] list = this.directory.listFiles(file -> file.isDirectory() && !file.isHidden());
        return Arrays.asList(list);
    }
}

