/*
 * Decompiled with CFR 0.152.
 */
package forge.util.storage;

import com.google.common.base.Function;
import forge.util.FileUtil;
import forge.util.storage.StorageReaderBase;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class StorageReaderFileSections<T>
extends StorageReaderBase<T> {
    private final File file;

    public StorageReaderFileSections(String pathname, Function<? super T, String> keySelector0) {
        this(new File(pathname), keySelector0);
    }

    public StorageReaderFileSections(File file0, Function<? super T, String> keySelector0) {
        super(keySelector0);
        this.file = file0;
    }

    @Override
    public String getFullPath() {
        return this.file.getPath();
    }

    @Override
    public Map<String, T> readAll() {
        T item;
        Map result = this.createMap();
        int idx = 0;
        List<String> contents = FileUtil.readFile(this.file);
        ArrayList<String> accumulator = new ArrayList<String>();
        String header = null;
        for (String s2 : contents) {
            if (!this.lineContainsObject(s2)) continue;
            if (s2.charAt(0) == '[') {
                T item2;
                if (header != null && (item2 = this.readItem(header, accumulator, idx)) != null) {
                    result.put((String)this.keySelector.apply(item2), item2);
                    ++idx;
                }
                header = StringUtils.strip(s2, "[] ");
                accumulator.clear();
                continue;
            }
            accumulator.add(s2);
        }
        if (!accumulator.isEmpty() && (item = this.readItem(header, accumulator, idx)) != null) {
            String newKey = (String)this.keySelector.apply(item);
            if (result.containsKey(newKey)) {
                System.err.println("StorageReaderFileSelections: Overwriting an object with key " + newKey);
            }
            result.put(newKey, item);
        }
        return result;
    }

    private T readItem(String header, Iterable<String> accumulator, int idx) {
        T item = this.read(header, accumulator, idx);
        if (null != item) {
            return item;
        }
        String msg = "An object stored in " + this.file.getPath() + " failed to load.\nPlease submit this as a bug with the mentioned file attached.";
        throw new RuntimeException(msg);
    }

    protected abstract T read(String var1, Iterable<String> var2, int var3);

    protected boolean lineContainsObject(String line) {
        return !StringUtils.isBlank(line) && !line.trim().startsWith("#");
    }

    @Override
    public String getItemKey(T item) {
        return (String)this.keySelector.apply(item);
    }
}

