/*
 * Decompiled with CFR 0.152.
 */
package forge.util.maps;

import com.google.common.collect.Lists;
import forge.util.collect.FCollection;
import forge.util.collect.FCollectionView;
import forge.util.maps.LinkedHashMapToAmount;
import forge.util.maps.MapToAmount;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.tuple.Pair;

public final class MapToAmountUtil {
    private static final MapToAmount<?> EMPTY_MAP = new LinkedHashMapToAmount(0);

    private MapToAmountUtil() {
    }

    public static <T> Pair<T, Integer> max(MapToAmount<T> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        if (map.isEmpty()) {
            throw new NoSuchElementException();
        }
        int max = Integer.MIN_VALUE;
        Object maxElement = null;
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() <= max) continue;
            max = (Integer)entry.getValue();
            maxElement = entry.getKey();
        }
        return Pair.of(maxElement, max);
    }

    public static <T> FCollectionView<T> maxAll(MapToAmount<T> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        if (map.isEmpty()) {
            return new FCollection();
        }
        int max = (Integer)Collections.max(map.values());
        FCollection set = new FCollection();
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() != max) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    public static <T> Pair<T, Integer> min(MapToAmount<T> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        if (map.isEmpty()) {
            throw new NoSuchElementException();
        }
        int min2 = Integer.MAX_VALUE;
        Object minElement = null;
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() >= min2) continue;
            min2 = (Integer)entry.getValue();
            minElement = entry.getKey();
        }
        return Pair.of(minElement, min2);
    }

    public static <T> FCollectionView<T> minAll(MapToAmount<T> map) {
        if (map == null) {
            throw new NullPointerException();
        }
        if (map.isEmpty()) {
            return new FCollection();
        }
        int min2 = (Integer)Collections.min(map.values());
        FCollection set = new FCollection();
        for (Map.Entry entry : map.entrySet()) {
            if ((Integer)entry.getValue() != min2) continue;
            set.add(entry.getKey());
        }
        return set;
    }

    public static <T> List<Pair<T, Integer>> sort(MapToAmount<T> map) {
        ArrayList<Pair<T, Integer>> entries = Lists.newArrayListWithCapacity(map.size());
        for (Map.Entry entry : map.entrySet()) {
            entries.add(Pair.of(entry.getKey(), (Integer)entry.getValue()));
        }
        entries.sort(Map.Entry.comparingByValue());
        return entries;
    }

    public static <T> MapToAmount<T> emptyMap() {
        return EMPTY_MAP;
    }
}

