/*
 * Decompiled with CFR 0.152.
 */
package forge.util.maps;

import forge.util.maps.MapToAmount;
import java.util.EnumMap;
import java.util.Map;

public class EnumMapToAmount<T extends Enum<T>>
extends EnumMap<T, Integer>
implements MapToAmount<T> {
    private static final long serialVersionUID = -4749796492075359368L;

    public EnumMapToAmount(Class<T> keyType) {
        super(keyType);
    }

    public EnumMapToAmount(EnumMap<T, ? extends Integer> m4) {
        super(m4);
    }

    public EnumMapToAmount(Map<T, ? extends Integer> m4) {
        super(m4);
    }

    @Override
    public void add(T item) {
        this.add(item, 1);
    }

    @Override
    public void add(T item, int amount) {
        if (amount <= 0) {
            return;
        }
        Integer cur = (Integer)this.get(item);
        int newVal = cur == null ? amount : amount + cur;
        this.put(item, newVal);
    }

    @Override
    public void addAll(Iterable<T> items) {
        for (Enum i : items) {
            this.add((T)i, 1);
        }
    }

    @Override
    public boolean substract(T item) {
        return this.substract(item, 1);
    }

    @Override
    public boolean substract(T item, int amount) {
        Integer cur = (Integer)this.get(item);
        if (cur == null) {
            return false;
        }
        int newVal = cur - amount;
        if (newVal > 0) {
            this.put(item, newVal);
        } else {
            this.remove(item);
        }
        return true;
    }

    @Override
    public void substractAll(Iterable<T> items) {
        for (Enum i : items) {
            this.substract((T)i);
        }
    }

    @Override
    public int countAll() {
        int c = 0;
        for (Map.Entry kv : this.entrySet()) {
            c += ((Integer)kv.getValue()).intValue();
        }
        return c;
    }

    @Override
    public int count(T item) {
        Integer cur = (Integer)this.get(item);
        return cur == null ? 0 : cur;
    }
}

