/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import java.io.File;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmlUtil {
    public static String nodeToString(Node node) {
        StringWriter sw = new StringWriter();
        try {
            Transformer t2 = TransformerFactory.newInstance().newTransformer();
            t2.setOutputProperty("omit-xml-declaration", "yes");
            t2.setOutputProperty("indent", "yes");
            t2.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            t2.transform(new DOMSource(node), new StreamResult(sw));
        }
        catch (TransformerException te) {
            System.out.println("nodeToString Transformer Exception");
        }
        return sw.toString();
    }

    public static void saveDocument(Document document, String filename) throws TransformerException {
        Transformer t2 = TransformerFactory.newInstance().newTransformer();
        t2.setOutputProperty("omit-xml-declaration", "yes");
        t2.setOutputProperty("indent", "yes");
        t2.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(document);
        StreamResult result = new StreamResult(new File(filename));
        t2.transform(source, result);
    }

    public static int getIntAttribute(Element el, String name) {
        String value = el.getAttribute(name);
        if (value.length() > 0) {
            try {
                return Integer.parseInt(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    public static long getLongAttribute(Element el, String name) {
        String value = el.getAttribute(name);
        if (value.length() > 0) {
            try {
                return Long.parseLong(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static String getStringAttribute(Element el, String name) {
        String value = el.getAttribute(name);
        if (value.length() > 0) {
            return value;
        }
        return null;
    }

    public static boolean getBooleanAttribute(Element el, String name) {
        String value = el.getAttribute(name);
        if (value.length() > 0) {
            try {
                return Boolean.parseBoolean(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

