/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class WordUtil {
    private static final Pattern patternToWrapOn = Pattern.compile(" ");

    public static String capitalize(String str) {
        if (StringUtils.isEmpty(str)) {
            return str;
        }
        char[] buffer = str.toCharArray();
        boolean capitalizeNext = true;
        for (int i = 0; i < buffer.length; ++i) {
            char ch = buffer[i];
            if (Character.isWhitespace(ch)) {
                capitalizeNext = true;
                continue;
            }
            if (!capitalizeNext) continue;
            buffer[i] = Character.toTitleCase(ch);
            capitalizeNext = false;
        }
        return new String(buffer);
    }

    public static String wordWrapAsHTML(String str) {
        String result = null;
        int wrapLength = 40;
        String newLineStr = "<br>";
        if (str != null) {
            int inputLineLength = str.length();
            int offset = 0;
            StringBuilder wrappedLine = new StringBuilder(inputLineLength + 32);
            while (offset < inputLineLength) {
                int spaceToWrapAt = -1;
                Matcher matcher = patternToWrapOn.matcher(str.substring(offset, Math.min(offset + wrapLength + 1, inputLineLength)));
                if (matcher.find()) {
                    if (matcher.start() == 0) {
                        offset += matcher.end();
                        continue;
                    }
                    spaceToWrapAt = matcher.start() + offset;
                }
                if (inputLineLength - offset <= wrapLength) break;
                while (matcher.find()) {
                    spaceToWrapAt = matcher.start() + offset;
                }
                if (spaceToWrapAt >= offset) {
                    wrappedLine.append(str, offset, spaceToWrapAt);
                    wrappedLine.append(newLineStr);
                    offset = spaceToWrapAt + 1;
                    continue;
                }
                matcher = patternToWrapOn.matcher(str.substring(offset + wrapLength));
                if (matcher.find()) {
                    spaceToWrapAt = matcher.start() + offset + wrapLength;
                }
                if (spaceToWrapAt >= 0) {
                    wrappedLine.append(str, offset, spaceToWrapAt);
                    wrappedLine.append(newLineStr);
                    offset = spaceToWrapAt + 1;
                    continue;
                }
                wrappedLine.append(str, offset, str.length());
                offset = inputLineLength;
            }
            wrappedLine.append(str, offset, str.length());
            result = wrappedLine.toString();
        }
        return "<html>" + result + "</html>";
    }

    private WordUtil() {
    }
}

