/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.List;

public class RestartUtil {
    public static final String SUN_JAVA_COMMAND = "sun.java.command";

    public static boolean prepareForRestart() {
        try {
            String java = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
            StringBuffer vmArgsOneLine = new StringBuffer();
            for (String arg : vmArguments) {
                if (arg.contains("-agentlib")) continue;
                vmArgsOneLine.append(arg);
                vmArgsOneLine.append(" ");
            }
            final StringBuffer cmd = new StringBuffer("\"" + java + "\" " + vmArgsOneLine);
            String[] mainCommand = System.getProperty(SUN_JAVA_COMMAND).split(" ");
            if (mainCommand[0].endsWith(".jar")) {
                cmd.append("-jar ").append(new File(mainCommand[0]).getPath());
            } else {
                cmd.append("-cp \"").append(System.getProperty("java.class.path")).append("\" ").append(mainCommand[0]);
            }
            for (int i = 1; i < mainCommand.length; ++i) {
                cmd.append(" ");
                cmd.append(mainCommand[i]);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    try {
                        Runtime.getRuntime().exec(cmd.toString());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

