/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import com.google.common.base.Predicate;
import forge.item.PaperCard;

public abstract class PredicateCard<T>
implements Predicate<T> {
    private final StringOp operator;

    protected final boolean op(PaperCard op1, PaperCard op2) {
        switch (this.getOperator()) {
            case EQUALS: {
                return op1.equals(op2);
            }
        }
        return false;
    }

    public PredicateCard(StringOp operator) {
        this.operator = operator;
    }

    public StringOp getOperator() {
        return this.operator;
    }

    public static PredicateCard<PaperCard> equals(final PaperCard what) {
        return new PredicateCard<PaperCard>(StringOp.EQUALS){

            @Override
            public boolean apply(PaperCard subject) {
                return this.op(subject, what);
            }
        };
    }

    public static enum StringOp {
        EQUALS;

    }
}

