/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class LineReader
implements Iterable<String>,
Closeable {
    private final BufferedReader reader;

    public LineReader(InputStream stream) {
        this(stream, null);
    }

    public LineReader(InputStream stream, Charset charset) {
        this.reader = new BufferedReader(new InputStreamReader(stream, charset));
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    @Override
    public Iterator<String> iterator() {
        return new LineIterator();
    }

    public Collection<String> readLines() {
        ArrayList<String> lines = new ArrayList<String>();
        for (String line : this) {
            lines.add(line);
        }
        return lines;
    }

    private class LineIterator
    implements Iterator<String> {
        private String nextLine;

        private LineIterator() {
        }

        public String bufferNext() {
            try {
                this.nextLine = LineReader.this.reader.readLine();
                return this.nextLine;
            }
            catch (IOException e) {
                throw new IllegalStateException("I/O error while reading stream.", e);
            }
        }

        @Override
        public boolean hasNext() {
            boolean hasNext;
            boolean bl = hasNext = this.nextLine != null || this.bufferNext() != null;
            if (!hasNext) {
                try {
                    LineReader.this.reader.close();
                }
                catch (IOException e) {
                    throw new IllegalStateException("I/O error when closing stream.", e);
                }
            }
            return hasNext;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            String result = this.nextLine;
            this.nextLine = null;
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

