/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;

public final class LayoutHelper {
    private final float parentWidth;
    private final float parentHeight;
    private float x;
    private float y;
    private float lineBottom;
    private float gapX;
    private float gapY;

    public LayoutHelper(FContainer parent) {
        this(parent, 3.0f, 3.0f);
    }

    public LayoutHelper(FContainer parent, float gapX0, float gapY0) {
        this.parentWidth = parent.getWidth();
        this.parentHeight = parent.getHeight();
        this.gapX = gapX0;
        this.gapY = gapY0;
    }

    public void fill(FDisplayObject obj) {
        this.newLine();
        this.include(obj, this.parentWidth, this.parentHeight - this.y);
    }

    public void fillLine(FDisplayObject obj, float height) {
        this.fillLine(obj, height, 0.0f);
    }

    public void fillLine(FDisplayObject obj, float height, float rightPadding) {
        if (this.x >= this.parentWidth) {
            this.newLine();
        }
        this.include(obj, this.parentWidth - this.x - rightPadding, height);
    }

    public void include(FDisplayObject obj, double widthPercent, float height) {
        this.include(obj, (float)Math.round((double)this.parentWidth * widthPercent), height);
    }

    public void include(FDisplayObject obj, float width, double heightPercent) {
        this.include(obj, width, (float)Math.round((double)this.parentHeight * heightPercent));
    }

    public void include(FDisplayObject obj, double widthPercent, double heightPercent) {
        this.include(obj, (float)Math.round((double)this.parentWidth * widthPercent), (float)Math.round((double)this.parentHeight * heightPercent));
    }

    public void include(FDisplayObject obj, float width, float height) {
        if (width <= 0.0f || height <= 0.0f) {
            return;
        }
        if (this.x + width > this.parentWidth + 1.0f) {
            this.newLine();
            if (width > this.parentWidth) {
                width = this.parentWidth;
            }
        }
        if (this.y + height > this.parentHeight) {
            this.y = this.parentHeight - height;
            if (this.y >= this.parentHeight) {
                return;
            }
        }
        obj.setBounds(this.x, this.y, width, height);
        this.x += width + this.gapX;
        if (this.y + height > this.lineBottom) {
            this.lineBottom = this.y + height;
        }
    }

    public void offset(float dx, float dy) {
        this.x += dx;
        this.y += dy;
    }

    public void newLine() {
        if (this.lineBottom == this.y) {
            return;
        }
        this.x = 0.0f;
        this.lineBottom = this.y = this.lineBottom + this.gapY;
    }

    public void newLine(float dy) {
        this.x = 0.0f;
        this.lineBottom = this.y = this.lineBottom + this.gapY + dy;
    }

    public float getRemainingLineWidth() {
        if (this.x >= this.parentWidth) {
            this.newLine();
        }
        return this.parentWidth - this.x;
    }

    public float getParentWidth() {
        return this.parentWidth;
    }

    public float getParentHeight() {
        return this.parentHeight;
    }

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getGapX() {
        return this.gapX;
    }

    public float getGapY() {
        return this.gapY;
    }
}

