/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import forge.util.lang.LangChinese;
import forge.util.lang.LangEnglish;
import forge.util.lang.LangFrench;
import forge.util.lang.LangGerman;
import forge.util.lang.LangItalian;
import forge.util.lang.LangJapanese;
import forge.util.lang.LangSpanish;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public abstract class Lang {
    private static Lang instance;
    private static Lang englishInstance;
    protected String languageCode;
    protected String countryCode;
    private static final Pattern VOWEL_PATTERN;
    public static final String[] numbers0;
    public static final String[] numbers20;

    public static void createInstance(String localeID) {
        String[] splitLocale = localeID.split("-");
        String language = splitLocale[0];
        String country = splitLocale[1];
        instance = language.equals("de") ? new LangGerman() : (language.equals("es") ? new LangSpanish() : (language.equals("it") ? new LangItalian() : (language.equals("zh") ? new LangChinese() : (language.equals("ja") ? new LangJapanese() : (language.equals("fr") ? new LangFrench() : new LangEnglish())))));
        Lang.instance.languageCode = language;
        Lang.instance.countryCode = country;
        englishInstance = new LangEnglish();
        Lang.englishInstance.languageCode = "en";
        Lang.englishInstance.countryCode = "US";
    }

    public static Lang getInstance() {
        return instance;
    }

    public static Lang getEnglishInstance() {
        return englishInstance;
    }

    protected Lang() {
    }

    public abstract String getOrdinal(int var1);

    public static String joinHomogenous(String s1, String s2) {
        boolean has1 = StringUtils.isNotBlank(s1);
        boolean has2 = StringUtils.isNotBlank(s2);
        return has1 ? (has2 ? s1 + " and " + s2 : s1) : (has2 ? s2 : "");
    }

    public static <T> String joinHomogenous(Iterable<T> objects) {
        return Lang.joinHomogenous(Lists.newArrayList(objects));
    }

    public static <T> String joinHomogenous(Collection<T> objects) {
        return Lang.joinHomogenous(objects, null, "and");
    }

    public static <T> String joinHomogenous(Collection<T> objects, Function<T, String> accessor) {
        return Lang.joinHomogenous(objects, accessor, "and");
    }

    public static <T> String joinHomogenous(Collection<T> objects, Function<T, String> accessor, String lastUnion) {
        int remaining = objects.size();
        StringBuilder sb = new StringBuilder();
        for (T obj : objects) {
            --remaining;
            if (accessor != null) {
                sb.append(accessor.apply(obj));
            } else {
                sb.append(obj);
            }
            if (remaining > 1) {
                sb.append(", ");
                continue;
            }
            if (remaining != 1) continue;
            sb.append(" ").append(lastUnion).append(" ");
        }
        return sb.toString();
    }

    public static <T> String joinVerb(List<T> subjects, String verb) {
        return subjects.size() > 1 || !Lang.subjectIsSingle3rdPerson(Iterables.getFirst(subjects, "it").toString()) ? verb : Lang.verbs3rdPersonSingular(verb);
    }

    public static String joinVerb(String subject, String verb) {
        return !Lang.subjectIsSingle3rdPerson(subject) ? verb : Lang.verbs3rdPersonSingular(verb);
    }

    public static boolean subjectIsSingle3rdPerson(String subject) {
        return !"You".equalsIgnoreCase(subject);
    }

    public static String verbs3rdPersonSingular(String verb) {
        return verb + "s";
    }

    public static String getPlural(String noun) {
        return noun + (noun.endsWith("s") && !noun.endsWith("ds") || noun.endsWith("x") || noun.endsWith("ch") ? "es" : (noun.endsWith("ds") ? "" : "s"));
    }

    public static String nounWithAmount(int cnt, String noun) {
        String countedForm;
        String string = countedForm = cnt == 1 ? noun : Lang.getPlural(noun);
        String strCount = cnt == 1 ? (Lang.startsWithVowel(noun) ? "an " : "a ") : cnt + " ";
        return strCount + countedForm;
    }

    public static String nounWithNumeral(int cnt, String noun) {
        String countedForm = cnt == 1 ? noun : Lang.getPlural(noun);
        return Lang.getNumeral(cnt) + " " + countedForm;
    }

    public static String nounWithNumeral(String cnt, String noun) {
        if (StringUtils.isNumeric(cnt)) {
            return Lang.nounWithNumeral(Integer.parseInt(cnt), noun);
        }
        return cnt + " " + Lang.getPlural(noun);
    }

    public static String nounWithNumeralExceptOne(int cnt, String noun) {
        String countedForm;
        String string = countedForm = cnt == 1 ? noun : Lang.getPlural(noun);
        String desc = cnt == 1 ? (Lang.startsWithVowel(countedForm) ? "an" : "a") : Lang.getNumeral(cnt);
        return desc + " " + countedForm;
    }

    public static String nounWithNumeralExceptOne(String cnt, String noun) {
        if (StringUtils.isNumeric(cnt)) {
            return Lang.nounWithNumeralExceptOne(Integer.parseInt(cnt), noun);
        }
        return cnt + " " + Lang.getPlural(noun);
    }

    public abstract String getPossesive(String var1);

    public abstract String getPossessedObject(String var1, String var2);

    public static boolean startsWithVowel(String word) {
        return Lang.isVowel(word.trim().charAt(0));
    }

    public static boolean isVowel(char letter) {
        return VOWEL_PATTERN.matcher(String.valueOf(letter)).find();
    }

    public static String getNumeral(int n) {
        String prefix = n < 0 ? "minus " : "";
        if ((n = Math.abs(n)) >= 0 && n < 20) {
            return prefix + numbers0[n];
        }
        if (n < 100) {
            int n1 = n % 10;
            String ones = n1 == 0 ? "" : numbers0[n1];
            return prefix + numbers20[n / 10 - 2] + " " + ones;
        }
        return Integer.toString(n);
    }

    public String getNickName(String name) {
        if (name.contains(",")) {
            return name.split(",")[0];
        }
        if (name.contains(":")) {
            return name.split(":")[0];
        }
        return name.split(" ")[0];
    }

    static {
        VOWEL_PATTERN = Pattern.compile("[aeiou]", 2);
        numbers0 = new String[]{"zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "ten", "eleven", "twelve", "thirteen", "fourteen", "fifteen", "sixteen", "seventeen", "eighteen", "nineteen"};
        numbers20 = new String[]{"twenty", "thirty", "forty", "fifty", "sixty", "seventy", "eighty", "ninety"};
    }
}

