/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import forge.ImageKeys;
import forge.StaticData;
import forge.card.CardDb;
import forge.card.CardRules;
import forge.card.CardSplitType;
import forge.item.PaperCard;
import forge.util.TextUtil;
import org.apache.commons.lang3.StringUtils;

public class ImageUtil {
    public static float getNearestHQSize(float baseSize, float actualSize) {
        return (float)Math.round(actualSize) * (float)Math.pow(2.0, Math.round(Math.log(baseSize / actualSize) / Math.log(2.0)));
    }

    public static PaperCard getPaperCardFromImageKey(String imageKey) {
        if (imageKey == null || imageKey.length() < 2) {
            return null;
        }
        String key = imageKey.startsWith("c:") ? imageKey.substring("c:".length()) : (imageKey.startsWith("t:") ? imageKey.substring("t:".length()) : (imageKey.startsWith("i:") ? imageKey.substring("i:".length()) : (imageKey.startsWith("b:") ? imageKey.substring("b:".length()) : (imageKey.startsWith("f:") ? imageKey.substring("f:".length()) : (imageKey.startsWith("x:") ? imageKey.substring("x:".length()) : (imageKey.startsWith("p:") ? imageKey.substring("p:".length()) : (imageKey.startsWith("o:") ? imageKey.substring("o:".length()) : (imageKey.startsWith("a:") ? imageKey.substring("a:".length()) : (imageKey.contains(".full") ? ImageUtil.transformKey(imageKey) : imageKey)))))))));
        PaperCard cp = StaticData.instance().getCommonCards().getCard(key);
        if (cp == null) {
            cp = StaticData.instance().getVariantCards().getCard(key);
        }
        return cp;
    }

    public static String transformKey(String imageKey) {
        String edition = imageKey.substring(0, imageKey.indexOf("/"));
        String artIndex = imageKey.substring(imageKey.indexOf("/") + 1, imageKey.indexOf(".")).replaceAll("[^0-9]", "");
        String name = artIndex.isEmpty() ? imageKey.substring(imageKey.indexOf("/") + 1, imageKey.indexOf(".")) : imageKey.substring(imageKey.indexOf("/") + 1, imageKey.indexOf(artIndex));
        String key = name + "|" + edition;
        if (!artIndex.isEmpty()) {
            key = key + "|" + artIndex;
        }
        return key;
    }

    public static String getImageRelativePath(PaperCard cp, String face, boolean includeSet, boolean isDownloadUrl) {
        String fname;
        boolean hasManyPictures;
        int cntPictures;
        CardDb db;
        String nameToUse;
        String string = nameToUse = cp == null ? null : ImageUtil.getNameToUse(cp, face);
        if (nameToUse == null) {
            return null;
        }
        StringBuilder s2 = new StringBuilder();
        CardRules card = cp.getRules();
        String edition = cp.getEdition();
        s2.append(ImageUtil.toMWSFilename(nameToUse));
        CardDb cardDb = db = !card.isVariant() ? StaticData.instance().getCommonCards() : StaticData.instance().getVariantCards();
        if (includeSet) {
            cntPictures = db.getArtCount(card.getName(), edition, cp.getFunctionalVariant());
            hasManyPictures = cntPictures > 1;
        } else {
            cntPictures = 1;
            int maxCntPictures = db.getMaxArtIndex(card.getName());
            hasManyPictures = maxCntPictures > 1;
        }
        int artIdx = cp.getArtIndex() - 1;
        if (hasManyPictures) {
            if (cntPictures <= artIdx) {
                artIdx %= cntPictures;
            }
            s2.append(artIdx + 1);
        }
        if (!card.getType().isPlane() && !card.getType().isPhenomenon()) {
            s2.append(".full");
        }
        if (isDownloadUrl) {
            s2.append(".jpg");
            fname = s2.toString().replaceAll("\\s", "%20");
        } else {
            fname = s2.toString();
        }
        if (includeSet) {
            String editionAliased;
            String string2 = editionAliased = isDownloadUrl ? StaticData.instance().getEditions().getCode2ByCode(edition) : ImageKeys.getSetFolder(edition);
            if (editionAliased == "") {
                editionAliased = edition;
            }
            return TextUtil.concatNoSpace(editionAliased, "/", fname);
        }
        return fname;
    }

    public static String getNameToUse(PaperCard cp, String face) {
        CardRules card = cp.getRules();
        if (face.equals("back")) {
            if (cp.hasBackFace()) {
                if (card.getOtherPart() != null) {
                    return card.getOtherPart().getName();
                }
                if (!card.getMeldWith().isEmpty()) {
                    CardDb db = StaticData.instance().getCommonCards();
                    return db.getRules(card.getMeldWith()).getOtherPart().getName();
                }
                return null;
            }
            return null;
        }
        if (face.equals("white")) {
            if (card.getWSpecialize() != null) {
                return card.getWSpecialize().getName();
            }
        } else if (face.equals("blue")) {
            if (card.getUSpecialize() != null) {
                return card.getUSpecialize().getName();
            }
        } else if (face.equals("black")) {
            if (card.getBSpecialize() != null) {
                return card.getBSpecialize().getName();
            }
        } else if (face.equals("red")) {
            if (card.getRSpecialize() != null) {
                return card.getRSpecialize().getName();
            }
        } else if (face.equals("green")) {
            if (card.getGSpecialize() != null) {
                return card.getGSpecialize().getName();
            }
        } else {
            if (CardSplitType.Split == cp.getRules().getSplitType()) {
                return card.getMainPart().getName() + card.getOtherPart().getName();
            }
            if (!"".equals(cp.getFunctionalVariant())) {
                return cp.getName() + " " + cp.getFunctionalVariant();
            }
        }
        return cp.getName();
    }

    public static String getImageKey(PaperCard cp, String face, boolean includeSet) {
        return ImageUtil.getImageRelativePath(cp, face, includeSet, false);
    }

    public static String getDownloadUrl(PaperCard cp, String face) {
        return ImageUtil.getImageRelativePath(cp, face, true, true);
    }

    public static String getScryfallDownloadUrl(PaperCard cp, String face, String setCode, String langCode, boolean useArtCrop) {
        return ImageUtil.getScryfallDownloadUrl(cp, face, setCode, langCode, useArtCrop, false);
    }

    public static String getScryfallDownloadUrl(PaperCard cp, String face, String setCode, String langCode, boolean useArtCrop, boolean hyphenateAlchemy) {
        String editionCode = setCode != null && setCode.length() > 0 ? setCode : cp.getEdition().toLowerCase();
        String cardCollectorNumber = cp.getCollectorNumber();
        if ((cardCollectorNumber = cardCollectorNumber.replace("+", "\u2020")).startsWith("OHOP")) {
            editionCode = "ohop";
            cardCollectorNumber = cardCollectorNumber.substring("OHOP".length());
        } else if (cardCollectorNumber.startsWith("OPCA")) {
            editionCode = "opca";
            cardCollectorNumber = cardCollectorNumber.substring("OPCA".length());
        } else if (cardCollectorNumber.startsWith("OPC2")) {
            editionCode = "opc2";
            cardCollectorNumber = cardCollectorNumber.substring("OPC2".length());
        } else if (hyphenateAlchemy) {
            if (!cardCollectorNumber.startsWith("A")) {
                return null;
            }
            cardCollectorNumber = cardCollectorNumber.replace("A", "A-");
        }
        String versionParam = useArtCrop ? "art_crop" : "normal";
        String faceParam = "";
        if (cp.getRules().getOtherPart() != null) {
            faceParam = face.equals("back") ? "&face=back" : "&face=front";
        }
        return String.format("%s/%s/%s?format=image&version=%s%s", editionCode, cardCollectorNumber, langCode, versionParam, faceParam);
    }

    public static String toMWSFilename(String in) {
        in = StringUtils.stripAccents(in);
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (c == '\"' || c == '/' || c == ':' || c == '?') continue;
            out.append(c);
        }
        return out.toString();
    }
}

