/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import forge.localinstance.properties.ForgePreferences;
import forge.util.FileUtil;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;

public class HttpUtil {
    private static final String BOUNDARY = "--7d021a37605f0";

    public static void upload(String sURL, String file) {
        HttpUtil.upload(sURL, new File(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upload(String url, Collection<?> data) {
        File tempFile = null;
        try {
            tempFile = File.createTempFile("forge.upload", null);
            FileUtil.writeFile(tempFile, data);
            HttpUtil.upload(url, tempFile);
        }
        catch (IOException e) {
            System.err.println("unable to write to temp file for upload");
        }
        finally {
            if (null != tempFile) {
                tempFile.delete();
            }
        }
    }

    public static void upload(String sURL, File f) {
        URL url = null;
        try {
            url = new URL(sURL);
        }
        catch (MalformedURLException e) {
            return;
        }
        HttpURLConnection theUrlConnection = null;
        try {
            theUrlConnection = (HttpURLConnection)url.openConnection();
        }
        catch (IOException e) {
            return;
        }
        theUrlConnection.setDoOutput(true);
        theUrlConnection.setDoInput(true);
        theUrlConnection.setUseCaches(false);
        theUrlConnection.setChunkedStreamingMode(1024);
        theUrlConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=--7d021a37605f0");
        DataOutputStream httpOut = null;
        try {
            httpOut = new DataOutputStream(theUrlConnection.getOutputStream());
        }
        catch (IOException e1) {
            return;
        }
        String str = "----7d021a37605f0\r\nContent-Disposition: form-data;name=\"data\"; filename=\"" + f.getName() + "\"\r\nContent-Type: text/plain\r\n\r\n";
        try {
            httpOut.write(str.getBytes());
        }
        catch (IOException e) {
            return;
        }
        int numBytesToRead = 1024;
        try (FileInputStream uploadFileReader = new FileInputStream(f);){
            int availableBytesToRead;
            while ((availableBytesToRead = uploadFileReader.available()) > 0) {
                byte[] bufferBytesRead = availableBytesToRead >= 1024 ? new byte[1024] : new byte[availableBytesToRead];
                uploadFileReader.read(bufferBytesRead);
                httpOut.write(bufferBytesRead);
                httpOut.flush();
            }
        }
        catch (IOException e) {
            return;
        }
        try {
            httpOut.write("----7d021a37605f0--\r\n".getBytes());
        }
        catch (IOException e) {
            return;
        }
        try {
            httpOut.flush();
        }
        catch (IOException e) {
            return;
        }
        try {
            httpOut.close();
        }
        catch (IOException e) {
            return;
        }
        InputStream is = null;
        try {
            is = theUrlConnection.getInputStream();
        }
        catch (IOException e) {
            return;
        }
        StringBuilder response = new StringBuilder();
        byte[] respBuffer = new byte[8192];
        try {
            while (is.read(respBuffer) >= 0) {
                response.append(new String(respBuffer).trim());
            }
        }
        catch (IOException e) {
            return;
        }
        try {
            is.close();
        }
        catch (IOException e) {
            return;
        }
        if (ForgePreferences.DEV_MODE) {
            System.out.println(response.toString());
        }
    }

    public static String getURL(String sURL) {
        URL url = null;
        try {
            url = new URL(sURL);
        }
        catch (MalformedURLException e) {
            return null;
        }
        int ptr = 0;
        StringBuffer buffer = new StringBuffer();
        try (InputStream is = url.openStream();){
            while ((ptr = is.read()) != -1) {
                buffer.append((char)ptr);
            }
        }
        catch (IOException e) {
            return null;
        }
        return buffer.toString();
    }

    private HttpUtil() {
    }
}

