/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import forge.util.TextUtil;
import forge.util.ThreadUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class FileUtil {
    private FileUtil() {
        throw new AssertionError();
    }

    public static String pathCombine(String path1, String path2) {
        File file1 = new File(path1);
        File file2 = new File(file1, path2);
        return file2.getPath();
    }

    public static boolean doesFileExist(String filename) {
        File f = new File(filename);
        return f.exists();
    }

    public static boolean isDirectoryWithFiles(String path) {
        if (path == null) {
            return false;
        }
        File f = new File(path);
        String[] fileList = f.list();
        return fileList != null && fileList.length > 0;
    }

    public static boolean ensureDirectoryExists(String path) {
        return FileUtil.ensureDirectoryExists(new File(path));
    }

    public static boolean ensureDirectoryExists(File dir) {
        return dir.exists() && dir.isDirectory() || dir.mkdirs();
    }

    public static boolean deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            for (String filename : dir.list()) {
                if (FileUtil.deleteDirectory(new File(dir, filename))) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteFile(String filename) {
        try {
            File file = new File(filename);
            return file.delete();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void copyFile(String sourceFilename, String destFilename) {
        File source = new File(sourceFilename);
        if (!source.exists()) {
            return;
        }
        try (InputStream is = Files.newInputStream(source.toPath(), new OpenOption[0]);
             OutputStream os = Files.newOutputStream(new File(destFilename).toPath(), new OpenOption[0]);){
            int length;
            byte[] buffer = new byte[1024];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void writeFile(String filename, String text) {
        FileUtil.writeFile(new File(filename), text);
    }

    public static void writeFile(File file, String text) {
        try (PrintWriter p = new PrintWriter(file);){
            p.print(text);
        }
        catch (Exception ex) {
            throw new RuntimeException("FileUtil : writeFile() error, problem writing file - " + file + " : " + ex);
        }
    }

    public static void writeFile(String filename, List<String> data) {
        FileUtil.writeFile(new File(filename), data);
    }

    public static void writeFile(File file, Collection<?> data) {
        try (PrintWriter p = new PrintWriter(file);){
            for (Object o : data) {
                p.println(o);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException("FileUtil : writeFile() error, problem writing file - " + file + " : " + ex);
        }
    }

    public static String readFileToString(String filename) {
        return FileUtil.readFileToString(new File(filename));
    }

    public static String readFileToString(File file) {
        return TextUtil.join(FileUtil.readFile(file), "\n");
    }

    public static List<String> readFile(String filename) {
        return FileUtil.readFile(new File(filename));
    }

    public static List<String> readFile(File file) {
        try {
            if (file == null || !file.exists()) {
                return new ArrayList<String>();
            }
            return FileUtil.readAllLines(file, false);
        }
        catch (Exception ex) {
            throw new RuntimeException("FileUtil : readFile() error, " + ex);
        }
    }

    public static List<String> readAllLines(Reader reader) {
        return FileUtil.readAllLines(reader, false);
    }

    public static List<String> readAllLines(Reader reader, boolean mayTrim) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(reader);
            while ((line = in.readLine()) != null) {
                if (mayTrim) {
                    line = line.trim();
                }
                list.add(line);
            }
            in.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("FileUtil : readAllLines() error, " + ex);
        }
        return list;
    }

    public static List<String> readAllLines(File file, boolean mayTrim) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(Files.newInputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));
            while ((line = in.readLine()) != null) {
                if (mayTrim) {
                    line = line.trim();
                }
                list.add(line);
            }
            in.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("FileUtil : readAllLines() error, " + ex);
        }
        return list;
    }

    public static List<Pair<String, String>> readNameUrlFile(String nameUrlFile) {
        Pattern lineSplitter = Pattern.compile(Pattern.quote(" "));
        Pattern replacer = Pattern.compile(Pattern.quote("%20"));
        ArrayList<Pair<String, String>> list = new ArrayList<Pair<String, String>>();
        for (String line : FileUtil.readFile(nameUrlFile)) {
            if (StringUtils.isBlank(line) || line.startsWith("#")) continue;
            String[] parts = lineSplitter.split(line, 2);
            if (2 == parts.length) {
                list.add(Pair.of(replacer.matcher(parts[0]).replaceAll(" "), parts[1]));
                continue;
            }
            Pattern pathSplitter = Pattern.compile(Pattern.quote("/"));
            String[] pathParts = pathSplitter.split(parts[0]);
            String last = pathParts[pathParts.length - 1];
            list.add(Pair.of(replacer.matcher(last).replaceAll(" "), parts[0]));
        }
        return list;
    }

    public static String readFileToString(URL url) {
        return TextUtil.join(FileUtil.readFile(url), "\n");
    }

    public static List<String> readFile(URL url) {
        ArrayList<String> lines = new ArrayList<String>();
        ThreadUtil.executeWithTimeout(() -> {
            try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));){
                String line;
                while ((line = in.readLine()) != null) {
                    lines.add(line);
                }
            }
            return null;
        }, 5000);
        return lines;
    }

    public static String getParent(String resourcePath) {
        File f = new File(resourcePath);
        if (f.getParentFile().getName() != null) {
            return f.getParentFile().getName();
        }
        return "";
    }
}

