/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import forge.util.ITranslatable;
import forge.util.Lang;
import forge.util.LineReader;
import forge.util.Localizer;
import forge.util.TextUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class CardTranslation {
    private static Map<String, String> translatednames;
    private static Map<String, String> translatedtypes;
    private static Map<String, String> translatedoracles;
    private static Map<String, List<Pair<String, String>>> oracleMappings;
    private static Map<String, String> translatedCaches;
    private static Map<String, String> translatedEffectNames;
    private static Map<String, String> translatedTokenNames;
    private static final List<String> knownEffectNames;
    private static String languageSelected;

    private static void readTranslationFile(String language, String languagesDirectory) {
        block11: {
            String filename = "cardnames-" + language + ".txt";
            try (LineReader translationFile = new LineReader(Files.newInputStream(Paths.get(languagesDirectory + filename, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8);){
                for (String line : translationFile.readLines()) {
                    String[] matches = line.split("\\|");
                    if (matches.length >= 2) {
                        String[] variantSplit;
                        if (matches[0].indexOf(36) > 0 && (variantSplit = matches[0].split("\\s*\\$", 2)).length > 1) {
                            translatednames.put(variantSplit[0], matches[1]);
                            matches[0] = variantSplit[0] + " $" + variantSplit[1];
                        }
                        translatednames.put(matches[0], matches[1]);
                    }
                    if (matches.length >= 3) {
                        translatedtypes.put(matches[0], matches[2]);
                    }
                    if (matches.length < 4) continue;
                    String toracle = matches[3];
                    toracle = toracle.replace("//Level_2//\\n", "").replace("//Level_3//\\n", "");
                    toracle = toracle.replace("\\n", "\r\n\r\n").replace("VERT", "|");
                    translatedoracles.put(matches[0], toracle);
                }
            }
            catch (IOException e) {
                if ("en-US".equalsIgnoreCase(language)) break block11;
                System.err.println("Error reading translation file: cardnames-" + language + ".txt");
            }
        }
    }

    public static String getTranslatedName(String name) {
        if (CardTranslation.needsTranslation()) {
            if (name.contains(" // ")) {
                int splitIndex = name.indexOf(" // ");
                String leftname = name.substring(0, splitIndex);
                String rightname = name.substring(splitIndex + 4);
                return translatednames.getOrDefault(leftname, leftname) + " // " + translatednames.getOrDefault(rightname, rightname);
            }
            try {
                if (name.endsWith(" Token")) {
                    return CardTranslation.translateTokenName(name);
                }
                if (name.startsWith("Emblem \u2014 ") || name.contains("'s Effect") || name.contains("'s Boon")) {
                    return CardTranslation.translateEffectNames(name);
                }
                if (knownEffectNames.contains(name)) {
                    return CardTranslation.translateKnownEffectNames(name);
                }
                String tname = translatednames.get(name);
                return tname == null || tname.isEmpty() ? name : tname;
            }
            catch (Exception e) {
                return name;
            }
        }
        return name;
    }

    public static String getTranslatedName(ITranslatable card) {
        return CardTranslation.getTranslatedName(card.getUntranslatedName());
    }

    private static String translateTokenName(String name) {
        String ttype;
        if (translatedTokenNames == null) {
            translatedTokenNames = new HashMap<String, String>();
        }
        if ((ttype = translatedTokenNames.get(name)) == null) {
            String sub = name.replace(" Token", "");
            ttype = Localizer.getInstance().getMessageorUseDefault("lbl" + sub, "", new Object[0]);
            ttype = ttype == null || ttype.isEmpty() ? name : ttype + " " + Localizer.getInstance().getMessage("lblToken", new Object[0]);
            translatedTokenNames.put(name, ttype);
            return ttype;
        }
        return ttype;
    }

    private static String translateKnownEffectNames(String name) {
        String fname;
        if (translatedEffectNames == null) {
            translatedEffectNames = new HashMap<String, String>();
        }
        if ((fname = translatedEffectNames.get(name)) == null) {
            switch (name) {
                case "The Ring": {
                    fname = Localizer.getInstance().getMessage("lblTheRing", new Object[0]);
                    translatedEffectNames.put(name, fname);
                    return fname;
                }
                case "The Monarch": {
                    fname = Localizer.getInstance().getMessage("lblTheMonarch", new Object[0]);
                    translatedEffectNames.put(name, fname);
                    return fname;
                }
                case "The Initiative": {
                    fname = Localizer.getInstance().getMessage("lblTheInitiative", new Object[0]);
                    translatedEffectNames.put(name, fname);
                    return fname;
                }
                case "City's Blessing": {
                    fname = Localizer.getInstance().getMessage("lblCityBlessing", new Object[0]);
                    translatedEffectNames.put(name, fname);
                    return fname;
                }
                case "Keyword Effects": {
                    fname = Localizer.getInstance().getMessage("lblKeywordEffects", new Object[0]);
                    translatedEffectNames.put(name, fname);
                    return fname;
                }
            }
            return name;
        }
        return fname;
    }

    private static String translateEffectNames(String name) {
        String fname;
        if (translatedEffectNames == null) {
            translatedEffectNames = new HashMap<String, String>();
        }
        if ((fname = translatedEffectNames.get(name)) == null) {
            String finalname = name.replaceAll("\\([^()]*\\)", "");
            if (finalname.contains(" 's Effect")) {
                fname = translatednames.get(finalname = finalname.replace(" 's Effect", ""));
                fname = fname == null || fname.isEmpty() ? finalname : fname + " " + Localizer.getInstance().getMessage("lblEffect", new Object[0]);
                translatedEffectNames.put(name, fname);
                return fname;
            }
            if (finalname.contains("'s Effect")) {
                fname = translatednames.get(finalname = finalname.replace("'s Effect", ""));
                fname = fname == null || fname.isEmpty() ? finalname : fname + " " + Localizer.getInstance().getMessage("lblEffect", new Object[0]);
                translatedEffectNames.put(name, fname);
                return fname;
            }
            if (finalname.contains(" 's Boon")) {
                fname = translatednames.get(finalname = finalname.replace(" 's Boon", ""));
                fname = fname == null || fname.isEmpty() ? finalname : fname + " " + Localizer.getInstance().getMessage("lblBoon", new Object[0]);
                translatedEffectNames.put(name, fname);
                return fname;
            }
            if (finalname.contains("'s Boon")) {
                fname = translatednames.get(finalname = finalname.replace("'s Boon", ""));
                fname = fname == null || fname.isEmpty() ? finalname : fname + " " + Localizer.getInstance().getMessage("lblBoon", new Object[0]);
                translatedEffectNames.put(name, fname);
                return fname;
            }
            if (finalname.startsWith("Emblem \u2014 ")) {
                String[] s2 = finalname.split(" \u2014 ");
                try {
                    fname = translatednames.get(s2[1].endsWith(" ") ? s2[1].substring(0, s2[1].lastIndexOf(" ")) : s2[1]);
                    fname = fname == null || fname.isEmpty() ? finalname : fname + " " + Localizer.getInstance().getMessage("lblEmblem", new Object[0]);
                    translatedEffectNames.put(name, fname);
                    return fname;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return name;
        }
        return fname;
    }

    public static String getTranslatedType(String name, String originaltype) {
        if (CardTranslation.needsTranslation()) {
            String ttype = translatedtypes.get(name);
            return ttype == null ? originaltype : ttype;
        }
        return originaltype;
    }

    public static String getTranslatedType(ITranslatable item) {
        if (!CardTranslation.needsTranslation()) {
            return item.getUntranslatedType();
        }
        return translatedtypes.getOrDefault(item.getTranslationKey(), item.getUntranslatedType());
    }

    public static String getTranslatedOracle(String name) {
        if (CardTranslation.needsTranslation()) {
            String toracle = translatedoracles.get(name);
            return toracle == null ? "" : toracle;
        }
        return "";
    }

    public static String getTranslatedOracle(ITranslatable card) {
        if (!CardTranslation.needsTranslation()) {
            return "";
        }
        return translatedoracles.getOrDefault(card.getTranslationKey(), "");
    }

    public static HashMap<String, String> getTranslationTexts(ITranslatable card) {
        return CardTranslation.getTranslationTexts(card, null);
    }

    public static HashMap<String, String> getTranslationTexts(ITranslatable cardMain, ITranslatable cardOther) {
        if (!CardTranslation.needsTranslation()) {
            return null;
        }
        HashMap<String, String> translations = new HashMap<String, String>();
        translations.put("name", CardTranslation.getTranslatedName(cardMain));
        translations.put("oracle", CardTranslation.getTranslatedOracle(cardMain));
        if (cardOther == null) {
            translations.put("altname", "");
            translations.put("altoracle", "");
        } else {
            translations.put("altname", CardTranslation.getTranslatedName(cardOther));
            translations.put("altoracle", CardTranslation.getTranslatedOracle(cardOther));
        }
        return translations;
    }

    private static boolean needsTranslation() {
        return !languageSelected.equals("en-US");
    }

    public static void preloadTranslation(String language, String languagesDirectory) {
        languageSelected = language;
        if (CardTranslation.needsTranslation()) {
            translatednames = new HashMap<String, String>();
            translatedtypes = new HashMap<String, String>();
            translatedoracles = new HashMap<String, String>();
            oracleMappings = new HashMap<String, List<Pair<String, String>>>();
            translatedCaches = new HashMap<String, String>();
            CardTranslation.readTranslationFile(languageSelected, languagesDirectory);
        }
    }

    private static String replaceCardName(String language, String name, String toracle) {
        String nickName = language.equals("en-US") ? Lang.getEnglishInstance().getNickName(name) : Lang.getInstance().getNickName(name);
        String result = TextUtil.fastReplace(toracle, name, "CARDNAME");
        if (!nickName.equals(name)) {
            result = TextUtil.fastReplace(result, nickName, "NICKNAME");
        }
        return result;
    }

    public static void buildOracleMapping(String faceName, String oracleText, String variantName) {
        String translationKey = faceName;
        if (variantName != null) {
            translationKey = faceName + " $" + variantName;
        }
        if (!CardTranslation.needsTranslation() || oracleMappings.containsKey(translationKey)) {
            return;
        }
        String translatedText = CardTranslation.getTranslatedOracle(translationKey);
        if (translatedText.isEmpty()) {
            return;
        }
        String translatedName = CardTranslation.getTranslatedName(translationKey);
        ArrayList<Pair<String, String>> mapping = new ArrayList<Pair<String, String>>();
        String[] splitOracleText = oracleText.split("\\\\n");
        String[] splitTranslatedText = translatedText.split("\r\n\r\n");
        for (int i = 0; i < splitOracleText.length && i < splitTranslatedText.length; ++i) {
            String toracle = CardTranslation.replaceCardName("en-US", faceName, splitOracleText[i]);
            String ttranslated = CardTranslation.replaceCardName(languageSelected, translatedName, splitTranslatedText[i]);
            if (!toracle.startsWith("(")) {
                toracle = toracle.replaceAll("\\(.*\\)", "");
            }
            mapping.add(Pair.of(toracle, ttranslated));
        }
        oracleMappings.put(translationKey, mapping);
    }

    public static String translateMultipleDescriptionText(String descText, ITranslatable card) {
        if (!CardTranslation.needsTranslation()) {
            return descText;
        }
        String[] splitDescText = descText.split("\n");
        String result = descText;
        for (String text : splitDescText) {
            if ((text = text.trim()).isEmpty()) continue;
            String translated = CardTranslation.translateSingleDescriptionText(text, card);
            if (!text.equals(translated)) {
                result = TextUtil.fastReplace(result, text, translated);
                continue;
            }
            String[] splitKeywords = text.split(", ");
            if (splitKeywords.length <= 1) continue;
            for (String keyword : splitKeywords) {
                if (keyword.contains(" ") || keyword.equals(translated = CardTranslation.translateSingleDescriptionText(keyword, card))) continue;
                result = TextUtil.fastReplace(result, keyword, translated);
            }
        }
        return result;
    }

    public static String translateSingleDescriptionText(String descText, ITranslatable card) {
        if (descText == null) {
            return "";
        }
        if (!CardTranslation.needsTranslation()) {
            return descText;
        }
        if (translatedCaches.containsKey(descText)) {
            return translatedCaches.get(descText);
        }
        List<Pair<String, String>> mapping = oracleMappings.get(card.getTranslationKey());
        if (mapping == null) {
            return descText;
        }
        String result = descText;
        if (!mapping.isEmpty()) {
            result = CardTranslation.translateSingleIngameText(descText, mapping);
        }
        translatedCaches.put(descText, result);
        return result;
    }

    private static String translateSingleIngameText(String descText, List<Pair<String, String>> mapping) {
        String tcompare = descText.startsWith("(") ? descText : descText.replaceAll("\\(.*\\)", "");
        int candidateIndex = mapping.size();
        int minDistance = tcompare.length();
        for (int i = 0; i < mapping.size(); ++i) {
            int threshold;
            String toracle = mapping.get(i).getLeft();
            int distance = StringUtils.getLevenshteinDistance(toracle, tcompare, threshold = Math.min(toracle.length(), tcompare.length()) / 3);
            if (distance == -1 || distance >= minDistance) continue;
            minDistance = distance;
            candidateIndex = i;
        }
        if (candidateIndex < mapping.size()) {
            return mapping.get(candidateIndex).getRight();
        }
        return descText;
    }

    static {
        knownEffectNames = Arrays.asList("The Ring", "The Monarch", "The Initiative", "City's Blessing", "Keyword Effects");
        languageSelected = "en-US";
    }
}

