/*
 * Decompiled with CFR 0.152.
 */
package forge.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.GdxRuntimeException;
import java.nio.Buffer;
import java.nio.ByteBuffer;

public class BlurUtils {
    public static void blurPass(int[] srcPixels, int[] dstPixels, int width, int height, int radius) {
        int i;
        int windowSize = radius * 2 + 1;
        int radiusPlusOne = radius + 1;
        int srcIndex = 0;
        int[] sumLookupTable = new int[256 * windowSize];
        for (int i2 = 0; i2 < sumLookupTable.length; ++i2) {
            sumLookupTable[i2] = i2 / windowSize;
        }
        int[] indexLookupTable = new int[radiusPlusOne];
        if (radius < width) {
            for (i = 0; i < indexLookupTable.length; ++i) {
                indexLookupTable[i] = i;
            }
        } else {
            for (i = 0; i < width; ++i) {
                indexLookupTable[i] = i;
            }
            for (i = width; i < indexLookupTable.length; ++i) {
                indexLookupTable[i] = width - 1;
            }
        }
        for (int y = 0; y < height; ++y) {
            int sumBlue = 0;
            int sumGreen = 0;
            int sumRed = 0;
            int sumAlpha = 0;
            int dstIndex = y;
            int pixel = srcPixels[srcIndex];
            sumRed += radiusPlusOne * (pixel >> 24 & 0xFF);
            sumGreen += radiusPlusOne * (pixel >> 16 & 0xFF);
            sumBlue += radiusPlusOne * (pixel >> 8 & 0xFF);
            sumAlpha += radiusPlusOne * (pixel & 0xFF);
            for (int i3 = 1; i3 <= radius; ++i3) {
                pixel = srcPixels[srcIndex + indexLookupTable[i3]];
                sumRed += pixel >> 24 & 0xFF;
                sumGreen += pixel >> 16 & 0xFF;
                sumBlue += pixel >> 8 & 0xFF;
                sumAlpha += pixel & 0xFF;
            }
            for (int x = 0; x < width; ++x) {
                int previousPixelIndex;
                dstPixels[dstIndex] = sumLookupTable[sumRed] << 24 | sumLookupTable[sumGreen] << 16 | sumLookupTable[sumBlue] << 8 | sumLookupTable[sumAlpha];
                dstIndex += height;
                int nextPixelIndex = x + radiusPlusOne;
                if (nextPixelIndex >= width) {
                    nextPixelIndex = width - 1;
                }
                if ((previousPixelIndex = x - radius) < 0) {
                    previousPixelIndex = 0;
                }
                int nextPixel = srcPixels[srcIndex + nextPixelIndex];
                int previousPixel = srcPixels[srcIndex + previousPixelIndex];
                sumRed += nextPixel >> 24 & 0xFF;
                sumRed -= previousPixel >> 24 & 0xFF;
                sumGreen += nextPixel >> 16 & 0xFF;
                sumGreen -= previousPixel >> 16 & 0xFF;
                sumBlue += nextPixel >> 8 & 0xFF;
                sumBlue -= previousPixel >> 8 & 0xFF;
                sumAlpha += nextPixel & 0xFF;
                sumAlpha -= previousPixel & 0xFF;
            }
            srcIndex += width;
        }
    }

    public static int[] blur(int[] inputRGBA, int width, int height, int radius, int iterations) {
        int[] srcPixels = new int[width * height];
        int[] dstPixels = new int[width * height];
        System.arraycopy(inputRGBA, 0, srcPixels, 0, srcPixels.length);
        for (int i = 0; i < iterations; ++i) {
            BlurUtils.blurPass(srcPixels, dstPixels, width, height, radius);
            BlurUtils.blurPass(dstPixels, srcPixels, height, width, radius);
        }
        return srcPixels;
    }

    public static ByteBuffer blur(ByteBuffer inputRGBA, int width, int height, int radius, int iterations) {
        if (inputRGBA.limit() != width * height * 4) {
            throw new IllegalArgumentException("inputRGBA must be in RGBA format");
        }
        int[] pixels = BlurUtils.pack(inputRGBA);
        int[] out = BlurUtils.blur(pixels, width, height, radius, iterations);
        return BlurUtils.unpack(out);
    }

    public static int[] pack(ByteBuffer rgba) {
        int[] pixels = new int[rgba.limit() / 4];
        for (int i = 0; i < pixels.length; ++i) {
            int r = rgba.get() & 0xFF;
            int g2 = rgba.get() & 0xFF;
            int b = rgba.get() & 0xFF;
            int a = rgba.get() & 0xFF;
            pixels[i] = r << 24 | g2 << 16 | b << 8 | a;
        }
        return pixels;
    }

    public static ByteBuffer unpack(int[] pixels) {
        ByteBuffer buf = BufferUtils.newByteBuffer(pixels.length * 4);
        for (int value : pixels) {
            buf.put((byte)((value & 0xFF000000) >>> 24)).put((byte)((value & 0xFF0000) >>> 16)).put((byte)((value & 0xFF00) >>> 8)).put((byte)(value & 0xFF));
        }
        BlurUtils.upcast(buf).flip();
        return buf;
    }

    public static Pixmap blur(Pixmap pixmap, int radius, int iterations, boolean disposePixmap) {
        return BlurUtils.blur(pixmap, 0, 0, pixmap.getWidth(), pixmap.getHeight(), 0, 0, pixmap.getWidth(), pixmap.getHeight(), radius, iterations, disposePixmap);
    }

    public static Pixmap blur(Pixmap pixmap, int radius, int iterations, boolean disposePixmap, int div) {
        int x = (int)((float)pixmap.getWidth() * 0.35f);
        int y = (int)((float)pixmap.getHeight() * 0.35f);
        int width = pixmap.getWidth() - x;
        int height = pixmap.getHeight() - y;
        return BlurUtils.blur(pixmap, x / 2, y / 2, width, height, 0, 0, width / div, height / div, radius, iterations, disposePixmap);
    }

    public static Pixmap blur(Pixmap pixmap, int srcx, int srcy, int srcwidth, int srcheight, int dstx, int dsty, int dstwidth, int dstheight, int radius, int iterations, boolean disposePixmap) {
        boolean dstEq;
        boolean srcEq = srcx == 0 && srcy == 0 && srcwidth == pixmap.getWidth() && srcheight == pixmap.getHeight();
        boolean bl = dstEq = dstx == 0 && dsty == 0 && dstwidth == pixmap.getWidth() && dstheight == pixmap.getHeight();
        if (pixmap.getFormat() != Pixmap.Format.RGBA8888 || !srcEq || !dstEq) {
            Pixmap tmp = new Pixmap(dstwidth, dstheight, Pixmap.Format.RGBA8888);
            tmp.drawPixmap(pixmap, srcx, srcy, srcwidth, srcheight, dstx, dsty, dstwidth, dstheight);
            if (disposePixmap) {
                pixmap.dispose();
                disposePixmap = false;
            }
            pixmap = tmp;
        }
        ByteBuffer blurred = BlurUtils.blur(pixmap.getPixels(), dstwidth, dstheight, radius, iterations);
        Pixmap newPixmap = new Pixmap(dstwidth, dstheight, Pixmap.Format.RGBA8888);
        ByteBuffer newRGBA = newPixmap.getPixels();
        BlurUtils.upcast(newRGBA).clear();
        newRGBA.put(blurred);
        BlurUtils.upcast(newRGBA).flip();
        if (disposePixmap) {
            pixmap.dispose();
        }
        return newPixmap;
    }

    public static void generateBlurredMipmaps(Pixmap pixmap, int textureWidth, int textureHeight, int radius, int iterations, boolean disposePixmap) {
        if (textureWidth != textureHeight) {
            throw new GdxRuntimeException("texture width and height must be square when using mipmapping.");
        }
        Pixmap origPixmap = pixmap;
        int width = pixmap.getWidth() / 2;
        int height = pixmap.getHeight() / 2;
        int level = 1;
        while (width > 0 && height > 0) {
            pixmap = BlurUtils.blur(origPixmap, 0, 0, origPixmap.getWidth(), origPixmap.getHeight(), 0, 0, width, height, radius, iterations, false);
            Gdx.gl.glTexImage2D(3553, level, pixmap.getGLInternalFormat(), pixmap.getWidth(), pixmap.getHeight(), 0, pixmap.getGLFormat(), pixmap.getGLType(), pixmap.getPixels());
            width = pixmap.getWidth() / 2;
            height = pixmap.getHeight() / 2;
            ++level;
            pixmap.dispose();
        }
        if (disposePixmap) {
            origPixmap.dispose();
        }
    }

    public static Buffer upcast(Buffer buf) {
        return buf;
    }
}

