/*
 * Decompiled with CFR 0.152.
 */
package forge.trackable;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Table;
import forge.trackable.TrackableObject;
import forge.trackable.TrackableProperty;
import forge.trackable.TrackableTypes;
import java.util.List;

public class Tracker {
    private int freezeCounter = 0;
    private final List<DelayedPropChange> delayedPropChanges = Lists.newArrayList();
    private final Table<TrackableTypes.TrackableType<?>, Integer, Object> objLookups = HashBasedTable.create();

    public final boolean isFrozen() {
        return this.freezeCounter > 0;
    }

    public void freeze() {
        ++this.freezeCounter;
    }

    public <T> T getObj(TrackableTypes.TrackableType<T> type, Integer id) {
        return (T)this.objLookups.get(type, id);
    }

    public boolean hasObj(TrackableTypes.TrackableType<?> type, Integer id) {
        return this.objLookups.contains(type, id);
    }

    public <T> void putObj(TrackableTypes.TrackableType<T> type, Integer id, T val) {
        this.objLookups.put(type, id, val);
    }

    public void unfreeze() {
        if (!this.isFrozen() || --this.freezeCounter > 0 || this.delayedPropChanges.isEmpty()) {
            return;
        }
        for (DelayedPropChange change : this.delayedPropChanges) {
            change.object.set(change.prop, change.value);
        }
        this.delayedPropChanges.clear();
    }

    public void flush() {
        if (!this.isFrozen()) {
            return;
        }
        this.unfreeze();
        this.freeze();
    }

    public void addDelayedPropChange(TrackableObject object, TrackableProperty prop, Object value) {
        this.delayedPropChanges.add(new DelayedPropChange(object, prop, value));
    }

    public void clearDelayed() {
        this.delayedPropChanges.clear();
    }

    private class DelayedPropChange {
        private final TrackableObject object;
        private final TrackableProperty prop;
        private final Object value;

        private DelayedPropChange(TrackableObject object0, TrackableProperty prop0, Object value0) {
            this.object = object0;
            this.prop = prop0;
            this.value = value0;
        }

        public String toString() {
            return "Set " + (Object)((Object)this.prop) + " of " + this.object + " to " + this.value;
        }
    }
}

