/*
 * Decompiled with CFR 0.152.
 */
package forge.trackable;

import forge.game.IIdentifiable;
import forge.trackable.TrackableDeserializer;
import forge.trackable.TrackableProperty;
import forge.trackable.TrackableSerializer;
import forge.trackable.Tracker;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;

public abstract class TrackableObject
implements IIdentifiable,
Serializable {
    private static final long serialVersionUID = 7386836745378571056L;
    private final int id;
    protected transient Tracker tracker;
    private final Map<TrackableProperty, Object> props;
    private final Set<TrackableProperty> changedProps;
    private boolean copyingProps;

    protected TrackableObject(int id0, Tracker tracker) {
        this.id = id0;
        this.tracker = tracker;
        this.props = new EnumMap<TrackableProperty, Object>(TrackableProperty.class);
        this.changedProps = EnumSet.noneOf(TrackableProperty.class);
    }

    @Override
    public final int getId() {
        return this.id;
    }

    public void setTracker(Tracker tracker) {
        this.tracker = tracker;
    }

    public final Tracker getTracker() {
        return this.tracker;
    }

    public int hashCode() {
        return this.id;
    }

    public final boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return o.hashCode() == this.hashCode() && o.getClass().equals(this.getClass());
    }

    public <T> T getProps() {
        return (T)this.props;
    }

    protected final <T> T get(TrackableProperty key) {
        Object value = this.props.get((Object)key);
        if (value == null) {
            value = key.getDefaultValue();
        }
        return (T)value;
    }

    protected final <T> void set(TrackableProperty key, T value) {
        if (this.tracker != null && this.tracker.isFrozen()) {
            boolean respectsFreeze = false;
            if (key.getFreezeMode() == TrackableProperty.FreezeMode.RespectsFreeze) {
                respectsFreeze = true;
            } else if (key.getFreezeMode() == TrackableProperty.FreezeMode.IgnoresFreezeIfUnset) {
                boolean bl = respectsFreeze = this.props.get((Object)key) != null;
            }
            if (respectsFreeze) {
                this.tracker.addDelayedPropChange(this, key, value);
                return;
            }
        }
        if (value == null || value.equals(key.getDefaultValue())) {
            if (this.props.remove((Object)key) != null) {
                this.changedProps.add(key);
                key.updateObjLookup(this.tracker, value);
            }
        } else if (!value.equals(this.props.put(key, value))) {
            this.changedProps.add(key);
            key.updateObjLookup(this.tracker, value);
        }
    }

    public final void updateObjLookup() {
        for (Map.Entry<TrackableProperty, Object> prop : this.props.entrySet()) {
            prop.getKey().updateObjLookup(this.tracker, prop.getValue());
        }
    }

    public final void copyChangedProps(TrackableObject from) {
        if (this.copyingProps) {
            return;
        }
        this.copyingProps = true;
        for (TrackableProperty prop : from.changedProps) {
            prop.copyChangedProps(from, this);
        }
        this.copyingProps = false;
    }

    protected final void flagAsChanged(TrackableProperty key) {
        this.changedProps.add(key);
        key.updateObjLookup(this.tracker, this.props.get((Object)key));
    }

    public final void serialize(TrackableSerializer ts) {
        ts.write(this.changedProps.size());
        for (TrackableProperty key : this.changedProps) {
            ts.write(TrackableProperty.serialize(key));
            key.serialize(ts, this.props.get((Object)key));
        }
        this.changedProps.clear();
    }

    public final void deserialize(TrackableDeserializer td) {
        int count = td.readInt();
        for (int i = 0; i < count; ++i) {
            TrackableProperty key = TrackableProperty.deserialize(td.readInt());
            this.set(key, key.deserialize(td, this.props.get((Object)key)));
        }
        this.changedProps.clear();
    }
}

