/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.gui.FThreads;
import forge.item.InventoryItem;
import forge.itemmanager.filters.AdvancedSearchFilter;
import forge.itemmanager.filters.ItemFilter;
import forge.itemmanager.filters.ListLabelFilter;
import forge.menu.FMenuItem;
import forge.menu.FPopupMenu;
import forge.toolbox.FChoiceList;
import forge.toolbox.FContainer;
import forge.toolbox.FLabel;
import forge.toolbox.FOptionPane;
import forge.toolbox.FTextField;
import forge.util.Callback;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ListChooser<T>
extends FContainer {
    private boolean called;
    private FTextField txtSearch;
    private FLabel btnSearch;
    private ChoiceList lstChoices;
    private FOptionPane optionPane;
    private final Collection<T> list;
    private final Function<T, String> display;
    private final Callback<List<T>> callback;
    private AdvancedSearchFilter<? extends InventoryItem> advancedSearchFilter;

    public ListChooser(String title, final int minChoices, int maxChoices, Collection<T> list0, Function<T, String> display0, Callback<List<T>> callback0) {
        FThreads.assertExecutedByEdt(true);
        this.list = list0;
        this.lstChoices = this.add(new ChoiceList(this.list, minChoices, maxChoices));
        this.display = display0;
        this.callback = callback0;
        if (this.list.size() > 25 && !this.lstChoices.getListItemRenderer().layoutHorizontal()) {
            this.txtSearch = this.add(new FTextField());
            this.txtSearch.setFont(FSkinFont.get(12));
            this.txtSearch.setGhostText(Forge.getLocalizer().getMessage("lblSearch", new Object[0]));
            this.txtSearch.setChangedHandler(e -> this.applyFilters());
            this.advancedSearchFilter = this.lstChoices.getListItemRenderer().getAdvancedSearchFilter(this);
            if (this.advancedSearchFilter != null) {
                this.btnSearch = this.add(new FLabel.ButtonBuilder().icon(Forge.hdbuttons ? FSkinImage.HDSEARCH : FSkinImage.SEARCH).iconScaleFactor(0.9f).command(e -> {
                    FPopupMenu menu = new FPopupMenu(){

                        @Override
                        protected void buildMenu() {
                            this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblAdvancedSearch", new Object[0]), Forge.hdbuttons ? FSkinImage.HDSEARCH : FSkinImage.SEARCH, e1 -> ListChooser.this.advancedSearchFilter.edit()));
                            this.addItem(new FMenuItem(Forge.getLocalizer().getMessage("lblResetFilters", new Object[0]), Forge.hdbuttons ? FSkinImage.HDDELETE : FSkinImage.DELETE, e2 -> ListChooser.this.resetFilters()));
                        }
                    };
                    menu.show(this.btnSearch, 0.0f, this.btnSearch.getHeight());
                }).build());
                this.add(this.advancedSearchFilter.getWidget());
            }
        }
        ImmutableList<String> options = minChoices == 0 ? ImmutableList.of(Forge.getLocalizer().getMessage("lblOK", new Object[0]), Forge.getLocalizer().getMessage("lblCancel", new Object[0])) : ImmutableList.of(Forge.getLocalizer().getMessage("lblOK", new Object[0]));
        this.updateHeight();
        this.optionPane = new FOptionPane(null, null, title, null, this, options, 0, new Callback<Integer>(){

            @Override
            public void run(Integer result) {
                ListChooser.this.called = false;
                if (result == 0) {
                    ListChooser.this.callback.run(ListChooser.this.lstChoices.getSelectedItems());
                } else if (minChoices > 0) {
                    ListChooser.this.show();
                } else {
                    ListChooser.this.callback.run(new ArrayList());
                }
            }
        }){

            @Override
            protected boolean padAboveAndBelow() {
                return false;
            }
        };
    }

    public void resetFilters() {
        this.txtSearch.setText("");
        if (this.advancedSearchFilter != null) {
            this.advancedSearchFilter.reset();
            ItemFilter.Widget widget = this.advancedSearchFilter.getWidget();
            if (widget.isVisible()) {
                widget.setVisible(false);
                this.revalidate();
            }
        }
        this.applyFilters();
    }

    public void applyFilters() {
        this.lstChoices.clearSelection();
        ArrayList<Predicate<? extends InventoryItem>> predicates = new ArrayList<Predicate<? extends InventoryItem>>();
        String pattern = this.txtSearch.getText().toLowerCase();
        if (!pattern.isEmpty()) {
            predicates.add(input -> this.lstChoices.getChoiceText(input).toLowerCase().contains(pattern));
        }
        if (this.advancedSearchFilter != null && !this.advancedSearchFilter.isEmpty()) {
            predicates.add(this.advancedSearchFilter.getPredicate());
        }
        if (predicates.isEmpty()) {
            this.lstChoices.setListData(this.list);
        } else {
            this.lstChoices.setListData(Iterables.filter(this.list, Predicates.and(predicates)));
        }
        if (!this.lstChoices.isEmpty() && this.lstChoices.getMaxChoices() > 0) {
            this.lstChoices.addSelectedIndex(0);
        }
        this.lstChoices.setScrollTop(0.0f);
    }

    private void updateHeight() {
        boolean needRevalidate;
        boolean bl = needRevalidate = this.getHeight() > 0.0f;
        if (this.lstChoices.getListItemRenderer().layoutHorizontal()) {
            this.setHeight(Utils.AVG_FINGER_HEIGHT);
        } else {
            this.setHeight(Math.min(this.lstChoices.getListItemRenderer().getItemHeight() * (float)this.list.size(), FOptionPane.getMaxDisplayObjHeight()));
        }
        if (needRevalidate) {
            this.optionPane.revalidate();
        }
    }

    public void show() {
        this.show(null, false);
    }

    public void show(T item, boolean selectMax) {
        if (this.called) {
            throw new IllegalStateException("Already shown");
        }
        this.called = true;
        if (item == null) {
            if (selectMax) {
                this.lstChoices.clearSelection();
                int max = Math.min(this.lstChoices.getMaxChoices(), this.list.size());
                for (int i = 0; i < max; ++i) {
                    this.lstChoices.addSelectedIndex(i);
                }
            } else if (this.lstChoices.getMaxChoices() == 1) {
                this.lstChoices.setSelectedIndex(0);
            } else {
                this.lstChoices.clearSelection();
            }
        } else {
            this.lstChoices.setSelectedItem(item);
        }
        this.optionPane.show();
    }

    @Override
    protected void doLayout(float width, float height) {
        float y = 0.0f;
        if (this.txtSearch != null) {
            float fieldWidth = width;
            float fieldHeight = this.txtSearch.getHeight();
            float padding = fieldHeight * 0.25f;
            y += padding;
            if (this.btnSearch != null) {
                float buttonWidth = fieldHeight;
                this.btnSearch.setBounds(width - buttonWidth, y, buttonWidth, fieldHeight);
                fieldWidth -= buttonWidth + ItemFilter.PADDING;
            }
            this.txtSearch.setBounds(0.0f, y, fieldWidth, fieldHeight);
            if (this.advancedSearchFilter != null && this.advancedSearchFilter.getWidget().isVisible()) {
                padding = ItemFilter.PADDING;
                y += fieldHeight + padding;
                fieldHeight = FTextField.getDefaultHeight(ListLabelFilter.LABEL_FONT);
                this.advancedSearchFilter.getWidget().setBounds(0.0f, y, width, fieldHeight);
            }
            y += fieldHeight + padding;
        }
        this.lstChoices.setBounds(0.0f, y, width, height - y);
    }

    @Override
    public boolean keyDown(int keyCode) {
        if (Forge.hasGamepad()) {
            if (keyCode == 20) {
                this.setNextSelected();
            } else if (keyCode == 19) {
                this.setPreviousSelected();
            }
            return true;
        }
        return super.keyDown(keyCode);
    }

    public void setNextSelected() {
        if (this.lstChoices.getSelectedIndex() + 1 < this.lstChoices.getCount()) {
            this.lstChoices.setSelectedIndex(this.lstChoices.getSelectedIndex() + 1);
        }
    }

    public void setPreviousSelected() {
        if (this.lstChoices.getSelectedIndex() - 1 > -1) {
            this.lstChoices.setSelectedIndex(this.lstChoices.getSelectedIndex() - 1);
        }
    }

    private class ChoiceList
    extends FChoiceList<T> {
        private ChoiceList(Collection<T> items, int minChoices0, int maxChoices0) {
            super(items, minChoices0, maxChoices0);
        }

        @Override
        protected String getChoiceText(T choice) {
            if (ListChooser.this.display == null) {
                return choice.toString();
            }
            return (String)ListChooser.this.display.apply(choice);
        }

        @Override
        protected void onSelectionChange() {
            int num = this.getSelectionCount();
            ListChooser.this.optionPane.setButtonEnabled(0, num >= this.minChoices && (num <= this.maxChoices || this.maxChoices == -1));
        }

        @Override
        protected void onItemActivate(Integer index, T value) {
            if (ListChooser.this.optionPane.isButtonEnabled(0)) {
                ListChooser.this.optionPane.setResult(0);
            }
        }

        @Override
        protected void onCompactModeChange() {
            ListChooser.this.updateHeight();
        }

        @Override
        public void drawOverlay(Graphics g2) {
        }
    }
}

