/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.google.common.collect.ImmutableList;
import forge.game.card.CardView;
import forge.toolbox.FOptionPane;
import forge.util.Callback;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GuiDialog {
    private static final ImmutableList<String> defaultConfirmOptions = ImmutableList.of("Yes", "No");

    public static void confirm(CardView c, String question, Callback<Boolean> callback) {
        GuiDialog.confirm(c, question, true, null, callback);
    }

    public static void confirm(CardView c, String question, boolean defaultChoice, Callback<Boolean> callback) {
        GuiDialog.confirm(c, question, defaultChoice, null, callback);
    }

    public static void confirm(CardView c, String question, List<String> options, Callback<Boolean> callback) {
        GuiDialog.confirm(c, question, true, options, callback);
    }

    public static void confirm(CardView c, String question, boolean defaultIsYes, List<String> options, final Callback<Boolean> callback) {
        String title = c == null ? "Question" : c + " - Ability";
        String questionToUse = StringUtils.isBlank(question) ? "Activate card's ability?" : question;
        List<String> opts = options == null ? defaultConfirmOptions : options;
        FOptionPane.showCardOptionDialog(c, questionToUse, title, FOptionPane.QUESTION_ICON, opts, defaultIsYes ? 0 : 1, new Callback<Integer>(){

            @Override
            public void run(Integer result) {
                callback.run(result == 0);
            }
        });
    }

    public static void message(String message) {
        GuiDialog.message(message, "Forge");
    }

    public static void message(String message, String title) {
        FOptionPane.showMessageDialog(message, title, null);
    }
}

