/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import forge.Forge;
import forge.game.card.CardView;
import forge.toolbox.DualListBox;
import forge.toolbox.FOptionPane;
import forge.toolbox.ListChooser;
import forge.util.Callback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class GuiChoose {
    public static <T> void oneOrNone(String message, T[] choices, final Callback<T> callback) {
        if (choices == null || choices.length == 0) {
            callback.run(null);
            return;
        }
        GuiChoose.getChoices(message, 0, 1, choices, new Callback<List<T>>(){

            @Override
            public void run(List<T> result) {
                callback.run(result.isEmpty() ? null : (Object)result.get(0));
            }
        });
    }

    public static <T> void oneOrNone(String message, Collection<T> choices, final Callback<T> callback) {
        if (choices == null || choices.isEmpty()) {
            callback.run(null);
            return;
        }
        GuiChoose.getChoices(message, 0, 1, choices, new Callback<List<T>>(){

            @Override
            public void run(List<T> result) {
                callback.run(result.isEmpty() ? null : (Object)result.get(0));
            }
        });
    }

    public static <T> void one(String message, T[] choices, final Callback<T> callback) {
        if (choices == null || choices.length == 0) {
            callback.run(null);
            return;
        }
        if (choices.length == 1) {
            callback.run(choices[0]);
            return;
        }
        GuiChoose.getChoices(message, 1, 1, choices, new Callback<List<T>>(){

            @Override
            public void run(List<T> result) {
                assert (result.size() == 1);
                callback.run(result.get(0));
            }
        });
    }

    public static <T> void one(String message, Collection<T> choices, final Callback<T> callback) {
        if (choices == null || choices.isEmpty()) {
            callback.run(null);
            return;
        }
        if (choices.size() == 1) {
            callback.run(Iterables.getFirst(choices, null));
            return;
        }
        GuiChoose.getChoices(message, 1, 1, choices, new Callback<List<T>>(){

            @Override
            public void run(List<T> result) {
                assert (result.size() == 1);
                callback.run(result.get(0));
            }
        });
    }

    public static <T> void noneOrMany(String message, Collection<T> choices, Callback<List<T>> callback) {
        GuiChoose.getChoices(message, 0, choices.size(), choices, null, null, callback);
    }

    public static <T> void reveal(String message, T item) {
        ArrayList<T> items = new ArrayList<T>();
        items.add(item);
        GuiChoose.reveal(message, items);
    }

    public static <T> void reveal(String message, T[] items) {
        GuiChoose.getChoices(message, -1, -1, items, null);
    }

    public static <T> void reveal(String message, Collection<T> items) {
        GuiChoose.getChoices(message, -1, -1, items, null);
    }

    public static void getInteger(String message, Callback<Integer> callback) {
        GuiChoose.getInteger(message, 0, Integer.MAX_VALUE, callback);
    }

    public static void getInteger(String message, int min2, Callback<Integer> callback) {
        GuiChoose.getInteger(message, min2, Integer.MAX_VALUE, callback);
    }

    public static void getInteger(String message, int min2, int max, Callback<Integer> callback) {
        if (max <= min2) {
            callback.run(min2);
            return;
        }
        if (max == Integer.MAX_VALUE) {
            GuiChoose.getInteger(message, min2, max, min2 + 99, callback);
            return;
        }
        int count = max - min2 + 1;
        if (count > 100) {
            GuiChoose.getInteger(message, min2, max, min2 + 99, callback);
            return;
        }
        Integer[] choices = new Integer[count];
        for (int i = 0; i < count; ++i) {
            choices[i] = i + min2;
        }
        GuiChoose.oneOrNone(message, choices, callback);
    }

    public static void getInteger(final String message, final int min2, final int max, int cutoff, final Callback<Integer> callback) {
        if (max <= min2 || cutoff < min2) {
            callback.run(min2);
            return;
        }
        if (cutoff >= max) {
            GuiChoose.getInteger(message, min2, max, callback);
            return;
        }
        ArrayList<Object> choices = new ArrayList<Object>();
        for (int i = min2; i <= cutoff; ++i) {
            choices.add(i);
        }
        choices.add(Forge.getLocalizer().getMessage("lblOther", new Object[0]) + "...");
        GuiChoose.oneOrNone(message, choices, new Callback<Object>(){

            @Override
            public void run(Object choice) {
                if (choice instanceof Integer || choice == null) {
                    callback.run((Integer)choice);
                    return;
                }
                String prompt = "Enter a number";
                if (min2 != Integer.MIN_VALUE) {
                    prompt = max != Integer.MAX_VALUE ? prompt + " between " + min2 + " and " + max : prompt + " greater than or equal to " + min2;
                } else if (max != Integer.MAX_VALUE) {
                    prompt = prompt + " less than or equal to " + max;
                }
                prompt = prompt + ":";
                GuiChoose.getNumberInput(prompt, message, min2, max, callback);
            }
        });
    }

    private static void getNumberInput(final String prompt, final String message, final int min2, final int max, final Callback<Integer> callback) {
        FOptionPane.showInputDialog(prompt, message, new Callback<String>(){

            @Override
            public void run(String result) {
                int val;
                if (result == null) {
                    callback.run(null);
                    return;
                }
                if (StringUtils.isNumeric(result) && (val = Integer.parseInt(result)) >= min2 && val <= max) {
                    callback.run(val);
                    return;
                }
                GuiChoose.getNumberInput(prompt, message, min2, max, callback);
            }
        });
    }

    public static <T> void getChoices(String message, int min2, int max, T[] choices, Callback<List<T>> callback) {
        GuiChoose.getChoices(message, min2, max, Arrays.asList(choices), null, null, callback);
    }

    public static <T> void getChoices(String message, int min2, int max, Collection<T> choices, Callback<List<T>> callback) {
        GuiChoose.getChoices(message, min2, max, choices, null, null, callback);
    }

    public static <T> void getChoices(String message, int min2, int max, Collection<T> choices, T selected, Function<T, String> display, Callback<List<T>> callback) {
        if (choices == null || choices.isEmpty()) {
            if (min2 == 0) {
                callback.run(new ArrayList());
                return;
            }
            throw new RuntimeException("choice required from empty list");
        }
        ListChooser<T> c = new ListChooser<T>(message, min2, max, choices, display, callback);
        c.show(selected, false);
    }

    public static <T> void many(String title, String topCaption, int cnt, List<T> sourceChoices, CardView referenceCard, Callback<List<T>> callback) {
        GuiChoose.order(title, topCaption, cnt, cnt, sourceChoices, null, referenceCard, callback);
    }

    public static <T> void many(String title, String topCaption, int min2, int max, List<T> sourceChoices, CardView referenceCard, Callback<List<T>> callback) {
        int m1 = max >= 0 ? sourceChoices.size() - max : -1;
        int m22 = min2 >= 0 ? sourceChoices.size() - min2 : -1;
        GuiChoose.order(title, topCaption, m1, m22, sourceChoices, null, referenceCard, callback);
    }

    public static <T> void order(String title, String top, List<T> sourceChoices, CardView referenceCard, Callback<List<T>> callback) {
        GuiChoose.order(title, top, 0, 0, sourceChoices, null, referenceCard, callback);
    }

    public static <T> void order(String title, String top, int remainingObjectsMin, int remainingObjectsMax, List<T> sourceChoices, List<T> destChoices, CardView referenceCard, Callback<List<T>> callback) {
        DualListBox<T> dual = new DualListBox<T>(title, remainingObjectsMin, remainingObjectsMax, sourceChoices, destChoices, callback);
        dual.setSecondColumnLabelText(top);
        dual.show();
    }

    public static <T> void sortedOneOrNone(String message, T[] choices, Comparator<T> comparer, final Callback<T> callback) {
        if (choices == null || choices.length == 0) {
            callback.run(null);
            return;
        }
        GuiChoose.sortedGetChoices(message, 0, 1, choices, comparer, new Callback<List<T>>(){

            @Override
            public void run(List<T> result) {
                callback.run(result.isEmpty() ? null : (Object)result.get(0));
            }
        });
    }

    public static <T> void sortedOneOrNone(String message, List<T> choices, Comparator<T> comparer, final Callback<T> callback) {
        if (choices == null || choices.isEmpty()) {
            callback.run(null);
            return;
        }
        GuiChoose.sortedGetChoices(message, 0, 1, choices, comparer, new Callback<List<T>>(){

            @Override
            public void run(List<T> result) {
                callback.run(result.isEmpty() ? null : (Object)result.get(0));
            }
        });
    }

    public static <T> void sortedOne(String message, T[] choices, Comparator<T> comparer, final Callback<T> callback) {
        if (choices == null || choices.length == 0) {
            callback.run(null);
            return;
        }
        GuiChoose.sortedGetChoices(message, 1, 1, choices, comparer, new Callback<List<T>>(){

            @Override
            public void run(List<T> result) {
                assert (result.size() == 1);
                callback.run(result.get(0));
            }
        });
    }

    public static <T> void sortedOne(String message, List<T> choices, Comparator<T> comparer, final Callback<T> callback) {
        if (choices == null || choices.size() == 0) {
            callback.run(null);
            return;
        }
        GuiChoose.sortedGetChoices(message, 1, 1, choices, comparer, new Callback<List<T>>(){

            @Override
            public void run(List<T> result) {
                assert (result.size() == 1);
                callback.run(result.get(0));
            }
        });
    }

    public static <T> void sortedNoneOrMany(String message, List<T> choices, Comparator<T> comparer, Callback<List<T>> callback) {
        GuiChoose.sortedGetChoices(message, 0, choices.size(), choices, comparer, callback);
    }

    public static <T> void sortedGetChoices(String message, int min2, int max, T[] choices, Comparator<T> comparer, Callback<List<T>> callback) {
        Arrays.sort(choices, comparer);
        GuiChoose.getChoices(message, min2, max, choices, callback);
    }

    public static <T> void sortedGetChoices(String message, int min2, int max, List<T> choices, Comparator<T> comparer, Callback<List<T>> callback) {
        choices.sort(comparer);
        GuiChoose.getChoices(message, min2, max, choices, callback);
    }
}

