/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.Forge;
import forge.toolbox.FEvent;
import forge.toolbox.FTextField;
import forge.toolbox.GuiChoose;
import forge.util.Callback;

public class FSpinner
extends FTextField {
    private int value;
    private int minValue;
    private int maxValue;

    public FSpinner(int minValue0, int maxValue0) {
        this(minValue0, maxValue0, minValue0);
    }

    public FSpinner(int minValue0, int maxValue0, int initialValue) {
        this.minValue = minValue0;
        this.maxValue = maxValue0;
        this.value = this.minValue - 1;
        this.setValue(initialValue);
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value0) {
        if (value0 < this.minValue) {
            value0 = this.minValue;
        } else if (value0 > this.maxValue) {
            value0 = this.maxValue;
        }
        if (this.value == value0) {
            return;
        }
        this.value = value0;
        this.setText(String.valueOf(this.value));
    }

    @Override
    public boolean tap(float x, float y, int count) {
        GuiChoose.getInteger(Forge.getLocalizer().getMessage("lblSelectANumber", new Object[0]), this.minValue, this.maxValue, new Callback<Integer>(){

            @Override
            public void run(Integer result) {
                if (result != null && result != FSpinner.this.value) {
                    int oldValue = FSpinner.this.value;
                    FSpinner.this.setValue(result);
                    if (FSpinner.this.getChangedHandler() != null) {
                        FSpinner.this.getChangedHandler().handleEvent(new FEvent(FSpinner.this, FEvent.FEventType.CHANGE, oldValue));
                    }
                }
            }
        });
        return true;
    }

    @Override
    public boolean startEdit() {
        return false;
    }
}

