/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.Graphics;
import forge.animation.ForgeAnimation;
import forge.assets.FSkinColor;
import forge.localinstance.properties.ForgePreferences;
import forge.model.FModel;
import forge.toolbox.FCardPanel;
import forge.toolbox.FContainer;
import forge.toolbox.FDisplayObject;
import forge.util.PhysicsObject;
import forge.util.Utils;
import java.util.List;

public abstract class FScrollPane
extends FContainer {
    private static final float FLING_DECEL = 750.0f;
    private static final float INDICATOR_SIZE = Utils.scale(5.0f);
    private static final float INDICATOR_MARGIN = Utils.scale(3.0f);
    private float scrollLeft;
    private float scrollTop;
    private ScrollBounds scrollBounds = new ScrollBounds();
    private FlingAnimation activeFlingAnimation;

    public static FSkinColor getIndicatorColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT).alphaColor(0.7f);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT).alphaColor(0.7f);
    }

    public float getIndicatorMargin() {
        return INDICATOR_MARGIN;
    }

    public float getIndicatorSize() {
        return INDICATOR_SIZE;
    }

    public float getScrollLeft() {
        return this.scrollLeft;
    }

    public void setScrollLeft(float scrollLeft0) {
        this.setScrollPositions(scrollLeft0, this.scrollTop);
    }

    public float getScrollTop() {
        return this.scrollTop;
    }

    public void setScrollTop(float scrollTop0) {
        this.setScrollPositions(this.scrollLeft, scrollTop0);
    }

    public float getScrollWidth() {
        return this.scrollBounds.width;
    }

    public float getScrollHeight() {
        return this.scrollBounds.height;
    }

    public float getMaxScrollLeft() {
        return this.getScrollWidth() - this.getWidth();
    }

    public float getMaxScrollTop() {
        return this.getScrollHeight() - this.getHeight();
    }

    public void scrollToLeft() {
        this.setScrollPositions(0.0f, this.scrollTop);
    }

    public void scrollToRight() {
        this.setScrollPositions(this.getMaxScrollLeft(), this.scrollTop);
    }

    public void scrollToTop() {
        this.setScrollPositions(this.scrollLeft, 0.0f);
    }

    public void scrollToBottom() {
        this.setScrollPositions(this.scrollLeft, this.getMaxScrollTop());
    }

    public void scrollIntoView(FDisplayObject child) {
        this.scrollIntoView(child, 0.0f);
    }

    public void scrollIntoView(FDisplayObject child, float margin) {
        Vector2 childPos = this.getChildRelativePosition(child);
        if (childPos == null) {
            return;
        }
        this.scrollIntoView(childPos.x, childPos.y, child.getWidth(), child.getHeight(), margin);
    }

    public void scrollIntoView(float childLeft, float childTop, float childWidth, float childHeight, float margin) {
        float childRight = childLeft + childWidth;
        float childBottom = childTop + childHeight;
        float dx = 0.0f;
        if (childLeft < margin) {
            dx = childLeft - margin;
        } else if (childRight > this.getWidth() - margin) {
            dx = childRight - this.getWidth() + margin;
        }
        float dy = 0.0f;
        if (childTop < margin) {
            dy = childTop - margin;
        } else if (childBottom > this.getHeight() - margin) {
            dy = childBottom - this.getHeight() + margin;
        }
        if (dx == 0.0f && dy == 0.0f) {
            return;
        }
        this.setScrollPositions(this.scrollLeft + dx, this.scrollTop + dy);
    }

    private boolean setScrollPositions(float scrollLeft0, float scrollTop0) {
        if (scrollLeft0 < 0.0f) {
            scrollLeft0 = 0.0f;
        } else {
            float maxScrollLeft = this.getMaxScrollLeft();
            if (scrollLeft0 > maxScrollLeft) {
                scrollLeft0 = maxScrollLeft;
            }
        }
        if (scrollTop0 < 0.0f) {
            scrollTop0 = 0.0f;
        } else {
            float maxScrollTop = this.getMaxScrollTop();
            if (scrollTop0 > maxScrollTop) {
                scrollTop0 = maxScrollTop;
            }
        }
        float dx = this.scrollLeft - scrollLeft0;
        float dy = this.scrollTop - scrollTop0;
        if (dx == 0.0f && dy == 0.0f) {
            return false;
        }
        this.scrollLeft = scrollLeft0;
        this.scrollTop = scrollTop0;
        try {
            for (FDisplayObject obj : this.getChildren()) {
                if (obj == null) continue;
                if (obj instanceof FCardPanel) {
                    ((FCardPanel)obj).getCard().updateNeedsTransformAnimation(false);
                    ((FCardPanel)obj).getCard().updateNeedsUntapAnimation(false);
                    ((FCardPanel)obj).getCard().updateNeedsTapAnimation(false);
                }
                obj.setPosition(obj.getLeft() + dx, obj.getTop() + dy);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    protected void doLayout(float width, float height) {
        this.scrollBounds = this.layoutAndGetScrollBounds(width, height);
        this.scrollBounds.increaseWidthTo(width);
        this.scrollBounds.increaseHeightTo(height);
        float oldScrollLeft = this.scrollLeft;
        float oldScrollTop = this.scrollTop;
        this.scrollLeft = 0.0f;
        this.scrollTop = 0.0f;
        this.setScrollPositionsAfterLayout(oldScrollLeft, oldScrollTop);
    }

    @Override
    protected void drawOverlay(Graphics g2) {
        try {
            float y;
            float x;
            boolean isFieldZoneView;
            boolean bl = isFieldZoneView = this.toString().contains("VField") || this.toString().contains("VZoneDisplay");
            if (!FModel.getPreferences().getPrefBoolean(ForgePreferences.FPref.UI_ENABLE_MATCH_SCROLL_INDICATOR)) {
                return;
            }
            if (!isFieldZoneView) {
                return;
            }
            if (this.scrollLeft > 0.0f) {
                x = INDICATOR_MARGIN;
                y = this.getHeight() / 2.0f;
                g2.fillTriangle(FScrollPane.getIndicatorColor(), x, y, x + INDICATOR_SIZE, y - INDICATOR_SIZE, x + INDICATOR_SIZE, y + INDICATOR_SIZE);
            }
            if (this.scrollLeft < this.getMaxScrollLeft()) {
                x = this.getWidth() - INDICATOR_MARGIN;
                y = this.getHeight() / 2.0f;
                g2.fillTriangle(FScrollPane.getIndicatorColor(), x, y, x - INDICATOR_SIZE, y - INDICATOR_SIZE, x - INDICATOR_SIZE, y + INDICATOR_SIZE);
            }
            if (this.scrollTop > 0.0f) {
                x = this.getWidth() / 2.0f;
                y = INDICATOR_MARGIN;
                g2.fillTriangle(FScrollPane.getIndicatorColor(), x, y, x - INDICATOR_SIZE, y + INDICATOR_SIZE, x + INDICATOR_SIZE, y + INDICATOR_SIZE);
            }
            if (this.scrollTop < this.getMaxScrollTop()) {
                x = this.getWidth() / 2.0f;
                y = this.getHeight() - INDICATOR_MARGIN;
                g2.fillTriangle(FScrollPane.getIndicatorColor(), x, y, x - INDICATOR_SIZE, y - INDICATOR_SIZE, x + INDICATOR_SIZE, y - INDICATOR_SIZE);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void setScrollPositionsAfterLayout(float scrollLeft0, float scrollTop0) {
        this.setScrollPositions(scrollLeft0, scrollTop0);
    }

    protected abstract ScrollBounds layoutAndGetScrollBounds(float var1, float var2);

    @Override
    public boolean fling(float velocityX, float velocityY) {
        if (Math.abs(velocityY) > Math.abs(velocityX) ? this.getMaxScrollTop() == 0.0f : this.getMaxScrollLeft() == 0.0f) {
            return false;
        }
        velocityX = -velocityX;
        velocityY = -velocityY;
        if (this.activeFlingAnimation == null) {
            this.activeFlingAnimation = new FlingAnimation(velocityX, velocityY);
            this.activeFlingAnimation.start();
        } else {
            this.activeFlingAnimation.physicsObj.getVelocity().set(velocityX, velocityY);
            this.activeFlingAnimation.physicsObj.setDecel(750.0f, 750.0f);
        }
        return true;
    }

    @Override
    public void buildTouchListeners(float screenX, float screenY, List<FDisplayObject> listeners) {
        if (this.activeFlingAnimation != null) {
            boolean suppressEvent = this.activeFlingAnimation.physicsObj.getVelocity().len() > Utils.AVG_FINGER_HEIGHT;
            this.activeFlingAnimation.physicsObj.stop();
            if (suppressEvent) {
                listeners.add(this);
                return;
            }
        }
        super.buildTouchListeners(screenX, screenY, listeners);
    }

    @Override
    public boolean pan(float x, float y, float deltaX, float deltaY, boolean moreVertical) {
        if (this.getMaxScrollTop() <= 0.0f && (moreVertical || y < 0.0f || y >= this.getHeight() || Math.abs(deltaY) > Math.abs(deltaX))) {
            return false;
        }
        if (this.getMaxScrollLeft() <= 0.0f && (!moreVertical || x < 0.0f || x >= this.getWidth() || Math.abs(deltaX) > Math.abs(deltaY))) {
            return false;
        }
        this.setScrollPositions(this.scrollLeft - deltaX, this.scrollTop - deltaY);
        return true;
    }

    protected void startClip(Graphics g2) {
        g2.startClip(0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    @Override
    public void draw(Graphics g2) {
        this.startClip(g2);
        super.draw(g2);
        g2.endClip();
    }

    private class FlingAnimation
    extends ForgeAnimation {
        private final PhysicsObject physicsObj;

        private FlingAnimation(float velocityX, float velocityY) {
            this.physicsObj = new PhysicsObject(new Vector2(FScrollPane.this.scrollLeft, FScrollPane.this.scrollTop), new Vector2(velocityX, velocityY));
            this.physicsObj.setDecel(750.0f, 750.0f);
        }

        @Override
        protected boolean advance(float dt) {
            if (this.physicsObj.isMoving()) {
                this.physicsObj.advance(dt);
                Vector2 pos = this.physicsObj.getPosition();
                return FScrollPane.this.setScrollPositions(pos.x, pos.y) && this.physicsObj.isMoving();
            }
            return false;
        }

        @Override
        protected void onEnd(boolean endingAll) {
            FScrollPane.this.activeFlingAnimation = null;
        }
    }

    public static class ScrollBounds {
        private float width;
        private float height;

        protected ScrollBounds() {
            this(0.0f, 0.0f);
        }

        public ScrollBounds(float width0, float height0) {
            this.width = width0;
            this.height = height0;
        }

        public float getWidth() {
            return this.width;
        }

        public float getHeight() {
            return this.height;
        }

        public void increaseWidthTo(float width0) {
            if (width0 > this.width) {
                this.width = width0;
            }
        }

        public void increaseHeightTo(float height0) {
            if (height0 > this.height) {
                this.height = height0;
            }
        }
    }
}

