/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.badlogic.gdx.graphics.Color;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinFont;
import forge.gui.interfaces.IProgressBar;
import forge.toolbox.FDisplayObject;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.lang3.tuple.Pair;

public class FProgressBar
extends FDisplayObject
implements IProgressBar {
    public static Color BACK_COLOR;
    public static Color FORE_COLOR;
    public static Color SEL_BACK_COLOR;
    public static Color SEL_FORE_COLOR;
    public static Color ADV_BACK_COLOR;
    public static Color ADV_FORE_COLOR;
    public static Color ADV_SEL_BACK_COLOR;
    public static Color ADV_SEL_FORE_COLOR;
    private static FSkinFont MSG_FONT;
    private static float TRAIL_INTERVAL;
    private long startTime = 0L;
    private int maximum = 0;
    private int value = 0;
    private String desc = "";
    private String message;
    private boolean showETA = true;
    private boolean showCount = true;
    private boolean showProgressTrail = false;
    private long progressTrailStart = -1L;
    private boolean percentMode = false;

    public static Color getBackColor() {
        if (Forge.isMobileAdventureMode) {
            return ADV_BACK_COLOR;
        }
        return BACK_COLOR;
    }

    public static Color getForeColor() {
        if (Forge.isMobileAdventureMode) {
            return ADV_FORE_COLOR;
        }
        return FORE_COLOR;
    }

    public static Color getSelBackColor() {
        if (Forge.isMobileAdventureMode) {
            return ADV_SEL_BACK_COLOR;
        }
        return SEL_BACK_COLOR;
    }

    public static Color getSelForeColor() {
        if (Forge.isMobileAdventureMode) {
            return ADV_SEL_FORE_COLOR;
        }
        return SEL_FORE_COLOR;
    }

    public FProgressBar() {
        this.reset();
    }

    @Override
    public void setDescription(String s0) {
        this.desc = s0;
        this.message = s0;
    }

    @Override
    public void setValue(int progress) {
        this.value = progress;
        this.setShowProgressTrail(false);
        StringBuilder sb = new StringBuilder(this.desc);
        if (this.showCount) {
            sb.append(" ");
            if (this.percentMode) {
                sb.append(100 * this.value / this.maximum).append("%");
            } else {
                sb.append(this.value).append(" of ").append(this.maximum);
            }
        }
        if (this.showETA && this.value > 0) {
            long elapsed = new Date().getTime() - this.startTime;
            float timePerUnit = elapsed / (long)this.value;
            int etaSecs = (int)((float)(this.maximum - this.value) * timePerUnit / 1000.0f);
            sb.append(", ETA").append(String.format("%02d:%02d:%02d", etaSecs / 3600, etaSecs % 3600 / 60, etaSecs % 60 + 1));
        }
        this.message = sb.toString();
    }

    @Override
    public void reset() {
        this.value = 0;
        this.startTime = new Date().getTime();
        this.setShowETA(true);
        this.setShowCount(true);
        this.setShowProgressTrail(false);
    }

    @Override
    public void setShowETA(boolean b0) {
        this.showETA = b0;
    }

    @Override
    public void setShowCount(boolean b0) {
        this.showCount = b0;
    }

    public void setShowProgressTrail(boolean b0) {
        if (this.showProgressTrail == b0) {
            return;
        }
        this.showProgressTrail = b0;
        this.progressTrailStart = -1L;
    }

    public boolean isPercentMode() {
        return this.percentMode;
    }

    @Override
    public void setPercentMode(boolean percentMode0) {
        this.percentMode = percentMode0;
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(int maximum0) {
        this.maximum = maximum0;
    }

    @Override
    public void draw(Graphics g2) {
        float w = this.getWidth();
        float h2 = this.getHeight();
        ArrayList<Pair<Float, Float>> selTextRegions = new ArrayList<Pair<Float, Float>>();
        if (this.showProgressTrail) {
            long now = new Date().getTime();
            if (this.progressTrailStart == -1L) {
                this.progressTrailStart = now;
            }
            float halfWidth = w / 2.0f;
            float trailPercent = (float)(now - this.progressTrailStart) % TRAIL_INTERVAL / TRAIL_INTERVAL;
            if (trailPercent == 0.0f) {
                g2.fillGradientRect(FProgressBar.getBackColor(), FProgressBar.getSelBackColor(), false, 0.0f, 0.0f, w, h2);
                selTextRegions.add(Pair.of(Float.valueOf(halfWidth), Float.valueOf(halfWidth)));
            } else {
                float trailX = trailPercent * w;
                g2.startClip(0.0f, 0.0f, w, h2);
                g2.fillGradientRect(FProgressBar.getBackColor(), FProgressBar.getSelBackColor(), false, trailX - w, 0.0f, w, h2);
                g2.fillGradientRect(FProgressBar.getBackColor(), FProgressBar.getSelBackColor(), false, trailX, 0.0f, w, h2);
                g2.endClip();
                if (trailX >= halfWidth) {
                    selTextRegions.add(Pair.of(Float.valueOf(trailX - halfWidth), Float.valueOf(halfWidth)));
                } else {
                    selTextRegions.add(Pair.of(Float.valueOf(0.0f), Float.valueOf(trailX)));
                    float x = trailX + halfWidth;
                    selTextRegions.add(Pair.of(Float.valueOf(x), Float.valueOf(w - x)));
                }
            }
        } else {
            g2.fillRect(FProgressBar.getBackColor(), 0.0f, 0.0f, w, h2);
            float selWidth = Math.round(w * (float)this.value / (float)this.maximum);
            if (selWidth > 0.0f) {
                g2.fillRect(FProgressBar.getSelBackColor(), 0.0f, 0.0f, selWidth, h2);
                selTextRegions.add(Pair.of(Float.valueOf(0.0f), Float.valueOf(selWidth)));
            }
        }
        if (MSG_FONT == null) {
            MSG_FONT = FSkinFont.get(11);
        }
        g2.drawText(this.message, MSG_FONT, FProgressBar.getForeColor(), 0.0f, 0.0f, w, h2, false, 1, true);
        if (!FProgressBar.getSelForeColor().equals(FProgressBar.getForeColor())) {
            for (Pair pair : selTextRegions) {
                g2.startClip(((Float)pair.getLeft()).floatValue(), 0.0f, ((Float)pair.getRight()).floatValue(), h2);
                g2.drawText(this.message, MSG_FONT, FProgressBar.getSelForeColor(), 0.0f, 0.0f, w, h2, false, 1, true);
                g2.endClip();
            }
        }
        g2.drawRect(Utils.scale(1.0f), Color.BLACK, 0.0f, 0.0f, w, h2);
    }

    static {
        TRAIL_INTERVAL = 5000.0f;
    }
}

