/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.badlogic.gdx.math.Vector2;
import com.google.common.collect.ImmutableList;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkin;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.card.CardRenderer;
import forge.card.CardZoom;
import forge.game.card.CardView;
import forge.localinstance.skin.FSkinProp;
import forge.screens.match.views.VPrompt;
import forge.toolbox.FComboBox;
import forge.toolbox.FContainer;
import forge.toolbox.FDialog;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FLabel;
import forge.toolbox.FTextArea;
import forge.toolbox.FTextField;
import forge.util.Callback;
import forge.util.Utils;
import forge.util.WaitCallback;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class FOptionPane
extends FDialog {
    public static final FSkinImage QUESTION_ICON = FSkinImage.QUESTION;
    public static final FSkinImage INFORMATION_ICON = FSkinImage.INFORMATION;
    public static final FSkinImage WARNING_ICON = FSkinImage.WARNING;
    public static final FSkinImage ERROR_ICON = FSkinImage.ERROR;
    public static final float PADDING = Utils.scale(10.0f);
    private final FLabel lblIcon;
    private final FTextArea prompt;
    protected final FDisplayObject displayObj;
    private final Callback<Integer> callback;
    private final int defaultOption;
    private final boolean centerIcon;

    public static float getMaxDisplayObjHeight() {
        return (float)Forge.getScreenHeight() - VPrompt.HEIGHT - 2.0f * FDialog.MSG_HEIGHT;
    }

    public static void showMessageDialog(String message) {
        FOptionPane.showMessageDialog(message, "", INFORMATION_ICON);
    }

    public static void showMessageDialog(String message, String title) {
        FOptionPane.showMessageDialog(message, title, INFORMATION_ICON);
    }

    public static void showErrorDialog(String message) {
        FOptionPane.showMessageDialog(message, "", ERROR_ICON);
    }

    public static void showErrorDialog(String message, String title) {
        FOptionPane.showMessageDialog(message, title, ERROR_ICON);
    }

    public static void showMessageDialog(String message, String title, FImage icon) {
        FOptionPane.showOptionDialog(message, title, icon, ImmutableList.of(Forge.getLocalizer().getMessage("lblOK", new Object[0])), 0, null);
    }

    public static void showMessageDialog(String message, FSkinFont messageFont, String title, FImage icon) {
        FOptionPane.showOptionDialog(message, messageFont, title, icon, ImmutableList.of(Forge.getLocalizer().getMessage("lblOK", new Object[0])), 0, null);
    }

    public static void showMessageDialog(String message, String title, FImage icon, Callback<Integer> callback) {
        FOptionPane.showOptionDialog(message, title, icon, ImmutableList.of(Forge.getLocalizer().getMessage("lblOK", new Object[0])), 0, callback);
    }

    public static void showConfirmDialog(String message, Callback<Boolean> callback) {
        FOptionPane.showConfirmDialog(message, "", callback);
    }

    public static void showConfirmDialog(String message, String title, Callback<Boolean> callback) {
        FOptionPane.showConfirmDialog(message, title, Forge.getLocalizer().getMessage("lblYes", new Object[0]), Forge.getLocalizer().getMessage("lblNo", new Object[0]), true, callback);
    }

    public static void showConfirmDialog(String message, String title, boolean defaultYes, Callback<Boolean> callback) {
        FOptionPane.showConfirmDialog(message, title, Forge.getLocalizer().getMessage("lblYes", new Object[0]), Forge.getLocalizer().getMessage("lblNo", new Object[0]), defaultYes, callback);
    }

    public static void showConfirmDialog(String message, String title, String yesButtonText, String noButtonText, Callback<Boolean> callback) {
        FOptionPane.showConfirmDialog(message, title, yesButtonText, noButtonText, true, callback);
    }

    public static void showConfirmDialog(String message, String title, String yesButtonText, String noButtonText, boolean defaultYes, final Callback<Boolean> callback) {
        ImmutableList<String> options = ImmutableList.of(yesButtonText, noButtonText);
        FOptionPane.showOptionDialog(message, title, QUESTION_ICON, options, defaultYes ? 0 : 1, new Callback<Integer>(){

            @Override
            public void run(Integer result) {
                callback.run(result == 0);
            }
        });
    }

    public static void showOptionDialog(String message, String title, FImage icon, List<String> options, Callback<Integer> callback) {
        FOptionPane.showOptionDialog(message, title, icon, options, 0, callback);
    }

    public static void showOptionDialog(String message, String title, FImage icon, List<String> options, int defaultOption, Callback<Integer> callback) {
        FOptionPane.showOptionDialog(message, null, title, icon, options, defaultOption, callback);
    }

    public static void showOptionDialog(String message, FSkinFont messageFont, String title, FImage icon, List<String> options, int defaultOption, Callback<Integer> callback) {
        FOptionPane optionPane = new FOptionPane(message, messageFont, title, icon, null, options, defaultOption, callback);
        optionPane.show();
    }

    public static int showCardOptionDialog(final CardView card, final String message, final String title, final FSkinProp icon, final List<String> options, final int defaultOption) {
        return (Integer)new WaitCallback<Integer>(){

            @Override
            public void run() {
                FOptionPane.showCardOptionDialog(card, message, title, icon == null ? null : (FImage)FSkin.getImages().get((Object)icon), options, defaultOption, this);
            }
        }.invokeAndWait();
    }

    public static void showCardOptionDialog(final CardView card, String message, String title, FImage icon, List<String> options, int defaultOption, Callback<Integer> callback) {
        FDisplayObject cardDisplay;
        if (card != null) {
            cardDisplay = new FDisplayObject(){

                @Override
                public boolean tap(float x, float y, int count) {
                    CardZoom.show(card);
                    return true;
                }

                @Override
                public boolean longPress(float x, float y) {
                    CardZoom.show(card);
                    return true;
                }

                @Override
                public void draw(Graphics g2) {
                    float h2 = this.getHeight();
                    float w = h2 / 1.4f;
                    float x = (this.getWidth() - w) / 2.0f;
                    float y = 0.0f;
                    CardRenderer.drawCard(g2, card, x, 0.0f, w, h2, CardRenderer.CardStackPosition.Top, true);
                }
            };
            cardDisplay.setHeight(Forge.getScreenHeight() / 2);
        } else {
            cardDisplay = null;
        }
        if (StringUtils.isEmpty(title) && !message.contains("\n")) {
            title = message;
            message = null;
            icon = null;
        }
        FOptionPane optionPane = new FOptionPane(message, null, title, icon, cardDisplay, options, defaultOption, callback);
        optionPane.show();
    }

    public static void showInputDialog(String title, Callback<String> callback) {
        FOptionPane.showInputDialog(null, title, "", null, callback, false);
    }

    public static <T> void showInputDialog(String title, T initialInput, Callback<T> callback) {
        FOptionPane.showInputDialog(null, title, initialInput, null, callback, false);
    }

    public static <T> void showInputDialog(String message, String title, T initialInput, List<T> inputOptions, final Callback<T> callback, boolean isNumeric) {
        FTextField inputField;
        FComboBox<T> cbInput;
        FTextField txtInput;
        if (inputOptions == null) {
            txtInput = new FTextField(initialInput.toString());
            txtInput.setIsNumeric(isNumeric);
            cbInput = null;
            inputField = txtInput;
        } else {
            txtInput = null;
            cbInput = new FComboBox<T>(inputOptions);
            cbInput.setSelectedItem(initialInput);
            inputField = cbInput;
        }
        final float padTop = message == null ? PADDING : 0.0f;
        FContainer container = new FContainer(){

            @Override
            protected void doLayout(float width, float height) {
                inputField.setBounds(0.0f, padTop, width, inputField.getHeight());
            }
        };
        container.add(inputField);
        container.setHeight(inputField.getHeight() + padTop + PADDING);
        FOptionPane optionPane = new FOptionPane(message, null, title, null, (FDisplayObject)container, ImmutableList.of(Forge.getLocalizer().getMessage("lblOK", new Object[0]), Forge.getLocalizer().getMessage("lblCancel", new Object[0])), 0, (Callback)new Callback<Integer>(){

            @Override
            public void run(Integer result) {
                if (result == 0) {
                    if (txtInput != null) {
                        callback.run(txtInput.getText());
                    } else {
                        callback.run(cbInput.getSelectedItem());
                    }
                } else {
                    callback.run(null);
                }
            }
        }){

            @Override
            protected float getBottomMargin() {
                return (float)Forge.getScreenHeight() * 0.4f;
            }

            @Override
            protected boolean padAboveAndBelow() {
                return false;
            }

            @Override
            protected boolean centerPrompt() {
                return true;
            }
        };
        optionPane.show();
        if (txtInput != null) {
            txtInput.startEdit();
        }
    }

    public FOptionPane(String message, FSkinFont messageFont, String title, FImage icon, FDisplayObject displayObj0, List<String> options, int defaultOption0, Callback<Integer> callback0) {
        super(title, options.size());
        if (icon != null) {
            this.centerIcon = icon.getWidth() >= 100.0f;
            this.lblIcon = this.add(new FLabel.Builder().icon(icon).iconScaleFactor(1.0f).insets(new Vector2(0.0f, 0.0f)).iconInBackground(this.centerIcon).build());
            if (this.centerIcon) {
                this.lblIcon.setAlignment(1);
            }
        } else {
            this.lblIcon = null;
            this.centerIcon = false;
        }
        if (message != null) {
            this.prompt = this.add(new FTextArea(true, message));
            this.prompt.setFont(messageFont != null ? messageFont : FSkinFont.get(12));
            if (this.centerIcon || this.centerPrompt()) {
                this.prompt.setAlignment(1);
            }
        } else {
            this.prompt = null;
        }
        this.displayObj = displayObj0;
        if (this.displayObj != null) {
            this.add(this.displayObj);
        }
        this.callback = callback0;
        int optionsSize = options.size();
        for (int i = 0; i < optionsSize; ++i) {
            int option = i;
            this.initButton(i, options.get(i), e -> this.setResult(option));
        }
        this.defaultOption = defaultOption0;
    }

    public void setResult(int option) {
        this.hide();
        if (this.callback != null) {
            this.callback.run(option);
        }
    }

    protected boolean padAboveAndBelow() {
        return true;
    }

    protected boolean centerPrompt() {
        return false;
    }

    @Override
    protected float layoutAndGetHeight(float width, float maxHeight) {
        float x = PADDING;
        float y = PADDING;
        float maxPromptHeight = maxHeight - 2.0f * PADDING;
        if (this.displayObj != null) {
            maxPromptHeight -= this.displayObj.getHeight();
        }
        float promptHeight = 0.0f;
        if (this.lblIcon != null) {
            float labelWidth = Utils.scale(this.lblIcon.getIcon().getWidth());
            promptHeight = this.lblIcon.getIcon().getHeight() * labelWidth / this.lblIcon.getIcon().getWidth();
            if (promptHeight > maxPromptHeight) {
                promptHeight = maxPromptHeight;
            }
            if (this.centerIcon) {
                this.lblIcon.setBounds(x, y, width - 2.0f * PADDING, promptHeight);
                y += promptHeight + PADDING;
            } else {
                this.lblIcon.setBounds(x - Utils.scale(3.0f), y, labelWidth, promptHeight);
                x += labelWidth;
            }
        }
        if (this.prompt != null) {
            float promptWidth = width - x - PADDING;
            this.prompt.setBounds(x, y, promptWidth, this.prompt.getPreferredHeight(promptWidth));
            if (this.prompt.getHeight() < promptHeight && !this.centerIcon) {
                this.prompt.setTop(y + (promptHeight - this.prompt.getHeight()) / 2.0f);
            } else if (this.prompt.getHeight() > maxPromptHeight) {
                this.prompt.setHeight(maxPromptHeight);
            }
            if (this.prompt.getHeight() > promptHeight || this.centerIcon) {
                promptHeight = this.prompt.getHeight();
            }
        }
        if (promptHeight > 0.0f) {
            y += promptHeight + PADDING;
        }
        if (this.displayObj != null) {
            if (!this.padAboveAndBelow()) {
                y -= PADDING;
            }
            this.displayObj.setBounds(0.0f, y, width, this.displayObj.getHeight());
            y += this.displayObj.getHeight();
            if (this.padAboveAndBelow()) {
                y += PADDING;
            }
        }
        return y;
    }

    @Override
    public boolean keyDown(int keyCode) {
        switch (keyCode) {
            case 62: 
            case 66: {
                if (this.isButtonEnabled(this.defaultOption)) {
                    this.setResult(this.defaultOption);
                }
                return true;
            }
            case 4: 
            case 111: {
                if (Forge.endKeyInput()) {
                    return true;
                }
                if (this.defaultOption == -1) {
                    this.hide();
                    return true;
                }
                if (this.isButtonEnabled(1)) {
                    this.setResult(this.isButtonEnabled(2) ? 2 : 1);
                }
                return true;
            }
        }
        return super.keyDown(keyCode);
    }
}

