/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.Graphics;
import forge.assets.FImage;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.assets.TextRenderer;
import forge.gui.UiCommand;
import forge.gui.interfaces.IButton;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.util.TextBounds;
import forge.util.Utils;

public class FLabel
extends FDisplayObject
implements IButton {
    public static final float DEFAULT_INSETS = Utils.scale(3.0f);
    public static final float BORDER_THICKNESS = Utils.scale(1.0f);
    private float iconScaleFactor;
    private FSkinFont font;
    private float alphaComposite;
    private int alignment;
    private Vector2 insets;
    private boolean selectable;
    private boolean selected;
    private boolean opaque;
    private boolean iconInBackground;
    private boolean iconScaleAuto;
    private boolean iconScaleWithFont;
    private boolean pressed;
    private String text;
    private FImage icon;
    private FSkinImage overlayIcon;
    private FSkinColor textColor;
    private FSkinColor pressedColor;
    private FEvent.FEventHandler command;
    private TextRenderer textRenderer;

    public static void drawButtonBackground(Graphics g2, float w, float h2, boolean pressed) {
        if (pressed) {
            g2.fillGradientRect(FLabel.getD50(), FLabel.getD10(), true, 0.0f, 0.0f, w, h2);
            g2.drawRect(BORDER_THICKNESS, FLabel.getD50(), 0.0f, 0.0f, w, h2);
        } else {
            g2.fillGradientRect(FLabel.getD10(), FLabel.getL20(), true, 0.0f, 0.0f, w, h2);
            g2.drawRect(BORDER_THICKNESS, FLabel.getD10(), 0.0f, 0.0f, w, h2);
        }
    }

    public static FSkinColor getDefaultTextColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    public static FSkinColor getInlineLabelColor() {
        return FLabel.getDefaultTextColor().alphaColor(0.7f);
    }

    private static FSkinColor getClrMain() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_INACTIVE);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_INACTIVE);
    }

    private static FSkinColor getD50() {
        return FLabel.getClrMain().stepColor(-50);
    }

    private static FSkinColor getD30() {
        return FLabel.getClrMain().stepColor(-30);
    }

    private static FSkinColor getD10() {
        return FLabel.getClrMain().stepColor(-10);
    }

    private static FSkinColor getL10() {
        return FLabel.getClrMain().stepColor(10);
    }

    private static FSkinColor getL20() {
        return FLabel.getClrMain().stepColor(20);
    }

    protected FLabel(Builder b0) {
        this.iconScaleFactor = b0.bldIconScaleFactor;
        this.font = b0.bldFont;
        this.alphaComposite = b0.bldAlphaComposite;
        this.alignment = b0.bldAlignment;
        this.insets = b0.bldInsets;
        this.selectable = b0.bldSelectable;
        this.selected = b0.bldSelected;
        this.opaque = b0.bldOpaque;
        this.iconInBackground = b0.bldIconInBackground;
        this.iconScaleAuto = b0.bldIconScaleAuto;
        this.iconScaleWithFont = b0.bldIconScaleWithFont;
        this.text = b0.bldText != null ? b0.bldText : "";
        this.icon = b0.bldIcon;
        this.textColor = b0.bldTextColor;
        this.pressedColor = b0.bldPressedColor;
        this.command = b0.bldCommand;
        if (b0.bldParseSymbols) {
            this.textRenderer = new TextRenderer();
        }
        this.setEnabled(b0.bldEnabled);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setSelected(boolean b0) {
        this.selected = b0;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text0) {
        this.text = text0;
    }

    public FSkinColor getTextColor() {
        return this.textColor;
    }

    public void setTextColor(FSkinColor textColor0) {
        this.textColor = textColor0;
    }

    public FSkinFont getFont() {
        return this.font;
    }

    public void setFont(FSkinFont font0) {
        this.font = font0;
    }

    public FImage getIcon() {
        return this.icon;
    }

    public void setIcon(FImage icon0) {
        this.icon = icon0;
    }

    public void setOverlayIcon(FSkinImage overlayIcon0) {
        this.overlayIcon = overlayIcon0;
    }

    public boolean getIconScaleAuto() {
        return this.iconScaleAuto;
    }

    public void setIconScaleAuto(boolean b0) {
        this.iconScaleAuto = b0;
    }

    public Vector2 getInsets() {
        return this.insets;
    }

    public void setInsets(Vector2 insets0) {
        this.insets = insets0;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment0) {
        this.alignment = alignment0;
    }

    public void setCommand(FEvent.FEventHandler command0) {
        this.command = command0;
    }

    public float getAlphaComposite() {
        return this.alphaComposite;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    @Override
    public final boolean press(float x, float y) {
        if (this.opaque || this.selectable || this.pressedColor != null) {
            this.pressed = true;
            return true;
        }
        return false;
    }

    @Override
    public final boolean release(float x, float y) {
        if (this.pressed) {
            this.pressed = false;
            return true;
        }
        return false;
    }

    @Override
    public boolean tap(float x, float y, int count) {
        boolean handled = false;
        if (this.selectable) {
            this.setSelected(!this.selected);
            handled = true;
        }
        if (this.command != null) {
            this.command.handleEvent(new FEvent(this, FEvent.FEventType.TAP));
            handled = true;
        }
        return handled;
    }

    public boolean trigger() {
        if (this.isEnabled() && this.command != null) {
            this.command.handleEvent(new FEvent(this, FEvent.FEventType.TAP));
            return true;
        }
        return false;
    }

    public TextBounds getAutoSizeBounds() {
        TextBounds bounds;
        if (this.text.isEmpty()) {
            bounds = new TextBounds();
            bounds.height += this.font.getLineHeight();
        } else {
            bounds = this.font.getMultiLineBounds(this.text);
            bounds.height += this.font.getLineHeight() - this.font.getCapHeight();
        }
        bounds.width += 2.0f * this.insets.x;
        bounds.height += 2.0f * this.insets.y;
        if (this.icon != null) {
            bounds.width += this.icon.getWidth() + this.insets.x + this.getExtraGapBetweenIconAndText();
        }
        return bounds;
    }

    @Override
    public void draw(Graphics g2) {
        boolean applyAlphaComposite;
        float w = this.getWidth();
        float h2 = this.getHeight();
        g2.startClip(0.0f, 0.0f, w, h2);
        boolean bl = applyAlphaComposite = this.opaque && !this.pressed && this.isEnabled();
        if (applyAlphaComposite) {
            g2.setAlphaComposite(this.alphaComposite);
        }
        if (this.pressed) {
            if (this.pressedColor != null) {
                g2.fillRect(this.pressedColor, 0.0f, 0.0f, w, h2);
            } else {
                g2.fillGradientRect(FLabel.getD50(), FLabel.getD10(), true, 0.0f, 0.0f, w, h2);
                g2.drawRect(BORDER_THICKNESS, FLabel.getD50(), 0.0f, 0.0f, w, h2);
            }
        } else if (this.selected && (this.opaque || this.selectable)) {
            g2.fillGradientRect(FLabel.getD30(), FLabel.getL10(), true, 0.0f, 0.0f, w, h2);
            g2.drawRect(BORDER_THICKNESS, FLabel.getD30(), 0.0f, 0.0f, w, h2);
        } else if (this.opaque) {
            g2.fillGradientRect(FLabel.getD10(), FLabel.getL20(), true, 0.0f, 0.0f, w, h2);
            g2.drawRect(BORDER_THICKNESS, FLabel.getD10(), 0.0f, 0.0f, w, h2);
        } else if (this.selectable) {
            g2.drawRect(BORDER_THICKNESS, FLabel.getL10(), 0.0f, 0.0f, w, h2);
        }
        this.drawContent(g2, w, h2, this.pressed);
        if (applyAlphaComposite) {
            g2.resetAlphaComposite();
        }
        g2.endClip();
    }

    protected void drawContent(Graphics g2, float w, float h2, boolean pressed) {
        float x = this.insets.x;
        float y = this.insets.y;
        w -= 2.0f * x;
        h2 -= 2.0f * y;
        if (pressed) {
            x += Utils.scale(1.0f);
            y += Utils.scale(1.0f);
        }
        this.drawContent(g2, x, y, w, h2);
    }

    protected void drawContent(Graphics g2, float x, float y, float w, float h2) {
        try {
            if (this.icon != null) {
                float textY = y;
                float iconWidth = this.icon.getWidth();
                float iconHeight = this.icon.getHeight();
                float aspectRatio = iconWidth / iconHeight;
                if (this.iconScaleWithFont) {
                    iconHeight = this.font.getLineHeight() * this.iconScaleFactor;
                    iconWidth = iconHeight * aspectRatio;
                } else if ((this.iconInBackground || this.iconScaleAuto) && (iconWidth = (iconHeight = h2 * this.iconScaleFactor) * aspectRatio) > w && this.iconInBackground) {
                    iconWidth = w;
                    iconHeight = iconWidth / aspectRatio;
                }
                float iconOffset = iconWidth + this.insets.x + this.getExtraGapBetweenIconAndText();
                if (this.iconInBackground || this.text.isEmpty()) {
                    if (this.alignment == 1) {
                        x += (w - iconWidth) / 2.0f;
                    }
                    y += (h2 - iconHeight) / 2.0f;
                } else {
                    float dx;
                    if (this.alignment == 1) {
                        while (true) {
                            if ((dx = (w - iconOffset - this.getTextWidth()) / 2.0f) > 0.0f) {
                                x += dx;
                            } else if (this.font.canShrink()) {
                                this.font = this.font.shrink();
                                continue;
                            }
                            break;
                        }
                    } else if (this.alignment == 16) {
                        while (true) {
                            if ((dx = w - iconWidth - this.getTextWidth() - this.insets.x) > 0.0f) {
                                x += dx;
                                break;
                            }
                            if (!this.font.canShrink()) break;
                            this.font = this.font.shrink();
                        }
                    }
                    y += (h2 - iconHeight) / 2.0f;
                }
                float mod = this.isHovered() && this.selectable ? (iconWidth < iconHeight ? iconWidth / 8.0f : iconHeight / 8.0f) : 0.0f;
                g2.drawImage(this.icon, x - mod / 2.0f, y - mod / 2.0f, iconWidth + mod, iconHeight + mod);
                if (this.overlayIcon != null) {
                    float overlayHeight;
                    float oldAlpha = g2.getfloatAlphaComposite();
                    float overlayWidth = this.isHovered() ? iconWidth / 2.5f : iconWidth / 3.5f;
                    float f = overlayHeight = this.isHovered() ? iconHeight / 2.5f : iconHeight / 3.5f;
                    if (!this.isHovered()) {
                        g2.setAlphaComposite(0.4f);
                    }
                    g2.drawImage(this.overlayIcon, iconWidth - overlayWidth + mod, iconHeight - overlayHeight + mod, overlayWidth, overlayHeight);
                    g2.setAlphaComposite(oldAlpha);
                }
                if (!this.text.isEmpty()) {
                    this.drawText(g2, x += iconOffset, textY, w -= iconOffset, h2, 8);
                }
            } else if (!this.text.isEmpty()) {
                float oldAlpha = g2.getfloatAlphaComposite();
                if (this.isHovered() && this.selectable) {
                    g2.fillRect(FSkinColor.getStandardColor(Color.GRAY).alphaColor(0.4f), x, y, w, h2);
                }
                this.drawText(g2, x, y, w, h2, this.alignment);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void drawText(Graphics g2, float x, float y, float w, float h2, int align) {
        g2.startClip(x, y, w, h2);
        if (this.textRenderer == null) {
            g2.drawText(this.text, this.font, this.textColor, x, y, w, h2, false, align, true);
        } else {
            this.textRenderer.drawText(g2, this.text, this.font, this.textColor, x, y, w, h2, y, h2, false, align, true);
        }
        g2.endClip();
    }

    private float getTextWidth() {
        if (this.textRenderer == null) {
            return this.font.getMultiLineBounds((CharSequence)this.text).width;
        }
        return this.textRenderer.getBounds((String)this.text, (FSkinFont)this.font).width;
    }

    @Override
    public void setCommand(UiCommand command0) {
        this.setCommand((FEvent e) -> command0.run());
    }

    @Override
    public boolean requestFocusInWindow() {
        return false;
    }

    protected float getExtraGapBetweenIconAndText() {
        return 0.0f;
    }

    @Override
    public void setImage(FSkinProp color) {
        this.setTextColor(FSkinColor.get(FSkinColor.Colors.fromSkinProp(color)));
    }

    @Override
    public void setTextColor(int r, int g2, int b) {
        this.setTextColor(FSkinColor.getStandardColor(r, g2, b));
    }

    public static class ButtonBuilder
    extends Builder {
        public ButtonBuilder() {
            this.opaque();
            this.align(1);
        }
    }

    public static class Builder {
        private float bldIconScaleFactor = 0.8f;
        private FSkinFont bldFont = FSkinFont.get(14);
        private float bldAlphaComposite = 0.7f;
        private int bldAlignment = 8;
        private Vector2 bldInsets = new Vector2(DEFAULT_INSETS, DEFAULT_INSETS);
        private boolean bldSelectable = false;
        private boolean bldSelected = false;
        private boolean bldOpaque = false;
        private boolean bldIconInBackground = false;
        private boolean bldIconScaleWithFont = false;
        private boolean bldIconScaleAuto = true;
        private boolean bldEnabled = true;
        private boolean bldParseSymbols = true;
        private String bldText;
        private FImage bldIcon;
        private FSkinColor bldTextColor = FLabel.getDefaultTextColor();
        private FSkinColor bldPressedColor;
        private FEvent.FEventHandler bldCommand;

        public FLabel build() {
            return new FLabel(this);
        }

        public FLabel buildAboveOverlay() {
            return new FLabel(this){

                @Override
                protected boolean drawAboveOverlay() {
                    return true;
                }
            };
        }

        public Builder text(String s0) {
            this.bldText = s0;
            return this;
        }

        public Builder icon(FImage i0) {
            this.bldIcon = i0;
            return this;
        }

        public Builder align(int a0) {
            this.bldAlignment = a0;
            return this;
        }

        public Builder insets(Vector2 v0) {
            this.bldInsets = v0;
            return this;
        }

        public Builder opaque(boolean b0) {
            this.bldOpaque = b0;
            return this;
        }

        public Builder opaque() {
            this.opaque(true);
            return this;
        }

        public Builder selectable(boolean b0) {
            this.bldSelectable = b0;
            return this;
        }

        public Builder selectable() {
            this.selectable(true);
            return this;
        }

        public Builder selected(boolean b0) {
            this.bldSelected = b0;
            return this;
        }

        public Builder selected() {
            this.selected(true);
            return this;
        }

        public Builder command(FEvent.FEventHandler c0) {
            this.bldCommand = c0;
            return this;
        }

        public Builder font(FSkinFont f0) {
            this.bldFont = f0;
            return this;
        }

        public Builder alphaComposite(float a0) {
            this.bldAlphaComposite = a0;
            return this;
        }

        public Builder enabled(boolean b0) {
            this.bldEnabled = b0;
            return this;
        }

        public Builder iconScaleAuto(boolean b0) {
            this.bldIconScaleAuto = b0;
            return this;
        }

        public Builder iconScaleWithFont(boolean b0) {
            this.bldIconScaleWithFont = b0;
            return this;
        }

        public Builder iconScaleFactor(float f0) {
            this.bldIconScaleFactor = f0;
            return this;
        }

        public Builder iconInBackground(boolean b0) {
            this.bldIconInBackground = b0;
            return this;
        }

        public Builder iconInBackground() {
            this.iconInBackground(true);
            return this;
        }

        public Builder textColor(FSkinColor c0) {
            this.bldTextColor = c0;
            return this;
        }

        public Builder pressedColor(FSkinColor c0) {
            this.bldPressedColor = c0;
            return this;
        }

        public Builder parseSymbols() {
            this.parseSymbols(true);
            return this;
        }

        public Builder parseSymbols(boolean b0) {
            this.bldParseSymbols = b0;
            return this;
        }
    }
}

