/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.toolbox.FContainer;
import forge.util.Utils;

public abstract class FGroupBox
extends FContainer {
    private static final FSkinFont FONT = FSkinFont.get(16);
    private static final float PADDING = Utils.scale(5.0f);
    private static final float BORDER_THICKNESS = Utils.scale(1.0f);
    private final String caption;

    private static FSkinColor getForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    public FGroupBox(String caption0) {
        this.caption = caption0;
    }

    @Override
    protected void drawOverlay(Graphics g2) {
        float w = this.getWidth();
        float h2 = this.getHeight();
        float x = 2.0f * PADDING;
        float y = FONT.getCapHeight() / 2.0f;
        g2.drawLine(BORDER_THICKNESS, FGroupBox.getForeColor(), 0.0f, y, 0.0f, h2);
        g2.drawLine(BORDER_THICKNESS, FGroupBox.getForeColor(), 0.0f, h2, w, h2);
        g2.drawLine(BORDER_THICKNESS, FGroupBox.getForeColor(), w, h2, w, y);
        g2.drawText(this.caption, FONT, FGroupBox.getForeColor(), x, 0.0f, w - x - PADDING, h2, false, 8, false);
        g2.drawLine(BORDER_THICKNESS, FGroupBox.getForeColor(), 0.0f, y, x, y);
        float captionEnd = x + FGroupBox.FONT.getBounds((CharSequence)this.caption).width;
        if (captionEnd < w) {
            g2.drawLine(BORDER_THICKNESS, FGroupBox.getForeColor(), captionEnd, y, w, y);
        }
    }

    @Override
    protected void doLayout(float width, float height) {
        float captionHeight = FONT.getLineHeight();
        this.layoutBox(PADDING, captionHeight + PADDING, this.getWidth() - 2.0f * PADDING, this.getHeight() - captionHeight - 2.0f * PADDING);
    }

    protected abstract void layoutBox(float var1, float var2, float var3, float var4);
}

