/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.menu.FMenuItem;
import forge.menu.FPopupMenu;
import forge.toolbox.FChoiceList;
import forge.toolbox.FDialog;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FList;
import forge.toolbox.FOptionPane;
import forge.toolbox.FTextField;
import forge.util.Callback;
import forge.util.FileUtil;
import forge.util.Utils;
import java.io.File;
import java.io.FilenameFilter;
import org.apache.commons.lang3.StringUtils;

public class FFileChooser
extends FDialog {
    private static final float BACK_ICON_THICKNESS = Utils.scale(2.0f);
    private final ChoiceType choiceType;
    private final String baseDir;
    private final Callback<String> callback;
    private final FList<File> lstFiles = this.add(new FileList());
    private final FTextField txtFilename = this.add(new FilenameField());

    public static void show(String title0, ChoiceType choiceType0, Callback<String> callback0) {
        FFileChooser.show(title0, choiceType0, "", "", callback0);
    }

    public static void show(String title0, ChoiceType choiceType0, String defaultFilename0, Callback<String> callback0) {
        FFileChooser.show(title0, choiceType0, defaultFilename0, "", callback0);
    }

    public static void show(String title0, ChoiceType choiceType0, String defaultFilename0, String baseDir0, Callback<String> callback0) {
        FFileChooser dialog = new FFileChooser(title0, choiceType0, defaultFilename0, baseDir0, callback0);
        dialog.show();
    }

    private FFileChooser(String title0, ChoiceType choiceType0, String defaultFilename0, String baseDir0, Callback<String> callback0) {
        super(title0, 3);
        this.choiceType = choiceType0;
        if (this.choiceType == ChoiceType.GetDirectory && defaultFilename0.endsWith(File.separator)) {
            defaultFilename0 = defaultFilename0.substring(0, defaultFilename0.length() - 1);
        }
        this.txtFilename.setFont(FSkinFont.get(12));
        this.txtFilename.setText(defaultFilename0);
        this.txtFilename.setChangedHandler(e -> this.refreshFileList());
        this.initButton(0, Forge.getLocalizer().getMessage("lblOK", new Object[0]), e -> this.activateSelectedFile(true));
        this.initButton(1, Forge.getLocalizer().getMessage("lblNewFolder", new Object[0]), e -> {
            final File dir = this.getCurrentDir();
            if (dir == null) {
                FOptionPane.showErrorDialog(Forge.getLocalizer().getMessage("lblCannotAddNewFolderToInvaildFolder", new Object[0]), Forge.getLocalizer().getMessage("lblInvalidFolder", new Object[0]));
                return;
            }
            FOptionPane.showInputDialog(Forge.getLocalizer().getMessage("lblEnterNewFolderName", new Object[0]), new Callback<String>(){

                @Override
                public void run(String result) {
                    if (StringUtils.isEmpty(result)) {
                        return;
                    }
                    try {
                        File newDir = new File(dir, result);
                        if (newDir.mkdirs()) {
                            FFileChooser.this.txtFilename.setText(newDir.getAbsolutePath());
                            FFileChooser.this.refreshFileList();
                            return;
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    FOptionPane.showErrorDialog(Forge.getLocalizer().getMessage("lblEnterFolderNameNotValid", result), Forge.getLocalizer().getMessage("lblInvalidName", new Object[0]));
                }
            });
        });
        this.initButton(2, Forge.getLocalizer().getMessage("lblCancel", new Object[0]), e -> this.hide());
        this.baseDir = baseDir0;
        this.callback = callback0;
        this.refreshFileList();
    }

    @Override
    protected float layoutAndGetHeight(float width, float maxHeight) {
        float padding = FOptionPane.PADDING;
        float w = width - 2.0f * padding;
        float fieldHeight = this.txtFilename.getHeight();
        float listHeight = maxHeight - fieldHeight - 2.0f * padding;
        float x = padding;
        float y = padding;
        this.txtFilename.setBounds(x, y, w, fieldHeight);
        this.lstFiles.setBounds(x, y += fieldHeight + padding, w, listHeight);
        return maxHeight;
    }

    private File getCurrentDir() {
        int idx;
        String filename = this.getSelectedFilename();
        File dir = new File(filename);
        if (!(dir.exists() && dir.isDirectory() || (idx = filename.lastIndexOf(File.separatorChar)) == -1)) {
            dir = new File(filename.substring(0, idx));
        }
        if (dir.exists() && dir.isDirectory()) {
            if (this.choiceType == ChoiceType.GetDirectory) {
                dir = dir.getParentFile();
            }
            return dir;
        }
        return null;
    }

    private void refreshFileList() {
        File dir = this.getCurrentDir();
        if (dir != null) {
            this.setFileListForDir(dir);
        } else {
            this.lstFiles.setListData((File[])File.listRoots());
        }
        this.scrollSelectionIntoView();
    }

    private void setFileListForDir(File dir) {
        FilenameFilter filter = null;
        if (this.choiceType == ChoiceType.GetDirectory) {
            filter = (dir1, name) -> new File(dir1, name).isDirectory();
        }
        this.lstFiles.setListData((File[])dir.listFiles(filter));
    }

    private void scrollSelectionIntoView() {
        String filename = this.getSelectedFilename();
        for (int i = 0; i < this.lstFiles.getCount(); ++i) {
            if (!this.lstFiles.getItemAt(i).getAbsolutePath().equals(filename)) continue;
            this.lstFiles.scrollIntoView(i);
            return;
        }
    }

    private String getSelectedFilename() {
        return this.baseDir + this.txtFilename.getText();
    }

    private void activateSelectedFile(boolean fromOkButton) {
        boolean returnDirectory;
        String filename = this.getSelectedFilename();
        File file = new File(filename);
        boolean bl = returnDirectory = this.choiceType == ChoiceType.GetDirectory;
        if (file.exists() && file.isDirectory() && (!fromOkButton || !returnDirectory)) {
            this.setFileListForDir(file);
            if (this.lstFiles.getCount() > 0) {
                this.txtFilename.setText(this.lstFiles.getItemAt(0).getAbsolutePath());
            } else {
                this.txtFilename.setText(file.getAbsolutePath() + File.separator);
            }
            this.scrollSelectionIntoView();
            return;
        }
        if (returnDirectory) {
            if (!file.exists() || !file.isDirectory()) {
                FOptionPane.showErrorDialog(Forge.getLocalizer().getMessage("lblNoFolderExistsWithSelectPath", new Object[0]), Forge.getLocalizer().getMessage("lblInvalidFolder", new Object[0]));
                return;
            }
        } else if (!file.exists() && this.choiceType == ChoiceType.OpenFile || file.isDirectory()) {
            FOptionPane.showErrorDialog(Forge.getLocalizer().getMessage("lblNoFileExistsWithSelectPath", new Object[0]), Forge.getLocalizer().getMessage("lblInvalidFile", new Object[0]));
            return;
        }
        this.hide();
        if (returnDirectory) {
            filename = filename + File.separator;
        }
        this.callback.run(filename);
    }

    private void back() {
        int idx = this.txtFilename.getText().lastIndexOf(File.separatorChar);
        if (idx != -1) {
            this.txtFilename.setText(this.txtFilename.getText().substring(0, idx));
            this.refreshFileList();
        }
    }

    private void renameFile(final File file) {
        final File dir = file.getParentFile();
        if (dir == null) {
            FOptionPane.showErrorDialog(Forge.getLocalizer().getMessage("lblCannotRenameFileInInvalidFolder", new Object[0]), Forge.getLocalizer().getMessage("lblInvalidFolder", new Object[0]));
            return;
        }
        String title = file.isDirectory() ? Forge.getLocalizer().getMessage("lblEnterNewNameForFolder", new Object[0]) : Forge.getLocalizer().getMessage("lblEnterNewNameForFile", new Object[0]);
        FOptionPane.showInputDialog(title, file.getName(), new Callback<String>(){

            @Override
            public void run(String result) {
                if (StringUtils.isEmpty(result)) {
                    return;
                }
                try {
                    File newFile = new File(dir, result);
                    if (file.renameTo(newFile)) {
                        FFileChooser.this.txtFilename.setText(newFile.getAbsolutePath());
                        FFileChooser.this.refreshFileList();
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                FOptionPane.showErrorDialog(Forge.getLocalizer().getMessage("lblEnterNameNotValid", result), Forge.getLocalizer().getMessage("lblInvalidName", new Object[0]));
            }
        });
    }

    private void deleteFile(final Integer index, final File file) {
        String deleteBehavior = file.isDirectory() ? Forge.getLocalizer().getMessage("lblDeleteFolder", new Object[0]) : Forge.getLocalizer().getMessage("lblDeleteFile", new Object[0]);
        FOptionPane.showConfirmDialog(Forge.getLocalizer().getMessage("lblAreYouSureProceedDelete", new Object[0]), deleteBehavior, Forge.getLocalizer().getMessage("lblDelete", new Object[0]), Forge.getLocalizer().getMessage("lblCancel", new Object[0]), new Callback<Boolean>(){

            @Override
            public void run(Boolean result) {
                if (result.booleanValue()) {
                    try {
                        if (FileUtil.deleteDirectory(file)) {
                            FFileChooser.this.lstFiles.removeItem(file);
                            if (FFileChooser.this.lstFiles.getCount() > index) {
                                FFileChooser.this.txtFilename.setText(((File)FFileChooser.this.lstFiles.getItemAt(index)).getAbsolutePath());
                            } else if (FFileChooser.this.lstFiles.getCount() > 0) {
                                FFileChooser.this.txtFilename.setText(((File)FFileChooser.this.lstFiles.getItemAt(FFileChooser.this.lstFiles.getCount() - 1)).getAbsolutePath());
                            } else {
                                File dir = FFileChooser.this.getCurrentDir();
                                if (dir != null) {
                                    FFileChooser.this.txtFilename.setText(dir.getAbsolutePath() + File.separator);
                                }
                            }
                            return;
                        }
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    FOptionPane.showErrorDialog(Forge.getLocalizer().getMessage("lblCouldBotDeleteFile", new Object[0]));
                }
            }
        });
    }

    @Override
    public boolean keyDown(int keyCode) {
        switch (keyCode) {
            case 66: {
                this.activateSelectedFile(false);
                return true;
            }
            case 111: {
                if (!Forge.endKeyInput()) break;
                return true;
            }
            case 4: 
            case 67: {
                this.back();
                return true;
            }
        }
        return super.keyDown(keyCode);
    }

    private class FileList
    extends FList<File> {
        private FileList() {
            this.setListItemRenderer(new FList.ListItemRenderer<File>(){
                private int prevTapIndex = -1;

                @Override
                public float getItemHeight() {
                    return FChoiceList.DEFAULT_ITEM_HEIGHT;
                }

                @Override
                public boolean tap(Integer index, File value, float x, float y, int count) {
                    if (count == 2 && index == this.prevTapIndex) {
                        FFileChooser.this.activateSelectedFile(false);
                        return true;
                    }
                    FFileChooser.this.txtFilename.setText(value.getAbsolutePath());
                    this.prevTapIndex = index;
                    if (value.isDirectory() && x < this.getItemHeight() + 2.0f * FList.PADDING) {
                        FFileChooser.this.activateSelectedFile(false);
                    }
                    return true;
                }

                @Override
                public boolean showMenu(final Integer index, final File value, FDisplayObject owner, float x, float y) {
                    FFileChooser.this.txtFilename.setText(value.getAbsolutePath());
                    FPopupMenu menu = new FPopupMenu(){

                        @Override
                        protected void buildMenu() {
                            String renameBehavior = value.isDirectory() ? Forge.getLocalizer().getMessage("lblRenameFolder", new Object[0]) : Forge.getLocalizer().getMessage("lblRenameFile", new Object[0]);
                            String deleteBehavior = value.isDirectory() ? Forge.getLocalizer().getMessage("lblDeleteFolder", new Object[0]) : Forge.getLocalizer().getMessage("lblDeleteFile", new Object[0]);
                            this.addItem(new FMenuItem(renameBehavior, Forge.hdbuttons ? FSkinImage.HDEDIT : FSkinImage.EDIT, e -> FFileChooser.this.renameFile(value)));
                            this.addItem(new FMenuItem(deleteBehavior, Forge.hdbuttons ? FSkinImage.HDEDIT : FSkinImage.EDIT, e -> FFileChooser.this.deleteFile(index, value)));
                        }
                    };
                    menu.show(owner, x, y);
                    return true;
                }

                @Override
                public void drawValue(Graphics g2, Integer index, File value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
                    if (value.isDirectory()) {
                        float iconSize = h2;
                        g2.drawImage(Forge.hdbuttons ? FSkinImage.HDFOLDER : FSkinImage.FOLDER, x, y + (h2 - iconSize) / 2.0f, iconSize, iconSize);
                        x += iconSize + FList.PADDING;
                    }
                    g2.drawText(value.getName(), font, foreColor, x, y, w, h2, false, 8, true);
                }
            });
        }

        @Override
        protected void drawBackground(Graphics g2) {
        }

        @Override
        public void drawOverlay(Graphics g2) {
            super.drawOverlay(g2);
            g2.drawRect(1.5f, FChoiceList.getBorderColor(), 0.0f, 0.0f, this.getWidth(), this.getHeight());
        }

        @Override
        protected FSkinColor getItemFillColor(int index) {
            if (((File)this.getItemAt(index)).getAbsolutePath().equals(FFileChooser.this.getSelectedFilename())) {
                return FChoiceList.getSelColor();
            }
            if (index % 2 == 1) {
                return FChoiceList.getAltItemColor();
            }
            return FChoiceList.getItemColor();
        }

        @Override
        protected boolean drawLineSeparators() {
            return false;
        }
    }

    private class FilenameField
    extends FTextField {
        private FilenameField() {
        }

        @Override
        public boolean tap(float x, float y, int count) {
            if (x < this.getLeftPadding()) {
                FFileChooser.this.back();
                return true;
            }
            return super.tap(x, y, count);
        }

        @Override
        protected float getLeftPadding() {
            return this.getHeight();
        }

        @Override
        public void draw(Graphics g2) {
            float w;
            super.draw(g2);
            float h2 = w = this.getHeight();
            float x = w * 0.35f;
            float y = h2 / 2.0f;
            float offsetX = w / 8.0f;
            float offsetY = h2 / 6.0f;
            g2.drawLine(BACK_ICON_THICKNESS, FilenameField.getForeColor(), x + offsetX, y - offsetY, x - offsetX, y);
            g2.drawLine(BACK_ICON_THICKNESS, FilenameField.getForeColor(), x - offsetX, y, x + offsetX, y + offsetY);
            g2.drawLine(BACK_ICON_THICKNESS, FilenameField.getForeColor(), (x += w * 0.3f) + offsetX, y - offsetY, x - offsetX, y);
            g2.drawLine(BACK_ICON_THICKNESS, FilenameField.getForeColor(), x - offsetX, y, x + offsetX, y + offsetY);
        }
    }

    public static enum ChoiceType {
        OpenFile,
        SaveFile,
        GetDirectory;

    }
}

