/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.badlogic.gdx.math.Rectangle;
import forge.Forge;
import forge.Graphics;
import forge.gui.GuiBase;
import forge.toolbox.FCardPanel;
import java.util.List;

public abstract class FDisplayObject {
    protected static final float DISABLED_COMPOSITE = 0.25f;
    private boolean visible = true;
    private boolean enabled = true;
    private boolean rotate90 = false;
    private boolean rotate180 = false;
    private boolean hovered = false;
    private final Rectangle bounds = new Rectangle();
    public final Rectangle screenPos = new Rectangle();

    public void setPosition(float x, float y) {
        this.bounds.setPosition(x, y);
    }

    public void setSize(float width, float height) {
        this.bounds.setSize(width, height);
    }

    public void setBounds(float x, float y, float width, float height) {
        this.bounds.set(x, y, width, height);
    }

    public float getLeft() {
        return this.bounds.x;
    }

    public void setLeft(float x) {
        this.bounds.x = x;
    }

    public float getRight() {
        return this.bounds.x + this.bounds.width;
    }

    public float getTop() {
        return this.bounds.y;
    }

    public void setTop(float y) {
        this.bounds.y = y;
    }

    public float getBottom() {
        return this.bounds.y + this.bounds.height;
    }

    public float getWidth() {
        return this.bounds.width;
    }

    public void setWidth(float width) {
        this.bounds.width = width;
    }

    public float getHeight() {
        return this.bounds.height;
    }

    public void setHeight(float height) {
        this.bounds.height = height;
    }

    public boolean contains(float x, float y) {
        return this.visible && this.bounds.contains(x, y);
    }

    public float screenToLocalX(float x) {
        return x - this.screenPos.x;
    }

    public float screenToLocalY(float y) {
        return y - this.screenPos.y;
    }

    public float localToScreenX(float x) {
        return x + this.screenPos.x;
    }

    public float localToScreenY(float y) {
        return y + this.screenPos.y;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean b0) {
        this.enabled = b0;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean b0) {
        this.visible = b0;
    }

    public boolean isHovered() {
        return this.hovered;
    }

    public void setHovered(boolean b0) {
        this.hovered = b0;
    }

    public boolean getRotate90() {
        return this.rotate90;
    }

    public void setRotate90(boolean b0) {
        this.rotate90 = b0;
    }

    public boolean getRotate180() {
        return this.rotate180;
    }

    public void setRotate180(boolean b0) {
        this.rotate180 = b0;
    }

    public String getToolTipText() {
        return null;
    }

    public void setToolTipText(String s0) {
    }

    protected boolean drawAboveOverlay() {
        return false;
    }

    protected void drawOnContainer(Graphics g2) {
    }

    public abstract void draw(Graphics var1);

    public void buildTouchListeners(float screenX, float screenY, List<FDisplayObject> listeners) {
        boolean exact;
        boolean bl = exact = !GuiBase.isAndroid() && this instanceof FCardPanel;
        if (this.enabled && this.visible && this.screenPos.contains(screenX, screenY)) {
            listeners.add(this);
        }
        if (Forge.afterDBloaded && !GuiBase.isAndroid()) {
            Forge.hoveredCount = listeners.size();
            if (Forge.getCurrentScreen() != null && !Forge.getCurrentScreen().toString().contains("Match")) {
                Forge.hoveredCount = 1;
            }
            if (exact) {
                this.setHovered(this.enabled && this.visible && ((FCardPanel)this).renderedCardContains(this.screenToLocalX(screenX), this.screenToLocalY(screenY)) && Forge.hoveredCount < 2);
            } else {
                this.setHovered(this.enabled && this.visible && this.screenPos.contains(screenX, screenY) && Forge.hoveredCount < 2);
            }
        }
    }

    public boolean press(float x, float y) {
        return false;
    }

    public boolean longPress(float x, float y) {
        return false;
    }

    public boolean release(float x, float y) {
        return false;
    }

    public boolean tap(float x, float y, int count) {
        return false;
    }

    public boolean flick(float x, float y) {
        return false;
    }

    public boolean fling(float velocityX, float velocityY) {
        return false;
    }

    public boolean flingStop(float x, float y) {
        return false;
    }

    public boolean pan(float x, float y, float deltaX, float deltaY, boolean moreVertical) {
        return false;
    }

    public boolean panStop(float x, float y) {
        return false;
    }

    public boolean zoom(float x, float y, float amount) {
        return false;
    }

    public boolean keyDown(int keyCode) {
        return false;
    }
}

