/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.badlogic.gdx.math.Vector2;
import forge.Forge;
import forge.Graphics;
import forge.animation.ForgeAnimation;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinTexture;
import forge.screens.FScreen;
import forge.screens.match.MatchController;
import forge.screens.match.views.VPrompt;
import forge.toolbox.FButton;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FOverlay;
import forge.util.PhysicsObject;
import forge.util.TextUtil;
import forge.util.Utils;

public abstract class FDialog
extends FOverlay {
    public static final FSkinFont MSG_FONT = FSkinFont.get(12);
    public static final float MSG_HEIGHT = MSG_FONT.getCapHeight() * 2.5f;
    protected static final float BORDER_THICKNESS = Utils.scale(1.0f);
    private static final float SWIPE_BAR_HEIGHT = Utils.scale(12.0f);
    private static int openDialogCount = 0;
    private final VPrompt prompt;
    private final FButton btnMiddle;
    private final String title;
    private final int buttonCount;
    private float totalHeight;
    private float revealPercent = 0.0f;
    private float lastDy = 0.0f;
    private boolean finishedFirstReveal;
    private RevealAnimation activeRevealAnimation;

    public static FSkinColor getMsgForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT).alphaColor(0.9f);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT).alphaColor(0.9f);
    }

    public static FSkinColor getMsgBackColor() {
        return FScreen.Header.getBackColor().alphaColor(0.75f);
    }

    protected static FSkinColor getBorderColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_BORDERS).alphaColor(0.8f);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_BORDERS).alphaColor(0.8f);
    }

    private static FSkinColor getSwipeBarColor() {
        return FScreen.Header.getBackColor();
    }

    private static FSkinColor getSwipeBarDotColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT).alphaColor(0.75f);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT).alphaColor(0.75f);
    }

    public static boolean isDialogOpen() {
        return openDialogCount > 0;
    }

    protected FDialog(String title0, int buttonCount0) {
        this.buttonCount = buttonCount0;
        this.prompt = this.add(new VPrompt("", "", null, null));
        if (this.buttonCount < 3) {
            title0 = TextUtil.fastReplace(title0, " - ", "\n");
            this.btnMiddle = null;
            this.prompt.setMessage(title0);
        } else {
            this.btnMiddle = this.prompt.add(new FButton());
            this.btnMiddle.setCorner(FButton.Corner.BottomMiddle);
            this.btnMiddle.setSize(VPrompt.BTN_WIDTH, VPrompt.HEIGHT);
            this.btnMiddle.setEnabled(false);
        }
        this.title = title0;
    }

    protected float getBottomMargin() {
        return 0.0f;
    }

    @Override
    protected final void doLayout(float width, float height) {
        boolean firstReveal = this.totalHeight == 0.0f;
        float contentHeight = this.layoutAndGetHeight(width, height - VPrompt.HEIGHT - 2.0f * MSG_HEIGHT);
        this.totalHeight = contentHeight + VPrompt.HEIGHT;
        this.lastDy = 0.0f;
        if (this.btnMiddle != null) {
            this.btnMiddle.setLeft((width - this.btnMiddle.getWidth()) / 2.0f);
            if (!this.title.isEmpty()) {
                this.totalHeight += MSG_HEIGHT;
            }
        }
        this.prompt.setBounds(0.0f, this.totalHeight - VPrompt.HEIGHT, width, VPrompt.HEIGHT);
        this.updateDisplayTop();
        if (firstReveal) {
            this.updateRevealAnimation(3 * Forge.getScreenHeight());
        }
    }

    private void updateDisplayTop() {
        float offsetDy = this.lastDy;
        this.lastDy = this.getHeight() - (this.totalHeight + this.getBottomMargin()) * this.revealPercent;
        float dy = this.lastDy - offsetDy;
        for (FDisplayObject child : this.getChildren()) {
            child.setTop(child.getTop() + dy);
        }
    }

    @Override
    public void setVisible(boolean visible0) {
        if (this.isVisible() == visible0) {
            return;
        }
        if (visible0) {
            ++openDialogCount;
            MatchController.instance.cancelAwaitNextInput();
        } else if (openDialogCount > 0) {
            --openDialogCount;
        }
        super.setVisible(visible0);
    }

    protected abstract float layoutAndGetHeight(float var1, float var2);

    protected void initButton(int index, String text, FEvent.FEventHandler command) {
        FButton button = this.getButton(index);
        if (button == null) {
            return;
        }
        button.setText(text);
        button.setCommand(command);
        button.setEnabled(true);
        if (button == this.btnMiddle) {
            button.setWidth(button.getAutoSizeBounds().width * 1.25f);
        }
    }

    protected FButton getButton(int index) {
        if (index >= this.buttonCount) {
            return null;
        }
        switch (index) {
            case 0: {
                return this.prompt.getBtnOk();
            }
            case 1: {
                if (this.buttonCount == 2) {
                    return this.prompt.getBtnCancel();
                }
                return this.btnMiddle;
            }
            case 2: {
                return this.prompt.getBtnCancel();
            }
        }
        return null;
    }

    public boolean isButtonEnabled(int index) {
        FButton button = this.getButton(index);
        return button != null && button.isEnabled();
    }

    public void setButtonEnabled(int index, boolean enabled) {
        FButton button = this.getButton(index);
        if (button != null) {
            button.setEnabled(enabled);
        }
    }

    @Override
    public boolean preventInputBehindOverlay() {
        return this.revealPercent > 0.0f;
    }

    @Override
    public boolean pan(float x, float y, float deltaX, float deltaY, boolean moreVertical) {
        return this.preventInputBehindOverlay();
    }

    @Override
    public boolean panStop(float x, float y) {
        return this.preventInputBehindOverlay();
    }

    @Override
    public boolean zoom(float x, float y, float amount) {
        return this.preventInputBehindOverlay();
    }

    @Override
    public boolean longPress(float x, float y) {
        return false;
    }

    @Override
    protected void drawBackground(Graphics g2) {
        super.drawBackground(g2);
        if (this.revealPercent == 0.0f) {
            return;
        }
        float x = 0.0f;
        float y = this.getHeight() - (this.totalHeight + this.getBottomMargin()) * this.revealPercent;
        float w = this.getWidth();
        float h2 = this.totalHeight - VPrompt.HEIGHT;
        g2.drawImage(Forge.isMobileAdventureMode ? FSkinTexture.ADV_BG_TEXTURE : FSkinTexture.BG_TEXTURE, x, y, w, h2);
        g2.fillRect(FScreen.getTextureOverlayColor(), x, y, w, h2);
    }

    @Override
    public void drawOverlay(Graphics g2) {
        int i;
        float startX;
        float dx = SWIPE_BAR_HEIGHT * 0.7f;
        float x = startX = dx * 0.7f;
        float y = this.getHeight() - (this.totalHeight + this.getBottomMargin()) * this.revealPercent - SWIPE_BAR_HEIGHT;
        float w = this.getWidth();
        float dotRadius = SWIPE_BAR_HEIGHT / 6.0f;
        float dotTop = y + SWIPE_BAR_HEIGHT / 2.0f;
        int dotCount = 3;
        g2.fillRect(FDialog.getSwipeBarColor(), 0.0f, y, w, SWIPE_BAR_HEIGHT);
        for (i = 0; i < dotCount; ++i) {
            g2.fillCircle(FDialog.getSwipeBarDotColor(), x, dotTop, dotRadius);
            x += dx;
        }
        x = w - startX;
        for (i = 0; i < dotCount; ++i) {
            g2.fillCircle(FDialog.getBorderColor(), x, dotTop, dotRadius);
            x -= dx;
        }
        g2.drawLine(BORDER_THICKNESS, FDialog.getBorderColor(), 0.0f, y, w, y);
        if (this.revealPercent == 0.0f) {
            return;
        }
        g2.drawLine(BORDER_THICKNESS, FDialog.getBorderColor(), 0.0f, y += SWIPE_BAR_HEIGHT, w, y);
        y = this.prompt.getTop();
        if (this.btnMiddle != null && !this.title.isEmpty()) {
            g2.fillRect(VPrompt.getBackColor(), 0.0f, y -= MSG_HEIGHT, w, MSG_HEIGHT);
            g2.drawText(this.title, VPrompt.FONT, VPrompt.getForeColor(), 0.0f, y, w, MSG_HEIGHT, false, 1, true);
        }
        g2.drawLine(BORDER_THICKNESS, FDialog.getBorderColor(), 0.0f, y, w, y);
    }

    @Override
    public boolean fling(float velocityX, float velocityY) {
        if (!this.finishedFirstReveal) {
            return false;
        }
        if (Math.abs(velocityY) > Math.abs(velocityX)) {
            if (this.revealPercent > 0.0f == (velocityY = -velocityY) > 0.0f) {
                return false;
            }
            this.updateRevealAnimation(velocityY);
            return true;
        }
        return false;
    }

    private void updateRevealAnimation(float velocity) {
        if (this.activeRevealAnimation == null) {
            this.activeRevealAnimation = new RevealAnimation(velocity);
            this.activeRevealAnimation.start();
        } else {
            this.activeRevealAnimation.physicsObj.getVelocity().set(0.0f, velocity);
        }
    }

    protected void onRevealFinished() {
    }

    private class RevealAnimation
    extends ForgeAnimation {
        private final PhysicsObject physicsObj;

        private RevealAnimation(float velocity) {
            this.physicsObj = new PhysicsObject(new Vector2(0.0f, (FDialog.this.totalHeight + FDialog.this.getBottomMargin()) * FDialog.this.revealPercent), new Vector2(0.0f, velocity));
        }

        @Override
        protected boolean advance(float dt) {
            if (this.physicsObj.isMoving()) {
                this.physicsObj.advance(dt);
                float newRevealPercent = this.physicsObj.getPosition().y / (FDialog.this.totalHeight + FDialog.this.getBottomMargin());
                if (newRevealPercent < 0.0f) {
                    newRevealPercent = 0.0f;
                } else if (newRevealPercent > 1.0f) {
                    newRevealPercent = 1.0f;
                }
                if (FDialog.this.revealPercent != newRevealPercent) {
                    FDialog.this.revealPercent = newRevealPercent;
                    FDialog.this.updateDisplayTop();
                    return this.physicsObj.isMoving();
                }
            }
            return false;
        }

        @Override
        protected void onEnd(boolean endingAll) {
            FDialog.this.activeRevealAnimation = null;
            if (!FDialog.this.finishedFirstReveal) {
                FDialog.this.finishedFirstReveal = true;
                FDialog.this.onRevealFinished();
            }
        }
    }
}

