/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import forge.Forge;
import forge.Graphics;
import forge.assets.FSkin;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.TextRenderer;
import forge.card.CardFaceSymbols;
import forge.card.CardRenderer;
import forge.card.CardZoom;
import forge.card.mana.ManaCost;
import forge.card.mana.ManaCostParser;
import forge.game.card.CardView;
import forge.game.card.IHasCardView;
import forge.game.player.PlayerView;
import forge.item.InventoryItem;
import forge.item.PaperCard;
import forge.itemmanager.AdvancedSearch;
import forge.itemmanager.CardManager;
import forge.itemmanager.filters.AdvancedSearchFilter;
import forge.itemmanager.filters.ItemFilter;
import forge.localinstance.skin.FSkinProp;
import forge.localinstance.skin.IHasSkinProp;
import forge.screens.match.MatchController;
import forge.screens.match.views.VAvatar;
import forge.screens.match.views.VStack;
import forge.toolbox.FCheckBox;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FList;
import forge.toolbox.ListChooser;
import forge.util.TextUtil;
import forge.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class FChoiceList<T>
extends FList<T>
implements CardZoom.ActivateHandler {
    public static final float DEFAULT_ITEM_HEIGHT = Utils.AVG_FINGER_HEIGHT * 0.75f;
    protected final int minChoices;
    protected final int maxChoices;
    private final FList.CompactModeHandler compactModeHandler = new FList.CompactModeHandler();
    private final List<Integer> selectedIndices = new ArrayList<Integer>();

    public static FSkinColor getItemColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_ZEBRA);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_ZEBRA);
    }

    public static FSkinColor getAltItemColor() {
        return FChoiceList.getItemColor().getContrastColor(-20);
    }

    public static FSkinColor getSelColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_ACTIVE);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_ACTIVE);
    }

    public static FSkinColor getBorderColor() {
        return FList.getForeColor();
    }

    public FChoiceList(Iterable<? extends T> items) {
        this(items, null);
    }

    protected FChoiceList(Iterable<? extends T> items, T typeItem) {
        this(items, 0, 1, typeItem);
        if (this.getCount() > 0) {
            this.addSelectedIndex(0);
        }
    }

    public FChoiceList(Iterable<? extends T> items, int minChoices0, int maxChoices0) {
        this(items, minChoices0, maxChoices0, null);
    }

    protected FChoiceList(Iterable<? extends T> items, int minChoices0, int maxChoices0, T typeItem) {
        super(items);
        T item;
        this.minChoices = minChoices0;
        this.maxChoices = maxChoices0;
        T t2 = item = typeItem == null ? this.getItemAt(0) : typeItem;
        final ItemRenderer renderer = item instanceof PaperCard ? new PaperCardItemRenderer() : (item instanceof CardView ? new CardItemRenderer() : (item instanceof IHasCardView ? new IHasCardViewItemRenderer() : (item instanceof PlayerView ? new PlayerItemRenderer() : (item instanceof Integer || item == AdvancedSearch.FilterOperator.EQUALS ? new NumberRenderer() : (item instanceof IHasSkinProp ? new IHasSkinPropRenderer() : new DefaultItemRenderer())))));
        this.setListItemRenderer(new FList.ListItemRenderer<T>(){
            private int prevTapIndex = -1;

            @Override
            public float getItemHeight() {
                return renderer.getItemHeight();
            }

            @Override
            public boolean layoutHorizontal() {
                return renderer.layoutHorizontal();
            }

            @Override
            public AdvancedSearchFilter<? extends InventoryItem> getAdvancedSearchFilter(ListChooser<T> listChooser) {
                return renderer.getAdvancedSearchFilter(listChooser);
            }

            @Override
            public boolean tap(Integer index, T value, float x, float y, int count) {
                boolean activate;
                boolean bl = activate = count == 2 && index == this.prevTapIndex;
                if (FChoiceList.this.maxChoices > 1) {
                    if (FChoiceList.this.selectedIndices.contains(index)) {
                        if (!activate) {
                            FChoiceList.this.selectedIndices.remove(index);
                            FChoiceList.this.onSelectionChange();
                        }
                    } else if (FChoiceList.this.selectedIndices.size() < FChoiceList.this.maxChoices) {
                        FChoiceList.this.selectedIndices.add(index);
                        Collections.sort(FChoiceList.this.selectedIndices);
                        FChoiceList.this.onSelectionChange();
                    }
                } else if (FChoiceList.this.maxChoices > 0) {
                    FChoiceList.this.selectedIndices.clear();
                    FChoiceList.this.selectedIndices.add(index);
                    FChoiceList.this.onSelectionChange();
                }
                if (renderer.tap(index, value, x, y, count)) {
                    activate = false;
                }
                if (activate) {
                    FChoiceList.this.onItemActivate(index, value);
                }
                this.prevTapIndex = index;
                return true;
            }

            @Override
            public boolean showMenu(Integer index, T value, FDisplayObject owner, float x, float y) {
                return renderer.longPress(index, value, x, y);
            }

            @Override
            public void drawValue(Graphics g2, Integer index, T value, FSkinFont font, FSkinColor foreColor, FSkinColor backColor, boolean pressed, float x, float y, float w, float h2) {
                if (FChoiceList.this.maxChoices > 1) {
                    if (pressed) {
                        g2.fillRect(FChoiceList.getSelColor(), x - FList.PADDING, y - FList.PADDING, w + 2.0f * FList.PADDING, h2 + 2.0f * FList.PADDING);
                    }
                    float checkBoxSize = h2 / 2.0f;
                    float padding = checkBoxSize / 2.0f;
                    FCheckBox.drawCheckBox(g2, FChoiceList.this.selectedIndices.contains(index), x + (w -= checkBoxSize + padding), y + padding, checkBoxSize, checkBoxSize);
                    w -= padding;
                }
                renderer.drawValue(g2, value, font, foreColor, pressed, x, y, w, h2);
            }
        });
        this.setFont(renderer.getDefaultFont());
    }

    public int getMinChoices() {
        return this.minChoices;
    }

    public int getMaxChoices() {
        return this.maxChoices;
    }

    public T getSelectedItem() {
        if (this.selectedIndices.size() > 0) {
            return this.getItemAt(this.selectedIndices.get(0));
        }
        return null;
    }

    public List<T> getSelectedItems() {
        ArrayList choices = new ArrayList();
        for (int i : this.selectedIndices) {
            choices.add(this.getItemAt(i));
        }
        return choices;
    }

    public int getSelectedIndex() {
        if (this.selectedIndices.size() > 0) {
            return this.selectedIndices.get(0);
        }
        return -1;
    }

    public Iterable<Integer> getSelectedIndices() {
        return this.selectedIndices;
    }

    public int getSelectionCount() {
        return this.selectedIndices.size();
    }

    @Override
    public void clear() {
        super.clear();
        this.clearSelection();
    }

    public void clearSelection() {
        this.selectedIndices.clear();
        this.onSelectionChange();
    }

    public void cleanUpSelections() {
        int count = this.getCount();
        for (int i = 0; i < this.selectedIndices.size(); ++i) {
            if (this.selectedIndices.get(i) < count) continue;
            this.selectedIndices.remove(i);
            --i;
        }
        if (this.selectedIndices.isEmpty() && count > 0) {
            this.selectedIndices.add(count - 1);
        }
        this.onSelectionChange();
    }

    public void addSelectedIndex(int index) {
        this.selectedIndices.add(index);
        this.onSelectionChange();
    }

    public void addSelectedItem(T choice) {
        this.addSelectedIndex(this.getIndexOf(choice));
    }

    @Override
    public void setSelectedIndex(int index) {
        this.selectedIndices.clear();
        this.selectedIndices.add(index);
        this.scrollIntoView(index);
        this.onSelectionChange();
    }

    public void setSelectedItem(T choice) {
        this.setSelectedIndex(this.getIndexOf(choice));
    }

    protected String getChoiceText(T choice) {
        return choice.toString();
    }

    protected void onItemActivate(Integer index, T value) {
    }

    protected void onSelectionChange() {
    }

    protected void onCompactModeChange() {
        this.revalidate();
    }

    protected boolean allowDefaultItemWrap() {
        return false;
    }

    @Override
    public boolean zoom(float x, float y, float amount) {
        if (this.compactModeHandler.update(amount)) {
            this.onCompactModeChange();
            if (this.selectedIndices.size() > 0) {
                this.scrollIntoView(this.selectedIndices.get(0));
            }
        }
        return true;
    }

    @Override
    protected void drawBackground(Graphics g2) {
    }

    @Override
    public void drawOverlay(Graphics g2) {
        super.drawOverlay(g2);
        g2.drawRect(1.5f, FChoiceList.getBorderColor(), 0.0f, 0.0f, this.getWidth(), this.getHeight());
    }

    @Override
    protected FSkinColor getItemFillColor(int index) {
        if (this.maxChoices == 1 && this.selectedIndices.contains(index)) {
            return FChoiceList.getSelColor();
        }
        if (index % 2 == 1) {
            return FChoiceList.getAltItemColor();
        }
        return FChoiceList.getItemColor();
    }

    @Override
    protected boolean drawLineSeparators() {
        return false;
    }

    private boolean showAlternate(CardView cardView, String value) {
        if (cardView == null) {
            return false;
        }
        boolean showAlt = false;
        if (cardView.hasAlternateState()) {
            if (cardView.hasBackSide()) {
                showAlt = value.contains(cardView.getBackSideName()) || cardView.getAlternateState().getAbilityText().contains(value);
            } else if (cardView.isAdventureCard()) {
                showAlt = value.equals(cardView.getAlternateState().getAbilityText());
            } else if (cardView.isSplitCard()) {
                showAlt = cardView.getAlternateState().getOracleText().contains("Aftermath") ? cardView.getAlternateState().getOracleText().contains(value) : value.equals(cardView.getAlternateState().getAbilityText());
            }
        }
        return showAlt;
    }

    @Override
    public String getActivateAction(int index) {
        if (this.maxChoices > 0) {
            return "select card";
        }
        return null;
    }

    @Override
    public void activate(int index) {
        this.setSelectedIndex(index);
    }

    protected class IHasSkinPropRenderer
    extends DefaultItemRenderer {
        private final TextRenderer textRenderer;

        protected IHasSkinPropRenderer() {
            this.textRenderer = new TextRenderer(true);
        }

        @Override
        public void drawValue(Graphics g2, T value, FSkinFont font, FSkinColor foreColor, boolean pressed, float x, float y, float w, float h2) {
            FSkinProp skinProp = ((IHasSkinProp)value).getSkinProp();
            if (skinProp != null) {
                float iconSize = h2 * 0.8f;
                float offset = (h2 - iconSize) / 2.0f;
                g2.drawImage(FSkin.getImages().get((Object)skinProp), x + offset - 1.0f, y + offset, iconSize, iconSize);
                float dx = iconSize + FList.PADDING + 2.0f * offset - 1.0f;
                x += dx;
                w -= dx;
            }
            this.textRenderer.drawText(g2, value.toString(), font, foreColor, x, y, w, h2, y, h2, true, 8, true);
        }
    }

    protected class PlayerItemRenderer
    extends ItemRenderer {
        protected PlayerItemRenderer() {
        }

        @Override
        public FSkinFont getDefaultFont() {
            return FSkinFont.get(18);
        }

        @Override
        public float getItemHeight() {
            return VAvatar.HEIGHT;
        }

        @Override
        public boolean tap(Integer index, T value, float x, float y, int count) {
            return false;
        }

        @Override
        public boolean longPress(Integer index, T value, float x, float y) {
            return false;
        }

        @Override
        public void drawValue(Graphics g2, T value, FSkinFont font, FSkinColor foreColor, boolean pressed, float x, float y, float w, float h2) {
            PlayerView player = (PlayerView)value;
            g2.drawImage(MatchController.getPlayerAvatar(player), x - FList.PADDING, y - FList.PADDING, VAvatar.WIDTH, VAvatar.HEIGHT);
            g2.drawText(player.getName() + " (" + player.getLife() + ")", font, foreColor, x += VAvatar.WIDTH, y, w -= VAvatar.WIDTH, h2, false, 8, true);
        }
    }

    protected class IHasCardViewItemRenderer
    extends ItemRenderer {
        private final TextRenderer textRenderer;

        protected IHasCardViewItemRenderer() {
            this.textRenderer = new TextRenderer(true);
        }

        @Override
        public FSkinFont getDefaultFont() {
            return FSkinFont.get(14);
        }

        @Override
        public float getItemHeight() {
            return VStack.CARD_HEIGHT + 2.0f * FList.PADDING;
        }

        @Override
        public boolean tap(Integer index, T value, float x, float y, int count) {
            if (x <= VStack.CARD_WIDTH + 2.0f * FList.PADDING) {
                CardView cv = ((IHasCardView)value).getCardView();
                CardZoom.show(cv, FChoiceList.this.showAlternate(cv, value.toString()));
                return true;
            }
            return false;
        }

        @Override
        public boolean longPress(Integer index, T value, float x, float y) {
            CardView cv = ((IHasCardView)value).getCardView();
            CardZoom.show(cv, FChoiceList.this.showAlternate(cv, value.toString()));
            return true;
        }

        @Override
        public void drawValue(Graphics g2, T value, FSkinFont font, FSkinColor foreColor, boolean pressed, float x, float y, float w, float h2) {
            try {
                CardView cv = ((IHasCardView)value).getCardView();
                if (cv != null) {
                    boolean showAlternate = FChoiceList.this.showAlternate(cv, value.toString());
                    CardRenderer.drawCardWithOverlays(g2, cv, x, y, VStack.CARD_WIDTH, VStack.CARD_HEIGHT, CardRenderer.CardStackPosition.Top, false, showAlternate, true);
                }
            }
            catch (Exception cv) {
                // empty catch block
            }
            float dx = VStack.CARD_WIDTH + FList.PADDING;
            this.textRenderer.drawText(g2, value.toString(), font, foreColor, x += dx, y, w -= dx, h2, y, h2, true, 8, true);
        }
    }

    protected class CardItemRenderer
    extends ItemRenderer {
        protected CardItemRenderer() {
        }

        @Override
        public FSkinFont getDefaultFont() {
            return FSkinFont.get(14);
        }

        @Override
        public float getItemHeight() {
            return CardRenderer.getCardListItemHeight(FChoiceList.this.compactModeHandler.isCompactMode());
        }

        @Override
        public boolean tap(Integer index, T value, float x, float y, int count) {
            return CardRenderer.cardListItemTap(FChoiceList.this.items, index, FChoiceList.this, x, y, count, FChoiceList.this.compactModeHandler.isCompactMode());
        }

        @Override
        public boolean longPress(Integer index, T value, float x, float y) {
            CardZoom.show(FChoiceList.this.items, (int)index, (CardZoom.ActivateHandler)FChoiceList.this);
            return true;
        }

        @Override
        public void drawValue(Graphics g2, T value, FSkinFont font, FSkinColor foreColor, boolean pressed, float x, float y, float w, float h2) {
            CardRenderer.drawCardListItem(g2, font, foreColor, (CardView)value, 0, null, x, y, w, h2, FChoiceList.this.compactModeHandler.isCompactMode());
        }
    }

    protected class PaperCardItemRenderer
    extends ItemRenderer {
        protected PaperCardItemRenderer() {
        }

        @Override
        public FSkinFont getDefaultFont() {
            return FSkinFont.get(14);
        }

        @Override
        public float getItemHeight() {
            return CardRenderer.getCardListItemHeight(FChoiceList.this.compactModeHandler.isCompactMode());
        }

        @Override
        public boolean tap(Integer index, T value, float x, float y, int count) {
            return CardRenderer.cardListItemTap(FChoiceList.this.items, index, FChoiceList.this, x, y, count, FChoiceList.this.compactModeHandler.isCompactMode());
        }

        @Override
        public boolean longPress(Integer index, T value, float x, float y) {
            CardZoom.show(FChoiceList.this.items, (int)index, (CardZoom.ActivateHandler)FChoiceList.this);
            return true;
        }

        @Override
        public void drawValue(Graphics g2, T value, FSkinFont font, FSkinColor foreColor, boolean pressed, float x, float y, float w, float h2) {
            CardRenderer.drawCardListItem(g2, font, foreColor, (PaperCard)value, 0, null, x, y, w, h2, FChoiceList.this.compactModeHandler.isCompactMode());
        }

        @Override
        public AdvancedSearchFilter<? extends InventoryItem> getAdvancedSearchFilter(final ListChooser<T> listChooser) {
            CardManager manager = new CardManager(true){

                @Override
                public void applyNewOrModifiedFilter(ItemFilter<? extends PaperCard> filter) {
                    boolean empty = filter.isEmpty();
                    ItemFilter.Widget widget = filter.getWidget();
                    if (widget.isVisible() == empty) {
                        widget.setVisible(!empty);
                        listChooser.revalidate();
                    }
                    listChooser.applyFilters();
                }

                @Override
                protected void addDefaultFilters() {
                }
            };
            return CardManager.createAdvancedSearchFilter(manager);
        }
    }

    protected class NumberRenderer
    extends DefaultItemRenderer {
        protected NumberRenderer() {
        }

        @Override
        public FSkinFont getDefaultFont() {
            return FSkinFont.get(14);
        }

        @Override
        public float getItemHeight() {
            float width = Utils.AVG_FINGER_WIDTH;
            int itemCount = FChoiceList.this.getCount();
            float totalWidth = width * (float)itemCount;
            if (totalWidth < FChoiceList.this.getWidth()) {
                width = FChoiceList.this.getWidth() / (float)itemCount;
            }
            return width;
        }

        @Override
        public boolean layoutHorizontal() {
            return true;
        }

        @Override
        public void drawValue(Graphics g2, T value, FSkinFont font, FSkinColor foreColor, boolean pressed, float x, float y, float w, float h2) {
            g2.drawText(FChoiceList.this.getChoiceText(value), font, foreColor, x, y, w, h2, false, 1, true);
        }
    }

    protected class DefaultItemRenderer
    extends ItemRenderer {
        protected DefaultItemRenderer() {
        }

        @Override
        public FSkinFont getDefaultFont() {
            return FSkinFont.get(12);
        }

        @Override
        public float getItemHeight() {
            if (FChoiceList.this.allowDefaultItemWrap()) {
                return DEFAULT_ITEM_HEIGHT * 1.5f;
            }
            return DEFAULT_ITEM_HEIGHT;
        }

        @Override
        public boolean tap(Integer index, T value, float x, float y, int count) {
            return false;
        }

        @Override
        public boolean longPress(Integer index, T value, float x, float y) {
            return false;
        }

        @Override
        public void drawValue(Graphics g2, T value, FSkinFont font, FSkinColor foreColor, boolean pressed, float x, float y, float w, float h2) {
            if (value instanceof CardView) {
                CardRenderer.drawCardListItem(g2, font, foreColor, (CardView)value, 0, null, x, y, w, h2, FChoiceList.this.compactModeHandler.isCompactMode());
            } else if (value != null && value.toString().contains(" {")) {
                int manaStringindex = value.toString().indexOf(" {");
                String title = value.toString().substring(0, manaStringindex - 1);
                String cost = TextUtil.fastReplace(value.toString().substring(manaStringindex), "}{", " ");
                cost = TextUtil.fastReplace(TextUtil.fastReplace(cost, "{", ""), "}", "");
                ManaCost manaCost = new ManaCost(new ManaCostParser(cost));
                CardFaceSymbols.drawManaCost(g2, manaCost, x + font.getBounds((CharSequence)title).width, y + (h2 - CardRenderer.MANA_SYMBOL_SIZE) / 2.0f, CardRenderer.MANA_SYMBOL_SIZE);
                g2.drawText(title, font, foreColor, x, y, w, h2, FChoiceList.this.allowDefaultItemWrap(), 8, true);
            } else if (value != null) {
                g2.drawText(FChoiceList.this.getChoiceText(value), font, foreColor, x, y, w, h2, FChoiceList.this.allowDefaultItemWrap(), 8, true);
            }
        }
    }

    protected abstract class ItemRenderer {
        protected ItemRenderer() {
        }

        public abstract FSkinFont getDefaultFont();

        public abstract float getItemHeight();

        public abstract boolean tap(Integer var1, T var2, float var3, float var4, int var5);

        public abstract boolean longPress(Integer var1, T var2, float var3, float var4);

        public abstract void drawValue(Graphics var1, T var2, FSkinFont var3, FSkinColor var4, boolean var5, float var6, float var7, float var8, float var9);

        public boolean layoutHorizontal() {
            return false;
        }

        public AdvancedSearchFilter<? extends InventoryItem> getAdvancedSearchFilter(ListChooser<T> listChooser) {
            return null;
        }
    }
}

