/*
 * Decompiled with CFR 0.152.
 */
package forge.toolbox;

import com.badlogic.gdx.utils.Timer;
import forge.Forge;
import forge.Graphics;
import forge.assets.FSkinColor;
import forge.assets.FSkinFont;
import forge.assets.FSkinImage;
import forge.gui.UiCommand;
import forge.gui.interfaces.IButton;
import forge.localinstance.skin.FSkinProp;
import forge.toolbox.FDisplayObject;
import forge.toolbox.FEvent;
import forge.toolbox.FLabel;
import forge.util.TextBounds;
import forge.util.Utils;
import org.apache.commons.lang3.StringUtils;

public class FButton
extends FDisplayObject
implements IButton {
    private static final float PADDING = Utils.scale(10.0f);
    private FSkinImage imgL;
    private FSkinImage imgM;
    private FSkinImage imgR;
    private String text;
    private FSkinFont font;
    private FSkinColor foreColor = FButton.getDefaultForeColor();
    private boolean toggled = false;
    private boolean pressed = false;
    private FEvent.FEventHandler command;
    private Corner corner = Corner.None;

    private static FSkinColor getDefaultForeColor() {
        if (Forge.isMobileAdventureMode) {
            return FSkinColor.get(FSkinColor.Colors.ADV_CLR_TEXT);
        }
        return FSkinColor.get(FSkinColor.Colors.CLR_TEXT);
    }

    public FButton() {
        this("", null);
    }

    public FButton(String text0) {
        this(text0, null);
    }

    public FButton(String text0, FEvent.FEventHandler command0) {
        this.text = text0;
        this.command = command0;
        this.font = FSkinFont.get(14);
        this.resetImg();
    }

    private boolean hdbuttonskin() {
        return Forge.hdbuttons;
    }

    private void resetImg() {
        this.imgL = FSkinImage.BTN_UP_LEFT;
        this.imgM = FSkinImage.BTN_UP_CENTER;
        this.imgR = FSkinImage.BTN_UP_RIGHT;
        if (Forge.isMobileAdventureMode) {
            this.imgL = FSkinImage.ADV_BTN_UP_LEFT;
            this.imgM = FSkinImage.ADV_BTN_UP_CENTER;
            this.imgR = FSkinImage.ADV_BTN_UP_RIGHT;
        } else if (this.hdbuttonskin()) {
            this.imgL = FSkinImage.HDBTN_UP_LEFT;
            this.imgM = FSkinImage.HDBTN_UP_CENTER;
            this.imgR = FSkinImage.HDBTN_UP_RIGHT;
        } else {
            this.imgL = FSkinImage.BTN_UP_LEFT;
            this.imgM = FSkinImage.BTN_UP_CENTER;
            this.imgR = FSkinImage.BTN_UP_RIGHT;
        }
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public void setText(String text0) {
        this.text = text0;
    }

    public FSkinFont getFont() {
        return this.font;
    }

    public void setFont(FSkinFont font0) {
        this.font = font0;
    }

    @Override
    public void setEnabled(boolean b0) {
        if (this.isEnabled() == b0) {
            return;
        }
        super.setEnabled(b0);
        if (b0) {
            this.resetImg();
        } else {
            this.imgL = FSkinImage.BTN_DISABLED_LEFT;
            this.imgM = FSkinImage.BTN_DISABLED_CENTER;
            this.imgR = FSkinImage.BTN_DISABLED_RIGHT;
            if (Forge.isMobileAdventureMode) {
                this.imgL = FSkinImage.ADV_BTN_DISABLED_LEFT;
                this.imgM = FSkinImage.ADV_BTN_DISABLED_CENTER;
                this.imgR = FSkinImage.ADV_BTN_DISABLED_RIGHT;
            } else if (this.hdbuttonskin()) {
                this.imgL = FSkinImage.HDBTN_DISABLED_LEFT;
                this.imgM = FSkinImage.HDBTN_DISABLED_CENTER;
                this.imgR = FSkinImage.HDBTN_DISABLED_RIGHT;
            } else {
                this.imgL = FSkinImage.BTN_DISABLED_LEFT;
                this.imgM = FSkinImage.BTN_DISABLED_CENTER;
                this.imgR = FSkinImage.BTN_DISABLED_RIGHT;
            }
        }
    }

    public boolean isToggled() {
        return this.toggled;
    }

    public void setToggled(boolean b0) {
        if (this.toggled == b0) {
            return;
        }
        this.toggled = b0;
        if (this.toggled) {
            this.imgL = FSkinImage.BTN_TOGGLE_LEFT;
            this.imgM = FSkinImage.BTN_TOGGLE_CENTER;
            this.imgR = FSkinImage.BTN_TOGGLE_RIGHT;
            if (Forge.isMobileAdventureMode) {
                this.imgL = FSkinImage.ADV_BTN_TOGGLE_LEFT;
                this.imgM = FSkinImage.ADV_BTN_TOGGLE_CENTER;
                this.imgR = FSkinImage.ADV_BTN_TOGGLE_RIGHT;
            } else if (this.hdbuttonskin()) {
                this.imgL = FSkinImage.HDBTN_TOGGLE_LEFT;
                this.imgM = FSkinImage.HDBTN_TOGGLE_CENTER;
                this.imgR = FSkinImage.HDBTN_TOGGLE_RIGHT;
            } else {
                this.imgL = FSkinImage.BTN_TOGGLE_LEFT;
                this.imgM = FSkinImage.BTN_TOGGLE_CENTER;
                this.imgR = FSkinImage.BTN_TOGGLE_RIGHT;
            }
        } else if (this.isEnabled()) {
            this.resetImg();
        } else {
            this.imgL = FSkinImage.BTN_DISABLED_LEFT;
            this.imgM = FSkinImage.BTN_DISABLED_CENTER;
            this.imgR = FSkinImage.BTN_DISABLED_RIGHT;
            if (Forge.isMobileAdventureMode) {
                this.imgL = FSkinImage.ADV_BTN_DISABLED_LEFT;
                this.imgM = FSkinImage.ADV_BTN_DISABLED_CENTER;
                this.imgR = FSkinImage.ADV_BTN_DISABLED_RIGHT;
            } else if (this.hdbuttonskin()) {
                this.imgL = FSkinImage.HDBTN_DISABLED_LEFT;
                this.imgM = FSkinImage.HDBTN_DISABLED_CENTER;
                this.imgR = FSkinImage.HDBTN_DISABLED_RIGHT;
            } else {
                this.imgL = FSkinImage.BTN_DISABLED_LEFT;
                this.imgM = FSkinImage.BTN_DISABLED_CENTER;
                this.imgR = FSkinImage.BTN_DISABLED_RIGHT;
            }
        }
    }

    public Corner getCorner() {
        return this.corner;
    }

    public void setCorner(Corner corner0) {
        this.corner = corner0;
    }

    public void setCommand(FEvent.FEventHandler command0) {
        this.command = command0;
    }

    public TextBounds getAutoSizeBounds() {
        TextBounds bounds = new TextBounds();
        bounds.width = this.font.getBounds((CharSequence)this.text).width + 2.0f * PADDING;
        bounds.height = 3.0f * this.font.getCapHeight();
        return bounds;
    }

    @Override
    public final boolean press(float x, float y) {
        this.pressed = true;
        if (this.isToggled()) {
            return true;
        }
        this.imgL = FSkinImage.BTN_DOWN_LEFT;
        this.imgM = FSkinImage.BTN_DOWN_CENTER;
        this.imgR = FSkinImage.BTN_DOWN_RIGHT;
        if (Forge.isMobileAdventureMode) {
            this.imgL = FSkinImage.ADV_BTN_DOWN_LEFT;
            this.imgM = FSkinImage.ADV_BTN_DOWN_CENTER;
            this.imgR = FSkinImage.ADV_BTN_DOWN_RIGHT;
        } else if (this.hdbuttonskin()) {
            this.imgL = FSkinImage.HDBTN_DOWN_LEFT;
            this.imgM = FSkinImage.HDBTN_DOWN_CENTER;
            this.imgR = FSkinImage.HDBTN_DOWN_RIGHT;
        } else {
            this.imgL = FSkinImage.BTN_DOWN_LEFT;
            this.imgM = FSkinImage.BTN_DOWN_CENTER;
            this.imgR = FSkinImage.BTN_DOWN_RIGHT;
        }
        return true;
    }

    @Override
    public final boolean release(float x, float y) {
        this.pressed = false;
        if (this.isToggled()) {
            return true;
        }
        this.resetImg();
        return true;
    }

    @Override
    public final boolean tap(float x, float y, int count) {
        if (this.command != null) {
            this.command.handleEvent(new FEvent(this, FEvent.FEventType.TAP));
        }
        return true;
    }

    public boolean trigger() {
        if (this.isEnabled() && this.command != null) {
            final FEvent fEvent = new FEvent(this, FEvent.FEventType.TAP);
            if (Forge.hasGamepad()) {
                this.press(0.0f, 0.0f);
                Timer.schedule(new Timer.Task(){

                    @Override
                    public void run() {
                        FButton.this.command.handleEvent(fEvent);
                        FButton.this.release(0.0f, 0.0f);
                    }
                }, 0.1f);
                return true;
            }
            this.command.handleEvent(fEvent);
            return true;
        }
        return false;
    }

    @Override
    public void draw(Graphics g2) {
        float x = 0.0f;
        float y = 0.0f;
        float w = this.getWidth();
        float h2 = this.getHeight();
        float cornerButtonWidth = w / 2.0f;
        float cornerButtonHeight = h2 * 1.5f;
        float cornerTextOffsetX = cornerButtonWidth / 2.0f;
        float cornerTextOffsetY = (cornerButtonHeight - h2) / 2.0f;
        if (this.imgL.getTextureRegion() == null) {
            FLabel.drawButtonBackground(g2, w, h2, this.imgL == FSkinImage.BTN_DOWN_LEFT);
        } else {
            FSkinImage btnOverR;
            FSkinImage btnOverL = this.hdbuttonskin() ? FSkinImage.HDBTN_OVER_LEFT : FSkinImage.BTN_OVER_LEFT;
            FSkinImage btnOverC = this.hdbuttonskin() ? FSkinImage.HDBTN_OVER_CENTER : FSkinImage.BTN_OVER_CENTER;
            FSkinImage fSkinImage = btnOverR = this.hdbuttonskin() ? FSkinImage.HDBTN_OVER_RIGHT : FSkinImage.BTN_OVER_RIGHT;
            if (Forge.isMobileAdventureMode) {
                btnOverL = FSkinImage.ADV_BTN_OVER_LEFT;
                btnOverC = FSkinImage.ADV_BTN_OVER_CENTER;
                btnOverR = FSkinImage.ADV_BTN_OVER_RIGHT;
            }
            switch (this.corner) {
                case None: {
                    if (w > 2.0f * h2) {
                        g2.drawImage(this.isHovered() && !this.pressed ? btnOverL : this.imgL, 0.0f, 0.0f, h2, h2);
                        g2.drawImage(this.isHovered() && !this.pressed ? btnOverC : this.imgM, h2, 0.0f, w - 2.0f * h2, h2);
                        g2.drawImage(this.isHovered() && !this.pressed ? btnOverR : this.imgR, w - h2, 0.0f, h2, h2);
                    } else {
                        g2.drawImage(this.isHovered() && !this.pressed ? btnOverL : this.imgL, 0.0f, 0.0f, cornerButtonWidth, h2);
                        g2.drawImage(this.isHovered() && !this.pressed ? btnOverR : this.imgR, cornerButtonWidth, 0.0f, w - cornerButtonWidth, h2);
                    }
                    x += PADDING;
                    w -= 2.0f * PADDING;
                    break;
                }
                case BottomLeft: {
                    g2.startClip(x, y, w, h2);
                    g2.drawImage(this.isHovered() && !this.pressed ? btnOverC : this.imgM, 0.0f, 0.0f, cornerButtonWidth, cornerButtonHeight);
                    g2.drawImage(this.isHovered() && !this.pressed ? btnOverR : this.imgR, cornerButtonWidth, 0.0f, cornerButtonWidth, cornerButtonHeight);
                    g2.endClip();
                    w -= cornerTextOffsetX;
                    y += cornerTextOffsetY;
                    h2 -= cornerTextOffsetY;
                    break;
                }
                case BottomRight: {
                    g2.startClip(x, y, w, h2);
                    g2.drawImage(this.isHovered() && !this.pressed ? btnOverL : this.imgL, 0.0f, 0.0f, cornerButtonWidth, cornerButtonHeight);
                    g2.drawImage(this.isHovered() && !this.pressed ? btnOverC : this.imgM, cornerButtonWidth, 0.0f, cornerButtonWidth, cornerButtonHeight);
                    g2.endClip();
                    x += cornerTextOffsetX;
                    w -= cornerTextOffsetX;
                    y += cornerTextOffsetY;
                    h2 -= cornerTextOffsetY;
                    break;
                }
                case BottomMiddle: {
                    g2.startClip(x, y, w, h2);
                    cornerButtonWidth = w / 3.0f;
                    cornerTextOffsetX = cornerButtonWidth / 2.0f;
                    g2.drawImage(this.isHovered() && !this.pressed ? btnOverL : this.imgL, 0.0f, 0.0f, cornerButtonWidth, cornerButtonHeight);
                    g2.drawImage(this.isHovered() && !this.pressed ? btnOverC : this.imgM, cornerButtonWidth, 0.0f, w - 2.0f * cornerButtonWidth, cornerButtonHeight);
                    g2.drawImage(this.isHovered() && !this.pressed ? btnOverR : this.imgR, w - cornerButtonWidth, 0.0f, cornerButtonWidth, cornerButtonHeight);
                    g2.endClip();
                    x += cornerTextOffsetX / 2.0f;
                    w -= cornerTextOffsetX;
                    y += cornerTextOffsetY;
                    h2 -= cornerTextOffsetY;
                }
            }
        }
        String displayText = this.text;
        if (!StringUtils.isEmpty(displayText)) {
            if (this.corner == Corner.BottomLeft || this.corner == Corner.BottomRight) {
                displayText = displayText.replaceFirst(" ", "\n");
            }
            g2.drawText(displayText, this.font, this.foreColor, x, y, w, h2, false, 1, true);
        }
    }

    @Override
    public boolean isSelected() {
        return this.isToggled();
    }

    @Override
    public void setSelected(boolean b0) {
        this.setToggled(b0);
    }

    @Override
    public boolean keyDown(int keyCode) {
        switch (keyCode) {
            case 62: 
            case 66: {
                return this.trigger();
            }
        }
        return false;
    }

    @Override
    public void setCommand(UiCommand command0) {
        this.setCommand((FEvent e) -> command0.run());
    }

    @Override
    public boolean requestFocusInWindow() {
        return false;
    }

    @Override
    public void setImage(FSkinProp color) {
        this.foreColor = FSkinColor.get(FSkinColor.Colors.fromSkinProp(color));
    }

    @Override
    public void setTextColor(int r, int g2, int b) {
        this.foreColor = FSkinColor.getStandardColor(r, g2, b);
    }

    public FSkinColor getForeColor() {
        return this.foreColor;
    }

    public static enum Corner {
        None,
        BottomLeft,
        BottomRight,
        BottomMiddle;

    }
}

